/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.List;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.ast.BindingFinder;
import org.python.indexer.ast.NBlock;
import org.python.indexer.ast.NBody;
import org.python.indexer.ast.NFunctionDef;
import org.python.indexer.ast.NName;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.ast.NameBinder;
import org.python.indexer.types.NFuncType;
import org.python.indexer.types.NTupleType;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

public final class NLambda
extends NFunctionDef {
    private NName fname;

    public NLambda(List<NNode> args, NNode body, List<NNode> defaults, NName varargs, NName kwargs) {
        this(null, null, null, null, null, 0, 1);
    }

    public NLambda(List<NNode> args, NNode body, List<NNode> defaults, NName varargs, NName kwargs, int start, int end) {
        super(null, args, null, defaults, varargs, kwargs, start, end);
        this.body = body instanceof NBlock ? new NBody((NBlock)body) : body;
        this.addChildren(this.body);
    }

    @Override
    protected final String getBindingName(Scope s) {
        if (this.fname != null) {
            return this.fname.id;
        }
        String fn = s.newLambdaName();
        this.fname = new NName(fn, this.start(), this.start() + 6);
        this.fname.setParent(this);
        return fn;
    }

    @Override
    protected final void bindFunctionName(Scope owner) throws Exception {
        NameBinder.make(NBinding.Kind.FUNCTION).bindName(owner, this.fname, this.getType());
    }

    @Override
    protected final void bindMethodAttrs(Scope owner) throws Exception {
    }

    @Override
    public final NType resolve(Scope s) throws Exception {
        NUnknownType u;
        NType nType = this.getType();
        if (!(nType instanceof NFuncType)) {
            Indexer.idx.reportFailedAssertion("Bad type on " + this + ": type=" + this.getType() + " in file " + this.getFile() + " at " + this.start());
        }
        NTupleType fromType = new NTupleType();
        NameBinder param = NameBinder.make(NBinding.Kind.PARAMETER);
        NLambda.resolveList(this.defaults, s);
        Scope funcTable = this.getTable();
        int argnum = 0;
        for (NNode a : this.args) {
            NType argtype = NFunctionDef.getArgType(this.args, this.defaults, argnum++);
            param.bind(funcTable, a, argtype);
            fromType.add(argtype);
        }
        if (this.varargs != null) {
            u = new NUnknownType();
            param.bind(funcTable, this.varargs, (NType)u);
            fromType.add(u);
        }
        if (this.kwargs != null) {
            u = new NUnknownType();
            param.bind(funcTable, this.kwargs, (NType)u);
            fromType.add(u);
        }
        try {
            funcTable.setNameBindingPhase(true);
            this.body.visit(new BindingFinder(funcTable));
        }
        finally {
            funcTable.setNameBindingPhase(false);
        }
        NType toType = NLambda.resolveExpr(this.body, funcTable);
        nType = this.getType();
        if (nType instanceof NFuncType) {
            nType = this.getType();
            ((NFuncType)nType).setReturnType(toType);
        }
        return this.getType();
    }

    @Override
    public final String toString() {
        return "<Lambda:" + this.start() + ":" + this.args + ":" + this.body + ">";
    }

    @Override
    public final void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            NLambda.visitNodeList(this.args, v);
            NLambda.visitNodeList(this.defaults, v);
            NLambda.visitNode(this.varargs, v);
            NLambda.visitNode(this.kwargs, v);
            NLambda.visitNode(this.body, v);
        }
    }
}

