/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.process;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import net.grinder.common.FilenameFactory;
import net.grinder.common.SSLContextFactory;
import net.grinder.common.SkeletonThreadLifeCycleListener;
import net.grinder.common.Test;
import net.grinder.common.ThreadLifeCycleListener;
import net.grinder.engine.common.EngineException;
import net.grinder.engine.process.DispatchContext;
import net.grinder.engine.process.DispatchResultReporter;
import net.grinder.engine.process.ProcessContext;
import net.grinder.engine.process.ShutdownException;
import net.grinder.engine.process.ThreadContext;
import net.grinder.engine.process.ThreadDataWriter;
import net.grinder.engine.process.ThreadLogger;
import net.grinder.plugininterface.PluginThreadContext;
import net.grinder.script.Statistics;
import net.grinder.statistics.StatisticsSet;
import net.grinder.util.ListenerSupport;

final class ThreadContextImplementation
implements ThreadContext,
PluginThreadContext {
    private final ListenerSupport m_threadLifeCycleListeners = new ListenerSupport();
    private final DispatchContextStack m_dispatchContextStack = new DispatchContextStack();
    private final ThreadLogger m_threadLogger;
    private final FilenameFactory m_filenameFactory;
    private final DispatchResultReporter m_dispatchResultReporter;
    private SSLContextFactory m_sslContextFactory;
    private boolean m_delayReports;
    private DispatchContext m_pendingDispatchContext;
    private Statistics.StatisticsForTest m_statisticsForLastTest;
    private volatile boolean m_shutdown;
    private boolean m_shutdownInProgress;

    public ThreadContextImplementation(ProcessContext processContext, ThreadLogger threadLogger, FilenameFactory filenameFactory, PrintWriter dataWriter) throws EngineException {
        this.m_threadLogger = threadLogger;
        this.m_filenameFactory = filenameFactory;
        if (processContext.getProperties().getBoolean("grinder.logData", true)) {
            final ThreadDataWriter threadDataWriter = new ThreadDataWriter(dataWriter, processContext.getStatisticsServices().getDetailStatisticsView().getExpressionViews(), this.m_threadLogger.getThreadNumber());
            this.m_dispatchResultReporter = new DispatchResultReporter(){

                public void report(Test test, long startTime, StatisticsSet statistics) {
                    threadDataWriter.report(ThreadContextImplementation.this.getRunNumber(), test, startTime, statistics);
                }
            };
        } else {
            this.m_dispatchResultReporter = new DispatchResultReporter(){

                public void report(Test test, long startTime, StatisticsSet statistics) {
                }
            };
        }
        this.registerThreadLifeCycleListener(new SkeletonThreadLifeCycleListener(){

            public void endRun() {
                ThreadContextImplementation.this.reportPendingDispatchContext();
            }
        });
    }

    public FilenameFactory getFilenameFactory() {
        return this.m_filenameFactory;
    }

    public int getThreadNumber() {
        return this.m_threadLogger.getThreadNumber();
    }

    public int getRunNumber() {
        return this.m_threadLogger.getCurrentRunNumber();
    }

    public ThreadLogger getThreadLogger() {
        return this.m_threadLogger;
    }

    public SSLContextFactory getThreadSSLContextFactory() {
        return this.m_sslContextFactory;
    }

    public void setThreadSSLContextFactory(SSLContextFactory sslContextFactory) {
        this.m_sslContextFactory = sslContextFactory;
    }

    public DispatchResultReporter getDispatchResultReporter() {
        return this.m_dispatchResultReporter;
    }

    public void registerThreadLifeCycleListener(ThreadLifeCycleListener listener) {
        this.m_threadLifeCycleListeners.add(listener);
    }

    public void fireBeginThreadEvent() {
        this.m_threadLifeCycleListeners.apply(new ListenerSupport.Informer(){

            public void inform(Object listener) {
                ((ThreadLifeCycleListener)listener).beginThread();
            }
        });
    }

    public void fireBeginRunEvent() {
        this.m_threadLifeCycleListeners.apply(new ListenerSupport.Informer(){

            public void inform(Object listener) {
                ((ThreadLifeCycleListener)listener).beginRun();
            }
        });
    }

    public void fireEndRunEvent() {
        this.m_threadLifeCycleListeners.apply(new ListenerSupport.Informer(){

            public void inform(Object listener) {
                ((ThreadLifeCycleListener)listener).endRun();
            }
        });
    }

    public void fireBeginShutdownEvent() {
        this.m_threadLifeCycleListeners.apply(new ListenerSupport.Informer(){

            public void inform(Object listener) {
                ((ThreadLifeCycleListener)listener).beginShutdown();
            }
        });
    }

    public void fireEndThreadEvent() {
        this.m_threadLifeCycleListeners.apply(new ListenerSupport.Informer(){

            public void inform(Object listener) {
                ((ThreadLifeCycleListener)listener).endThread();
            }
        });
    }

    public void pushDispatchContext(DispatchContext dispatchContext) throws ShutdownException {
        if (this.m_shutdown && !this.m_shutdownInProgress) {
            this.m_shutdownInProgress = true;
            throw new ShutdownException("Thread has been shut down");
        }
        this.reportPendingDispatchContext();
        this.getThreadLogger().setCurrentTestNumber(dispatchContext.getTest().getNumber());
        DispatchContext existingContext = this.m_dispatchContextStack.peekTop();
        if (existingContext != null) {
            existingContext.setHasNestedContexts();
        }
        this.m_dispatchContextStack.push(dispatchContext);
    }

    public void popDispatchContext() {
        DispatchContext dispatchContext = this.m_dispatchContextStack.pop();
        if (dispatchContext == null) {
            throw new AssertionError((Object)"DispatchContext stack unexpectedly empty");
        }
        DispatchContext parentDispatchContext = this.m_dispatchContextStack.peekTop();
        if (parentDispatchContext != null) {
            parentDispatchContext.getPauseTimer().add(dispatchContext.getPauseTimer());
        }
        this.m_statisticsForLastTest = dispatchContext.getStatisticsForTest();
        this.reportPendingDispatchContext();
        if (this.m_delayReports) {
            this.m_pendingDispatchContext = dispatchContext;
        } else {
            try {
                dispatchContext.report();
            }
            catch (DispatchContext.DispatchStateException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public Statistics.StatisticsForTest getStatisticsForCurrentTest() {
        DispatchContext dispatchContext = this.m_dispatchContextStack.peekTop();
        if (dispatchContext == null) {
            return null;
        }
        return dispatchContext.getStatisticsForTest();
    }

    public Statistics.StatisticsForTest getStatisticsForLastTest() {
        return this.m_statisticsForLastTest;
    }

    public void setDelayReports(boolean b) {
        if (!b) {
            this.reportPendingDispatchContext();
        }
        this.m_delayReports = b;
    }

    public void reportPendingDispatchContext() {
        if (this.m_pendingDispatchContext != null) {
            try {
                this.m_pendingDispatchContext.report();
            }
            catch (DispatchContext.DispatchStateException e) {
                throw new AssertionError((Object)e);
            }
            this.m_pendingDispatchContext = null;
        }
    }

    public void pauseClock() {
        DispatchContext dispatchContext = this.m_dispatchContextStack.peekTop();
        if (dispatchContext != null) {
            dispatchContext.getPauseTimer().start();
        }
    }

    public void resumeClock() {
        DispatchContext dispatchContext = this.m_dispatchContextStack.peekTop();
        if (dispatchContext != null) {
            dispatchContext.getPauseTimer().stop();
        }
    }

    public void shutdown() {
        this.m_shutdown = true;
    }

    private static final class DispatchContextStack {
        private final List m_stack = new ArrayList();

        private DispatchContextStack() {
        }

        public void push(DispatchContext dispatchContext) {
            this.m_stack.add(dispatchContext);
        }

        public DispatchContext pop() {
            int size = this.m_stack.size();
            if (size == 0) {
                return null;
            }
            return (DispatchContext)this.m_stack.remove(size - 1);
        }

        public DispatchContext peekTop() {
            int size = this.m_stack.size();
            if (size == 0) {
                return null;
            }
            return (DispatchContext)this.m_stack.get(size - 1);
        }
    }
}

