/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.swingui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

final class Table
extends JTable {
    private final MyCellRenderer m_cellRenderer = new MyCellRenderer();
    private final TableCellRenderer m_headerRenderer = new MyHeaderRenderer();
    private final Font m_boldFont;
    private final Font m_plainFont;
    private final Color m_defaultForeground;
    private final Color m_defaultBackground;

    public Table(TableModel tableModel) {
        super(tableModel);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(true);
        this.setDragEnabled(true);
        this.m_defaultForeground = this.m_cellRenderer.getForeground();
        this.m_defaultBackground = this.m_cellRenderer.getBackground();
        this.m_plainFont = this.m_cellRenderer.getFont().deriveFont(0);
        this.m_cellRenderer.setFont(this.m_plainFont);
        this.m_boldFont = this.m_cellRenderer.getFont().deriveFont(1);
        this.createDefaultColumnsFromModel();
    }

    public void addColumn(TableColumn column) {
        column.setHeaderRenderer(this.m_headerRenderer);
        super.addColumn(column);
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        TableModel model = (TableModel)this.getModel();
        int modelColumn = this.getColumnModel().getColumn(column).getModelIndex();
        Color foreground = model.getForeground(row, modelColumn);
        Color background = model.getBackground(row, modelColumn);
        boolean bold = model.isBold(row, modelColumn);
        if (foreground == null && background == null && !bold) {
            return super.getCellRenderer(row, column);
        }
        this.m_cellRenderer.setForeground(foreground != null ? foreground : this.m_defaultForeground);
        this.m_cellRenderer.setBackground(background != null ? background : this.m_defaultBackground);
        this.m_cellRenderer.setTheFont(bold ? this.m_boldFont : this.m_plainFont);
        return this.m_cellRenderer;
    }

    private static final class MyHeaderRenderer
    implements TableCellRenderer {
        private final JTextArea m_textArea = new JTextArea();

        private MyHeaderRenderer() {
            this.m_textArea.setLineWrap(true);
            this.m_textArea.setWrapStyleWord(true);
            this.m_textArea.setOpaque(false);
            this.m_textArea.setEditable(false);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (table != null) {
                JTableHeader header = table.getTableHeader();
                if (header != null) {
                    this.m_textArea.setForeground(header.getForeground());
                    this.m_textArea.setBackground(header.getBackground());
                    this.m_textArea.setFont(header.getFont());
                }
                this.m_textArea.setSize(table.getColumnModel().getColumn(column).getWidth(), Integer.MAX_VALUE);
            }
            this.m_textArea.setText(value == null ? "" : value.toString());
            this.m_textArea.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this.m_textArea;
        }
    }

    private static final class MyCellRenderer
    extends DefaultTableCellRenderer {
        private Font m_font;

        private MyCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            DefaultTableCellRenderer defaultRenderer = (DefaultTableCellRenderer)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            defaultRenderer.setFont(this.m_font);
            return defaultRenderer;
        }

        public void setTheFont(Font f) {
            this.m_font = f;
        }
    }

    public static interface TableModel
    extends javax.swing.table.TableModel {
        public boolean isBold(int var1, int var2);

        public Color getForeground(int var1, int var2);

        public Color getBackground(int var1, int var2);
    }
}

