/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.agent;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import net.grinder.common.UncheckedInterruptedException;
import net.grinder.common.processidentity.WorkerIdentity;
import net.grinder.engine.agent.AgentIdentityImplementation;
import net.grinder.engine.agent.Worker;

final class DebugThreadWorker
implements Worker {
    private final AgentIdentityImplementation.WorkerIdentityImplementation m_workerIdentity;
    private final Thread m_thread;
    private final PipedOutputStream m_communicationStream;
    private int m_result;

    public DebugThreadWorker(AgentIdentityImplementation.WorkerIdentityImplementation workerIdentity, final IsolateGrinderProcessRunner runner) {
        PipedInputStream inputStream;
        this.m_workerIdentity = workerIdentity;
        this.m_communicationStream = new PipedOutputStream();
        try {
            inputStream = new PipedInputStream(this.m_communicationStream);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        this.m_thread = new Thread(workerIdentity.getName()){

            public void run() {
                DebugThreadWorker.this.m_result = runner.run(inputStream);
            }
        };
        this.m_thread.setDaemon(true);
        this.m_thread.start();
    }

    public WorkerIdentity getIdentity() {
        return this.m_workerIdentity;
    }

    public OutputStream getCommunicationStream() {
        return this.m_communicationStream;
    }

    public int waitFor() {
        try {
            this.m_thread.join();
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException(e);
        }
        return this.m_result;
    }

    public void destroy() {
        this.m_thread.interrupt();
    }

    public static interface IsolateGrinderProcessRunner {
        public int run(InputStream var1);
    }
}

