/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.util;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import jnr.ffi.mapper.AbstractDataConverter;
import jnr.ffi.mapper.FromNativeContext;
import jnr.ffi.mapper.ToNativeContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EnumMapper
extends AbstractDataConverter<Enum, Integer> {
    private final Class<? extends Enum> enumClass;
    private final int[] intValues;
    private final long[] longValues;
    private final Map<Number, Enum> reverseLookupMap = new HashMap<Number, Enum>();

    private EnumMapper(Class<? extends Enum> enumClass) {
        this.enumClass = enumClass;
        EnumSet<? extends Enum> enums = EnumSet.allOf(enumClass);
        this.intValues = new int[enums.size()];
        this.longValues = new long[enums.size()];
        Method intValueMethod = EnumMapper.getNumberValueMethod(enumClass, Integer.TYPE);
        Method longValueMethod = EnumMapper.getNumberValueMethod(enumClass, Long.TYPE);
        for (Enum enum_ : enums) {
            Number value = longValueMethod != null ? (Number)EnumMapper.reflectedNumberValue(enum_, longValueMethod) : (Number)(intValueMethod != null ? (Number)EnumMapper.reflectedNumberValue(enum_, intValueMethod) : (Number)enum_.ordinal());
            this.intValues[enum_.ordinal()] = value.intValue();
            this.longValues[enum_.ordinal()] = value.longValue();
            this.reverseLookupMap.put(value, enum_);
        }
    }

    @Override
    public final Enum fromNative(Integer nativeValue, FromNativeContext context) {
        return this.valueOf(nativeValue);
    }

    @Override
    public final Class<Integer> nativeType() {
        return Integer.class;
    }

    @Override
    public final Integer toNative(Enum value, ToNativeContext context) {
        return this.intValue(this.enumClass.cast(value));
    }

    public static EnumMapper getInstance(Class<? extends Enum> enumClass) {
        EnumMapper mapper = (EnumMapper)StaticDataHolder.MAPPERS.get(enumClass);
        if (mapper != null) {
            return mapper;
        }
        return EnumMapper.addMapper(enumClass);
    }

    private static synchronized EnumMapper addMapper(Class<? extends Enum> enumClass) {
        EnumMapper mapper = new EnumMapper(enumClass);
        IdentityHashMap<Class<? extends Enum>, EnumMapper> tmp = new IdentityHashMap<Class<? extends Enum>, EnumMapper>(StaticDataHolder.MAPPERS);
        tmp.put(enumClass, mapper);
        StaticDataHolder.MAPPERS = tmp;
        return mapper;
    }

    private static Method getNumberValueMethod(Class c, Class numberClass) {
        try {
            Method m = c.getDeclaredMethod(numberClass.getSimpleName() + "Value", new Class[0]);
            if (m != null && numberClass == m.getReturnType()) {
                return m;
            }
            return null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Number reflectedNumberValue(Enum e, Method m) {
        try {
            return (Number)m.invoke((Object)e, new Object[0]);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public final int intValue(Enum value) {
        if (value.getClass() != this.enumClass) {
            throw new IllegalArgumentException("enum class mismatch, " + value.getClass());
        }
        return this.intValues[value.ordinal()];
    }

    public final long longValue(Enum value) {
        if (value.getClass() != this.enumClass) {
            throw new IllegalArgumentException("enum class mismatch, " + value.getClass());
        }
        return this.longValues[value.ordinal()];
    }

    public final Enum valueOf(int value) {
        return this.reverseLookup(value);
    }

    public final Enum valueOf(long value) {
        return this.reverseLookup(value);
    }

    public final Enum valueOf(Number value) {
        return this.reverseLookup(value);
    }

    private Enum reverseLookup(Number value) {
        Enum e = this.reverseLookupMap.get(value);
        if (e != null) {
            return e;
        }
        return this.badValue(value);
    }

    private Enum badValue(Number value) {
        try {
            return Enum.valueOf(this.enumClass, "__UNKNOWN_NATIVE_VALUE");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("No known Enum mapping for value " + value + " of type " + this.enumClass.getName());
        }
    }

    public static interface IntegerEnum {
        public int intValue();
    }

    static final class StaticDataHolder {
        private static volatile Map<Class<? extends Enum>, EnumMapper> MAPPERS = Collections.emptyMap();

        private StaticDataHolder() {
        }
    }
}

