/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import org.python.indexer.Scope;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NType;

public final class NRaise
extends NNode {
    private NNode exceptionType;
    private NNode inst;
    private NNode traceback;

    public NRaise(NNode exceptionType, NNode inst, NNode traceback) {
        this(null, null, null, 0, 1);
    }

    public NRaise(NNode exceptionType, NNode inst, NNode traceback, int start, int end) {
        super(start, end);
        this.exceptionType = exceptionType;
        this.inst = inst;
        this.traceback = traceback;
        this.addChildren(exceptionType, inst, traceback);
    }

    @Override
    public final NType resolve(Scope s) throws Exception {
        NRaise.resolveExpr(this.exceptionType, s);
        NRaise.resolveExpr(this.inst, s);
        NRaise.resolveExpr(this.traceback, s);
        return this.getType();
    }

    public final String toString() {
        return "<Raise:" + this.traceback + ":" + this.exceptionType + ">";
    }

    @Override
    public final void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            NRaise.visitNode(this.exceptionType, v);
            NRaise.visitNode(this.inst, v);
            NRaise.visitNode(this.traceback, v);
        }
    }
}

