/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import java.util.Map;
import javax.annotation.Nullable;
import org.python.google.common.collect.ImmutableCollection;
import org.python.google.common.collect.ImmutableList;
import org.python.google.common.collect.ImmutableMap;
import org.python.google.common.collect.ImmutableSet;
import org.python.google.common.collect.Maps;

final class SingletonImmutableMap<K, V>
extends ImmutableMap<K, V> {
    private transient K singleKey;
    private transient V singleValue;

    private SingletonImmutableMap(K singleKey, V singleValue) {
        this.singleKey = singleKey;
        this.singleValue = singleValue;
    }

    SingletonImmutableMap(Map.Entry<K, V> entry) {
        this(entry.getKey(), entry.getValue());
    }

    @Override
    public final V get(@Nullable Object key) {
        if (this.singleKey.equals(key)) {
            return this.singleValue;
        }
        return null;
    }

    @Override
    public final int size() {
        return 1;
    }

    @Override
    public final boolean isEmpty() {
        return false;
    }

    @Override
    public final boolean containsKey(@Nullable Object key) {
        return this.singleKey.equals(key);
    }

    @Override
    public final boolean containsValue(@Nullable Object value) {
        return this.singleValue.equals(value);
    }

    @Override
    final ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return ImmutableSet.of(Maps.immutableEntry(this.singleKey, this.singleValue));
    }

    @Override
    final ImmutableSet<K> createKeySet() {
        return ImmutableSet.of(this.singleKey);
    }

    @Override
    final ImmutableCollection<V> createValues() {
        return ImmutableList.of(this.singleValue);
    }

    @Override
    public final boolean equals(@Nullable Object object) {
        Map that;
        if (object == this) {
            return true;
        }
        if (object instanceof Map && (that = (Map)object).size() == 1) {
            Map.Entry entry = that.entrySet().iterator().next();
            return this.singleKey.equals(entry.getKey()) && this.singleValue.equals(entry.getValue());
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return this.singleKey.hashCode() ^ this.singleValue.hashCode();
    }
}

