/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Invoker;
import com.kenai.jffi.Platform;
import jnr.ffi.NativeType;
import jnr.ffi.Pointer;
import jnr.ffi.Struct;
import jnr.ffi.provider.jffi.AbstractFastNumericMethodGenerator;
import jnr.ffi.provider.jffi.BufferMethodGenerator;
import jnr.ffi.provider.jffi.CodegenUtils;
import jnr.ffi.provider.jffi.NumberUtil;
import jnr.ffi.provider.jffi.ParameterType;
import jnr.ffi.provider.jffi.ResultType;
import jnr.ffi.provider.jffi.SigType;

final class FastIntMethodGenerator
extends AbstractFastNumericMethodGenerator {
    private static final boolean ENABLED = FastIntMethodGenerator.getBooleanProperty("jnr.ffi.fast-int.enabled", true);
    private static final int MAX_FASTINT_PARAMETERS = FastIntMethodGenerator.getMaximumFastIntParameters();
    private static final String[] signatures;
    private static final String[] methodNames;

    FastIntMethodGenerator(BufferMethodGenerator bufgen) {
        super(bufgen);
    }

    final String getInvokerMethodName$5974725e(ParameterType[] parameterTypes) {
        int parameterCount = parameterTypes.length;
        if (parameterCount <= MAX_FASTINT_PARAMETERS && parameterCount <= methodNames.length) {
            return methodNames[parameterCount];
        }
        throw new IllegalArgumentException("invalid fast-int parameter count: " + parameterCount);
    }

    final String getInvokerSignature$15ec99b1(int parameterCount) {
        if (parameterCount <= MAX_FASTINT_PARAMETERS && parameterCount <= signatures.length) {
            return signatures[parameterCount];
        }
        throw new IllegalArgumentException("invalid fast-int parameter count: " + parameterCount);
    }

    final Class getInvokerType() {
        return Integer.TYPE;
    }

    public final boolean isSupported(ResultType resultType, ParameterType[] parameterTypes, CallingConvention callingConvention) {
        Platform platform;
        SigType sigType;
        int parameterCount = parameterTypes.length;
        if (!ENABLED) {
            return false;
        }
        if (!callingConvention.equals((Object)CallingConvention.DEFAULT) || parameterCount > MAX_FASTINT_PARAMETERS) {
            return false;
        }
        Platform platform2 = Platform.getPlatform();
        if (platform2.getOS().equals((Object)Platform.OS.WINDOWS)) {
            return false;
        }
        if (!Platform.getCPU().equals((Object)Platform.CPU.I386) && !Platform.getCPU().equals((Object)Platform.CPU.X86_64)) {
            return false;
        }
        ParameterType[] arr$ = parameterTypes;
        int len$ = parameterTypes.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            ParameterType parameterType = arr$[i$];
            sigType = parameterType;
            platform = platform2;
            if (FastIntMethodGenerator.isFastIntType$4d9a0a37(sigType) || ((ParameterType)sigType).nativeType == NativeType.ADDRESS && NumberUtil.sizeof(sigType) == 4 && FastIntMethodGenerator.isSupportedPointerParameterType(sigType.effectiveJavaType())) continue;
            return false;
        }
        sigType = resultType;
        platform = platform2;
        return FastIntMethodGenerator.isFastIntType$4d9a0a37(sigType) || ((ResultType)sigType).nativeType == NativeType.VOID || ((ResultType)sigType).nativeType == NativeType.ADDRESS && NumberUtil.sizeof(sigType) == 4;
    }

    private static int getMaximumFastIntParameters() {
        try {
            Invoker.class.getDeclaredMethod("invokeI6", CallContext.class, Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            return 6;
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    static boolean isFastIntType$4d9a0a37(SigType type) {
        switch (type.nativeType) {
            case SCHAR: 
            case UCHAR: 
            case SSHORT: 
            case USHORT: 
            case SINT: 
            case UINT: 
            case SLONG: 
            case ULONG: {
                return NumberUtil.sizeof(type.nativeType) <= 4;
            }
        }
        return false;
    }

    private static boolean isSupportedPointerParameterType(Class javaParameterType) {
        return Pointer.class.isAssignableFrom(javaParameterType) || Struct.class.isAssignableFrom(javaParameterType);
    }

    private static boolean isFastIntResult(Platform platform, ResultType resultType) {
        return FastIntMethodGenerator.isFastIntType$4d9a0a37(resultType) || resultType.nativeType == NativeType.VOID || resultType.nativeType == NativeType.ADDRESS && NumberUtil.sizeof(resultType) == 4;
    }

    private static boolean isFastIntParameter(Platform platform, ParameterType parameterType) {
        return FastIntMethodGenerator.isFastIntType$4d9a0a37(parameterType) || parameterType.nativeType == NativeType.ADDRESS && NumberUtil.sizeof(parameterType) == 4 && FastIntMethodGenerator.isSupportedPointerParameterType(parameterType.effectiveJavaType());
    }

    static {
        methodNames = new String[]{"invokeI0", "invokeI1", "invokeI2", "invokeI3", "invokeI4", "invokeI5", "invokeI6"};
        signatures = new String[MAX_FASTINT_PARAMETERS + 1];
        for (int i = 0; i <= MAX_FASTINT_PARAMETERS; ++i) {
            StringBuilder sb = new StringBuilder();
            sb.append('(').append(CodegenUtils.ci(CallContext.class)).append(CodegenUtils.ci(Long.TYPE));
            for (int n = 0; n < i; ++n) {
                sb.append('I');
            }
            FastIntMethodGenerator.signatures[i] = sb.append(")I").toString();
        }
    }
}

