/*
 * Decompiled with CFR 0.152.
 */
package JFlex.gui;

import JFlex.GeneratorException;
import JFlex.Options;
import JFlex.Skeleton;
import JFlex.gui.GridPanel;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;

public class OptionsDialog
extends Dialog {
    private Frame owner;
    private Button skelBrowse;
    private TextField skelFile;
    private Button ok;
    private Button defaults;
    private Checkbox dump;
    private Checkbox verbose;
    private Checkbox jlex;
    private Checkbox no_minimize;
    private Checkbox no_backup;
    private Checkbox time;
    private Checkbox dot;
    private Checkbox tableG;
    private Checkbox switchG;
    private Checkbox packG;

    public OptionsDialog(Frame owner) {
        super(owner, "Options");
        this.owner = owner;
        this.setup();
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                OptionsDialog.this.close();
            }
        });
    }

    public void setup() {
        this.ok = new Button("Ok");
        this.defaults = new Button("Defaults");
        this.skelBrowse = new Button(" Browse");
        this.skelFile = new TextField();
        this.skelFile.setEditable(false);
        this.dump = new Checkbox(" dump");
        this.verbose = new Checkbox(" verbose");
        this.jlex = new Checkbox(" JLex compatibility");
        this.no_minimize = new Checkbox(" skip minimization");
        this.no_backup = new Checkbox(" no backup file");
        this.time = new Checkbox(" time statistics");
        this.dot = new Checkbox(" dot graph files");
        CheckboxGroup codeG = new CheckboxGroup();
        this.tableG = new Checkbox(" table", Options.gen_method == 1, codeG);
        this.switchG = new Checkbox(" switch", Options.gen_method == 2, codeG);
        this.packG = new Checkbox(" pack", Options.gen_method == 0, codeG);
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OptionsDialog.this.close();
            }
        });
        this.defaults.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OptionsDialog.this.setDefaults();
            }
        });
        this.skelBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OptionsDialog.this.skelBrowse();
            }
        });
        this.tableG.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                OptionsDialog.this.setGenMethod();
            }
        });
        this.verbose.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Options.verbose = OptionsDialog.this.verbose.getState();
            }
        });
        this.dump.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Options.dump = OptionsDialog.this.dump.getState();
            }
        });
        this.jlex.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Options.jlex = OptionsDialog.this.jlex.getState();
            }
        });
        this.no_minimize.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Options.no_minimize = OptionsDialog.this.no_minimize.getState();
            }
        });
        this.no_backup.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Options.no_backup = OptionsDialog.this.no_backup.getState();
            }
        });
        this.dot.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Options.dot = OptionsDialog.this.dot.getState();
            }
        });
        this.time.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Options.time = OptionsDialog.this.time.getState();
            }
        });
        GridPanel panel = new GridPanel(4, 7, 10, 10);
        panel.setInsets(new Insets(10, 5, 5, 10));
        panel.add(3, 0, this.ok);
        panel.add(3, 1, this.defaults);
        panel.add(0, 0, 2, 1, 7, new Label("skeleton file:"));
        panel.add(0, 1, 2, 1, this.skelFile);
        panel.add(2, 1, 1, 1, 1, this.skelBrowse);
        panel.add(0, 2, 1, 1, 7, new Label("code:"));
        panel.add(0, 3, 1, 1, this.tableG);
        panel.add(0, 4, 1, 1, this.switchG);
        panel.add(0, 5, 1, 1, this.packG);
        panel.add(1, 3, 1, 1, this.dump);
        panel.add(1, 4, 1, 1, this.verbose);
        panel.add(1, 5, 1, 1, this.time);
        panel.add(2, 3, 1, 1, this.no_minimize);
        panel.add(2, 4, 1, 1, this.no_backup);
        panel.add(3, 3, 1, 1, this.jlex);
        panel.add(3, 4, 1, 1, this.dot);
        this.add("Center", panel);
        this.updateState();
    }

    private void skelBrowse() {
        FileDialog d = new FileDialog(this.owner, "Choose file", 0);
        d.show();
        if (d.getFile() != null) {
            File skel = new File(d.getDirectory() + d.getFile());
            try {
                Skeleton.readSkelFile(skel);
                this.skelFile.setText(skel.toString());
            }
            catch (GeneratorException generatorException) {
                // empty catch block
            }
        }
    }

    private void setGenMethod() {
        if (this.tableG.getState()) {
            Options.gen_method = 1;
            return;
        }
        if (this.switchG.getState()) {
            Options.gen_method = 2;
            return;
        }
        if (this.packG.getState()) {
            Options.gen_method = 0;
            return;
        }
    }

    private void updateState() {
        this.dump.setState(Options.dump);
        this.verbose.setState(Options.verbose);
        this.jlex.setState(Options.jlex);
        this.no_minimize.setState(Options.no_minimize);
        this.no_backup.setState(Options.no_backup);
        this.time.setState(Options.time);
        this.dot.setState(Options.dot);
        this.tableG.setState(Options.gen_method == 1);
        this.switchG.setState(Options.gen_method == 2);
        this.packG.setState(Options.gen_method == 0);
    }

    private void setDefaults() {
        Options.setDefaults();
        Skeleton.readDefault();
        this.skelFile.setText("");
        this.updateState();
    }

    public void close() {
        this.hide();
    }
}

