/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.util;

import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import net.grinder.common.Logger;
import net.grinder.util.MultiLineFormatter;
import net.grinder.util.NullMultiLineFormatter;

public final class SimpleLogger
implements Logger {
    private final DateFormat m_dateFormat = DateFormat.getDateTimeInstance(3, 2);
    private final String m_identifier;
    private final PrintWriter m_outputWriter;
    private final PrintWriter m_errorWriter;
    private final MultiLineFormatter m_formatter;

    public SimpleLogger(String identifier, PrintWriter outputWriter, PrintWriter errorWriter, MultiLineFormatter formatter) {
        this.m_identifier = identifier;
        this.m_outputWriter = outputWriter;
        this.m_errorWriter = errorWriter;
        this.m_formatter = formatter;
    }

    public SimpleLogger(String identifier, PrintWriter outputWriter, PrintWriter errorWriter) {
        this(identifier, outputWriter, errorWriter, new NullMultiLineFormatter());
    }

    public void output(String message, int where) {
        this.writeMessage(this.m_outputWriter, message, where);
    }

    public void output(String message) {
        this.output(message, 2);
    }

    public void error(String message, int where) {
        this.writeMessage(this.m_errorWriter, message, where);
    }

    public void error(String message) {
        this.error(message, 2);
    }

    public PrintWriter getOutputLogWriter() {
        return this.m_outputWriter;
    }

    public PrintWriter getErrorLogWriter() {
        return this.m_errorWriter;
    }

    private void writeMessage(PrintWriter writer, String message, int where) {
        if (where != 0) {
            StringBuffer formattedMessage = new StringBuffer();
            formattedMessage.append(this.m_dateFormat.format(new Date()));
            formattedMessage.append(" (");
            formattedMessage.append(this.m_identifier);
            formattedMessage.append("): ");
            formattedMessage.append(message);
            if ((where & 2) != 0) {
                writer.println(this.m_formatter.format(formattedMessage.toString()));
                writer.flush();
            }
        }
    }
}

