/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.statistics;

import net.grinder.statistics.StatisticsIndexMap;
import net.grinder.statistics.StatisticsSet;

public final class TestStatisticsQueries {
    private final StatisticsIndexMap.LongIndex m_errorsIndex;
    private final StatisticsIndexMap.LongIndex m_untimedTestsIndex;
    private final StatisticsIndexMap.LongSampleIndex m_timedTestsIndex;

    TestStatisticsQueries(StatisticsIndexMap statisticsIndexMap) {
        this.m_errorsIndex = statisticsIndexMap.getLongIndex("errors");
        this.m_untimedTestsIndex = statisticsIndexMap.getLongIndex("untimedTests");
        this.m_timedTestsIndex = statisticsIndexMap.getLongSampleIndex("timedTests");
    }

    public long getNumberOfTests(StatisticsSet statistics) {
        return statistics.getCount(this.m_timedTestsIndex) + statistics.getValue(this.m_untimedTestsIndex);
    }

    public long getNumberOfErrors(StatisticsSet statistics) {
        return statistics.getValue(this.m_errorsIndex);
    }

    public double getAverageTestTime(StatisticsSet statistics) {
        long count = statistics.getCount(this.m_timedTestsIndex);
        return count == 0L ? Double.NaN : (double)statistics.getSum(this.m_timedTestsIndex) / (double)count;
    }
}

