/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.swingui;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import net.grinder.console.model.ConsoleProperties;
import net.grinder.console.swingui.SwingDispatcherFactory;

final class LookAndFeel {
    private final List m_listeners = new ArrayList();
    private final UIManager.LookAndFeelInfo[] m_installedLookAndFeels = UIManager.getInstalledLookAndFeels();

    public LookAndFeel(ConsoleProperties properties, SwingDispatcherFactory swingDispatcherFactory) {
        properties.addPropertyChangeListener("grinder.console.lookAndFeel", (PropertyChangeListener)swingDispatcherFactory.create(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LookAndFeel.this.setLookAndFeel((String)event.getNewValue());
            }
        }));
        this.setLookAndFeel(properties.getLookAndFeel());
    }

    public UIManager.LookAndFeelInfo[] getInstalledLookAndFeels() {
        return this.m_installedLookAndFeels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLookAndFeel(String className) {
        try {
            if (className != null) {
                UIManager.setLookAndFeel(className);
            } else {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
        catch (UnsupportedLookAndFeelException e) {
            throw new AssertionError((Object)e);
        }
        List list = this.m_listeners;
        synchronized (list) {
            Iterator iterator = this.m_listeners.iterator();
            while (iterator.hasNext()) {
                Listener listener = (Listener)iterator.next();
                listener.lookAndFeelChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener window) {
        List list = this.m_listeners;
        synchronized (list) {
            this.m_listeners.add(window);
        }
    }

    static class ComponentListener
    implements Listener {
        private final Component m_component;

        public ComponentListener(Component component) {
            this.m_component = component;
        }

        public void lookAndFeelChanged() {
            SwingUtilities.updateComponentTreeUI(this.m_component);
        }
    }

    static interface Listener
    extends EventListener {
        public void lookAndFeelChanged();
    }
}

