/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.util.List;
import java.util.Properties;
import org.python.core.Options;
import org.python.util.Generic;

class CommandLineOptions {
    public String filename = null;
    public boolean jar = false;
    public boolean interactive = true;
    public boolean notice = true;
    public boolean runCommand;
    public boolean runModule = false;
    public boolean fixInteractive = false;
    public boolean help = false;
    public boolean version = false;
    public String[] argv;
    public Properties properties;
    public String command;
    public List<String> warnoptions = Generic.list();
    public String encoding;
    public String division;
    public String moduleName;

    public CommandLineOptions() {
        this.properties = new Properties();
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
        try {
            System.setProperty(key, value);
            return;
        }
        catch (SecurityException securityException) {
            return;
        }
    }

    private boolean argumentExpected(String arg) {
        System.err.println("Argument expected for the " + arg + " option");
        return false;
    }

    public boolean parse(String[] args) {
        int index;
        for (index = 0; index < args.length && args[index].startsWith("-"); ++index) {
            String arg = args[index];
            if (arg.equals("-h") || arg.equals("-?") || arg.equals("--help")) {
                this.help = true;
                return false;
            }
            if (arg.equals("-V") || arg.equals("--version")) {
                this.version = true;
                return false;
            }
            if (arg.equals("-")) {
                if (!this.fixInteractive) {
                    this.interactive = false;
                }
                this.filename = "-";
                continue;
            }
            if (arg.equals("-i")) {
                this.fixInteractive = true;
                this.interactive = true;
                continue;
            }
            if (arg.equals("-jar")) {
                this.jar = true;
                if (this.fixInteractive) continue;
                this.interactive = false;
                continue;
            }
            if (arg.equals("-u")) {
                Options.unbuffered = true;
                continue;
            }
            if (arg.equals("-v")) {
                ++Options.verbose;
                continue;
            }
            if (arg.equals("-vv")) {
                Options.verbose += 2;
                continue;
            }
            if (arg.equals("-vvv")) {
                Options.verbose += 3;
                continue;
            }
            if (arg.equals("-s")) {
                Options.no_user_site = true;
                continue;
            }
            if (arg.equals("-S")) {
                Options.importSite = false;
                continue;
            }
            if (arg.equals("-B")) {
                Options.dont_write_bytecode = true;
                continue;
            }
            if (arg.startsWith("-c")) {
                this.runCommand = true;
                if (arg.length() > 2) {
                    this.command = arg.substring(2);
                } else if (index + 1 < args.length) {
                    this.command = args[++index];
                } else {
                    return this.argumentExpected(arg);
                }
                if (!this.fixInteractive) {
                    this.interactive = false;
                }
                ++index;
                break;
            }
            if (arg.startsWith("-W")) {
                if (arg.length() > 2) {
                    this.warnoptions.add(arg.substring(2));
                    continue;
                }
                if (index + 1 < args.length) {
                    this.warnoptions.add(args[++index]);
                    continue;
                }
                return this.argumentExpected(arg);
            }
            if (arg.equals("-E")) {
                Options.ignore_environment = true;
                continue;
            }
            if (arg.startsWith("-D")) {
                String value;
                String key;
                int equals = arg.indexOf("=");
                if (equals == -1) {
                    String arg2 = args[++index];
                    key = arg.substring(2, arg.length());
                    value = arg2;
                } else {
                    key = arg.substring(2, equals);
                    value = arg.substring(equals + 1, arg.length());
                }
                this.setProperty(key, value);
                continue;
            }
            if (arg.startsWith("-Q")) {
                if (arg.length() > 2) {
                    this.division = arg.substring(2);
                    continue;
                }
                this.division = args[++index];
                continue;
            }
            if (arg.startsWith("-m")) {
                this.runModule = true;
                if (arg.length() > 2) {
                    this.moduleName = arg.substring(2);
                } else if (index + 1 < args.length) {
                    this.moduleName = args[++index];
                } else {
                    return this.argumentExpected(arg);
                }
                if (!this.fixInteractive) {
                    this.interactive = false;
                }
                int n = args.length - ++index + 1;
                this.argv = new String[n];
                this.argv[0] = this.moduleName;
                int i = 1;
                while (index < args.length) {
                    this.argv[i] = args[index];
                    ++i;
                    ++index;
                }
                return true;
            }
            if (arg.startsWith("-3")) {
                Options.py3k_warning = true;
                continue;
            }
            String opt = args[index];
            if (opt.startsWith("--")) {
                opt = opt.substring(2);
            } else if (opt.startsWith("-")) {
                opt = opt.substring(1);
            }
            System.err.println("Unknown option: " + opt);
            return false;
        }
        this.notice = this.interactive;
        if (this.filename == null && index < args.length && this.command == null) {
            this.filename = args[index++];
            if (!this.fixInteractive) {
                this.interactive = false;
            }
            this.notice = false;
        }
        if (this.command != null) {
            this.notice = false;
        }
        int n = args.length - index + 1;
        this.argv = new String[n];
        this.argv[0] = this.filename != null ? this.filename : (this.command != null ? "-c" : "");
        int i = 1;
        while (i < n) {
            this.argv[i] = args[index];
            ++i;
            ++index;
        }
        return true;
    }
}

