/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.List;
import org.python.indexer.Indexer;
import org.python.indexer.Scope;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NType;

public final class NCompare
extends NNode {
    private NNode left;
    private List<NNode> ops;
    private List<NNode> comparators;

    public NCompare(NNode left, List<NNode> ops, List<NNode> comparators) {
        this(null, null, null, 0, 1);
    }

    public NCompare(NNode left, List<NNode> ops, List<NNode> comparators, int start, int end) {
        super(start, end);
        this.left = left;
        this.ops = ops;
        this.comparators = comparators;
        this.addChildren(left);
        this.addChildren(ops);
        this.addChildren(comparators);
    }

    @Override
    public final NType resolve(Scope s) throws Exception {
        this.setType(Indexer.idx.builtins.BaseNum);
        NCompare.resolveExpr(this.left, s);
        NCompare.resolveList(this.comparators, s);
        return this.getType();
    }

    public final String toString() {
        return "<Compare:" + this.left + ":" + this.ops + ":" + this.comparators + ">";
    }

    @Override
    public final void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            NCompare.visitNode(this.left, v);
            NCompare.visitNodeList(this.ops, v);
            NCompare.visitNodeList(this.comparators, v);
        }
    }
}

