/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.List;
import org.python.indexer.Scope;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

public final class NBoolOp
extends NNode {
    private OpType op;
    private List<NNode> values;

    public NBoolOp(OpType op, List<NNode> values) {
        this(null, null, 0, 1);
    }

    public NBoolOp(OpType op, List<NNode> values, int start, int end) {
        super(start, end);
        this.op = op;
        this.values = values;
        this.addChildren(values);
    }

    @Override
    public final NType resolve(Scope s) throws Exception {
        if (this.op == OpType.AND) {
            NType last = null;
            for (NNode e : this.values) {
                last = NBoolOp.resolveExpr(e, s);
            }
            return this.setType(last == null ? new NUnknownType() : last);
        }
        return this.setType(NBoolOp.resolveListAsUnion(this.values, s));
    }

    public final String toString() {
        return "<BoolOp:" + (Object)((Object)this.op) + ":" + this.values + ">";
    }

    @Override
    public final void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            NBoolOp.visitNodeList(this.values, v);
        }
    }

    public static final class OpType
    extends Enum<OpType> {
        public static final /* enum */ OpType AND = new OpType();
        public static final /* enum */ OpType OR = new OpType();
        public static final /* enum */ OpType UNDEFINED = new OpType();

        static {
            OpType[] opTypeArray = new OpType[]{AND, OR, UNDEFINED};
        }
    }
}

