/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import org.python.google.common.collect.ImmutableList;
import org.python.google.common.collect.ImmutableSet;
import org.python.google.common.collect.Iterators;
import org.python.google.common.collect.ObjectArrays;
import org.python.google.common.collect.UnmodifiableIterator;

final class EmptyImmutableSet
extends ImmutableSet<Object> {
    static final EmptyImmutableSet INSTANCE = new EmptyImmutableSet();

    private EmptyImmutableSet() {
    }

    @Override
    public final int size() {
        return 0;
    }

    @Override
    public final boolean isEmpty() {
        return true;
    }

    @Override
    public final boolean contains(@Nullable Object target) {
        return false;
    }

    @Override
    public final boolean containsAll(Collection<?> targets) {
        return targets.isEmpty();
    }

    @Override
    public final UnmodifiableIterator<Object> iterator() {
        return Iterators.emptyIterator();
    }

    @Override
    final boolean isPartialView() {
        return false;
    }

    @Override
    public final Object[] toArray() {
        return ObjectArrays.EMPTY_ARRAY;
    }

    @Override
    public final <T> T[] toArray(T[] a) {
        EmptyImmutableSet emptyImmutableSet = this;
        return ImmutableList.of().toArray(a);
    }

    @Override
    public final ImmutableList<Object> asList() {
        return ImmutableList.of();
    }

    @Override
    public final boolean equals(@Nullable Object object) {
        if (object instanceof Set) {
            Set that = (Set)object;
            return that.isEmpty();
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return 0;
    }

    @Override
    final boolean isHashCodeFast() {
        return true;
    }

    @Override
    public final String toString() {
        return "[]";
    }
}

