/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.cache;

import java.io.Serializable;
import java.util.Map;
import org.python.google.common.base.CharMatcher;
import org.python.google.common.base.Function;
import org.python.google.common.base.Supplier;
import org.python.google.common.util.concurrent.Futures;
import org.python.google.common.util.concurrent.ListenableFuture;

public abstract class CacheLoader<K, V> {
    protected CacheLoader() {
    }

    public abstract V load(K var1) throws Exception;

    public ListenableFuture<V> reload(K key, V oldValue) throws Exception {
        return Futures.immediateFuture(this.load(key));
    }

    public Map<K, V> loadAll(Iterable<? extends K> keys) throws Exception {
        throw new UnsupportedLoadingOperationException();
    }

    public static <K, V> CacheLoader<K, V> from(Function<K, V> function) {
        return new FunctionToCacheLoader<K, V>(function);
    }

    public static <V> CacheLoader<Object, V> from(Supplier<V> supplier) {
        return new SupplierToCacheLoader<V>(supplier);
    }

    static final class UnsupportedLoadingOperationException
    extends UnsupportedOperationException {
        UnsupportedLoadingOperationException() {
        }
    }

    static final class SupplierToCacheLoader<V>
    extends CacheLoader<Object, V>
    implements Serializable {
        private final Supplier<V> computingSupplier;

        public SupplierToCacheLoader(Supplier<V> computingSupplier) {
            this.computingSupplier = CharMatcher.LookupTable.checkNotNull(computingSupplier);
        }

        @Override
        public final V load(Object key) {
            return this.computingSupplier.get();
        }
    }

    static final class FunctionToCacheLoader<K, V>
    extends CacheLoader<K, V>
    implements Serializable {
        private final Function<K, V> computingFunction;

        public FunctionToCacheLoader(Function<K, V> computingFunction) {
            this.computingFunction = CharMatcher.LookupTable.checkNotNull(computingFunction);
        }

        @Override
        public final V load(K key) {
            return this.computingFunction.apply(key);
        }
    }
}

