/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.CodeFlag;
import org.python.core.CompilerFlags;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyFrame;
import org.python.core.PyGenerator;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.core.PyTuple;
import org.python.core.ThreadState;
import org.python.modules._systemrestart;

public abstract class PyBaseCode
extends PyCode {
    public int co_argcount;
    int nargs;
    public int co_firstlineno = -1;
    public String[] co_varnames;
    public String[] co_cellvars;
    public int jy_npurecell;
    public String[] co_freevars;
    public String co_filename;
    public CompilerFlags co_flags = new CompilerFlags();
    public int co_nlocals;
    public boolean varargs;
    public boolean varkwargs;

    public boolean hasFreevars() {
        return this.co_freevars != null && this.co_freevars.length > 0;
    }

    @Override
    public PyObject call(ThreadState ts, PyFrame frame, PyObject closure) {
        PyObject ret;
        if (ts.systemState == null) {
            ts.systemState = Py.defaultSystemState;
        }
        PyException previous_exception = ts.exception;
        frame.f_back = ts.frame;
        if (frame.f_builtins == null) {
            frame.f_builtins = frame.f_back != null ? frame.f_back.f_builtins : PySystemState.builtins;
        }
        frame.setupEnv((PyTuple)closure);
        ts.frame = frame;
        if (ts.tracefunc != null) {
            frame.f_lineno = this.co_firstlineno;
            frame.tracefunc = ts.tracefunc.traceCall(frame);
        }
        if (ts.profilefunc != null) {
            ts.profilefunc.traceCall(frame);
        }
        try {
            ret = this.interpret(frame, ts);
        }
        catch (Throwable throwable) {
            Throwable t = throwable;
            PyException pye = Py.JavaError(throwable);
            pye.tracebackHere(frame);
            frame.f_lasti = -1;
            if (frame.tracefunc != null) {
                frame.tracefunc.traceException(frame, pye);
            }
            if (ts.profilefunc != null) {
                ts.profilefunc.traceException(frame, pye);
            }
            ts.exception = previous_exception;
            ts.frame = ts.frame.f_back;
            throw pye;
        }
        if (frame.tracefunc != null) {
            frame.tracefunc.traceReturn(frame, ret);
        }
        if (ts.profilefunc != null) {
            ts.profilefunc.traceReturn(frame, ret);
        }
        ts.exception = previous_exception;
        ts.frame = ts.frame.f_back;
        if (ts.systemState._systemRestart && Thread.currentThread().isInterrupted()) {
            throw new PyException(_systemrestart.SystemRestart);
        }
        return ret;
    }

    @Override
    public PyObject call(ThreadState state, PyObject globals, PyObject[] defaults, PyObject closure) {
        if (this.co_argcount != 0 || this.varargs || this.varkwargs) {
            return this.call(state, Py.EmptyObjects, Py.NoKeywords, globals, defaults, closure);
        }
        PyFrame frame = new PyFrame(this, globals);
        if (this.co_flags.isFlagSet(CodeFlag.CO_GENERATOR)) {
            return new PyGenerator(frame, closure);
        }
        return this.call(state, frame, closure);
    }

    @Override
    public PyObject call(ThreadState state, PyObject arg1, PyObject globals, PyObject[] defaults, PyObject closure) {
        if (this.co_argcount != 1 || this.varargs || this.varkwargs) {
            return this.call(state, new PyObject[]{arg1}, Py.NoKeywords, globals, defaults, closure);
        }
        PyFrame frame = new PyFrame(this, globals);
        frame.f_fastlocals[0] = arg1;
        if (this.co_flags.isFlagSet(CodeFlag.CO_GENERATOR)) {
            return new PyGenerator(frame, closure);
        }
        return this.call(state, frame, closure);
    }

    @Override
    public PyObject call(ThreadState state, PyObject arg1, PyObject arg2, PyObject globals, PyObject[] defaults, PyObject closure) {
        if (this.co_argcount != 2 || this.varargs || this.varkwargs) {
            return this.call(state, new PyObject[]{arg1, arg2}, Py.NoKeywords, globals, defaults, closure);
        }
        PyFrame frame = new PyFrame(this, globals);
        frame.f_fastlocals[0] = arg1;
        frame.f_fastlocals[1] = arg2;
        if (this.co_flags.isFlagSet(CodeFlag.CO_GENERATOR)) {
            return new PyGenerator(frame, closure);
        }
        return this.call(state, frame, closure);
    }

    @Override
    public PyObject call(ThreadState state, PyObject arg1, PyObject arg2, PyObject arg3, PyObject globals, PyObject[] defaults, PyObject closure) {
        if (this.co_argcount != 3 || this.varargs || this.varkwargs) {
            return this.call(state, new PyObject[]{arg1, arg2, arg3}, Py.NoKeywords, globals, defaults, closure);
        }
        PyFrame frame = new PyFrame(this, globals);
        frame.f_fastlocals[0] = arg1;
        frame.f_fastlocals[1] = arg2;
        frame.f_fastlocals[2] = arg3;
        if (this.co_flags.isFlagSet(CodeFlag.CO_GENERATOR)) {
            return new PyGenerator(frame, closure);
        }
        return this.call(state, frame, closure);
    }

    @Override
    public PyObject call(ThreadState state, PyObject arg1, PyObject arg2, PyObject arg3, PyObject arg4, PyObject globals, PyObject[] defaults, PyObject closure) {
        if (this.co_argcount != 4 || this.varargs || this.varkwargs) {
            return this.call(state, new PyObject[]{arg1, arg2, arg3, arg4}, Py.NoKeywords, globals, defaults, closure);
        }
        PyFrame frame = new PyFrame(this, globals);
        frame.f_fastlocals[0] = arg1;
        frame.f_fastlocals[1] = arg2;
        frame.f_fastlocals[2] = arg3;
        frame.f_fastlocals[3] = arg4;
        if (this.co_flags.isFlagSet(CodeFlag.CO_GENERATOR)) {
            return new PyGenerator(frame, closure);
        }
        return this.call(state, frame, closure);
    }

    @Override
    public PyObject call(ThreadState state, PyObject self, PyObject[] args, String[] keywords, PyObject globals, PyObject[] defaults, PyObject closure) {
        PyObject[] pyObjectArray = new PyObject[args.length + 1];
        PyObject[] os2 = pyObjectArray;
        pyObjectArray[0] = self;
        System.arraycopy(args, 0, os2, 1, args.length);
        return this.call(state, os2, keywords, globals, defaults, closure);
    }

    @Override
    public PyObject call(ThreadState state, PyObject[] args, String[] kws, PyObject globals, PyObject[] defs, PyObject closure) {
        PyFrame frame = new PyFrame(this, globals);
        int argcount = args.length - kws.length;
        if (this.co_argcount > 0 || this.varargs || this.varkwargs) {
            int i;
            int n = argcount;
            PyDictionary kwdict = null;
            PyObject[] fastlocals = frame.f_fastlocals;
            if (this.varkwargs) {
                kwdict = new PyDictionary();
                i = this.co_argcount;
                if (this.varargs) {
                    ++i;
                }
                fastlocals[i] = kwdict;
            }
            if (argcount > this.co_argcount) {
                if (!this.varargs) {
                    int defcount = defs != null ? defs.length : 0;
                    String msg = String.format("%.200s() takes %s %d %sargument%s (%d given)", this.co_name, defcount > 0 ? "at most" : "exactly", this.co_argcount, kws.length > 0 ? "non-keyword " : "", this.co_argcount == 1 ? "" : "s", argcount);
                    throw Py.TypeError(msg);
                }
                n = this.co_argcount;
            }
            System.arraycopy(args, 0, fastlocals, 0, n);
            if (this.varargs) {
                PyObject[] u = new PyObject[argcount - n];
                System.arraycopy(args, n, u, 0, argcount - n);
                PyTuple uTuple = new PyTuple(u);
                fastlocals[this.co_argcount] = uTuple;
            }
            for (i = 0; i < kws.length; ++i) {
                int j;
                String keyword2 = kws[i];
                PyObject value = args[i + argcount];
                for (j = 0; j < this.co_argcount && !this.co_varnames[j].equals(keyword2); ++j) {
                }
                if (j >= this.co_argcount) {
                    if (kwdict == null) {
                        throw Py.TypeError(String.format("%.200s() got an unexpected keyword argument '%.400s'", this.co_name, keyword2));
                    }
                    kwdict.__setitem__(keyword2, value);
                    continue;
                }
                if (fastlocals[j] != null) {
                    throw Py.TypeError(String.format("%.200s() got multiple values for keyword argument '%.400s'", this.co_name, keyword2));
                }
                fastlocals[j] = value;
            }
            if (argcount < this.co_argcount) {
                int defcount = defs != null ? defs.length : 0;
                int m = this.co_argcount - defcount;
                for (i = argcount; i < m; ++i) {
                    if (fastlocals[i] != null) continue;
                    String msg = String.format("%.200s() takes %s %d %sargument%s (%d given)", this.co_name, this.varargs || defcount > 0 ? "at least" : "exactly", m, kws.length > 0 ? "non-keyword " : "", m == 1 ? "" : "s", i);
                    throw Py.TypeError(msg);
                }
                for (i = n > m ? n - m : 0; i < defcount; ++i) {
                    if (fastlocals[m + i] != null) continue;
                    fastlocals[m + i] = defs[i];
                }
            }
        } else if (argcount > 0) {
            throw Py.TypeError(String.format("%.200s() takes no arguments (%d given)", this.co_name, argcount));
        }
        if (this.co_flags.isFlagSet(CodeFlag.CO_GENERATOR)) {
            return new PyGenerator(frame, closure);
        }
        return this.call(state, frame, closure);
    }

    @Override
    public String toString() {
        return String.format("<code object %.100s at %s, file \"%.300s\", line %d>", this.co_name, Py.idstr(this), this.co_filename, this.co_firstlineno);
    }

    protected abstract PyObject interpret(PyFrame var1, ThreadState var2);

    protected int getline(PyFrame f) {
        return f.f_lineno;
    }

    public CompilerFlags getCompilerFlags() {
        return this.co_flags;
    }
}

