/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.ArrayFlags;
import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Function;
import com.kenai.jffi.PageManager;
import com.kenai.jffi.Platform;
import jnr.ffi.provider.jffi.ParameterType;
import jnr.ffi.provider.jffi.ResultType;
import jnr.ffi.provider.jffi.X86_32StubCompiler;
import jnr.ffi.provider.jffi.X86_64StubCompiler;
import jnr.x86asm.Assembler;
import jnr.x86asm.CPU;

abstract class StubCompiler {
    static final long errnoFunctionAddress = StubCompiler.getErrnoSaveFunction();
    private static boolean hasPageManager = StubCompiler.hasPageManager();
    private static boolean hasAssembler = StubCompiler.hasAssembler();

    StubCompiler() {
    }

    public static final StubCompiler newCompiler() {
        if (errnoFunctionAddress != 0L && hasPageManager && hasAssembler) {
            Platform.getPlatform();
            switch (Platform.getCPU()) {
                case I386: {
                    if (Platform.getPlatform().getOS() == Platform.OS.WINDOWS) break;
                    return new X86_32StubCompiler();
                }
                case X86_64: {
                    if (Platform.getPlatform().getOS() == Platform.OS.WINDOWS) break;
                    return new X86_64StubCompiler();
                }
            }
        }
        return new DummyStubCompiler();
    }

    abstract boolean canCompile(ResultType var1, ParameterType[] var2, CallingConvention var3);

    abstract void compile$25127b6a(Function var1, String var2, ResultType var3, ParameterType[] var4, Class var5, Class[] var6, boolean var7);

    abstract void attach(Class var1);

    private static final long getErrnoSaveFunction() {
        try {
            return ArrayFlags.getErrnoSaveFunction();
        }
        catch (Throwable throwable) {
            return 0L;
        }
    }

    private static final boolean hasPageManager() {
        try {
            long page = PageManager.getInstance().allocatePages(1, 3);
            PageManager.getInstance().freePages(page, 1);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static final boolean hasAssembler() {
        try {
            Platform.getPlatform();
            switch (Platform.getCPU()) {
                case I386: {
                    new Assembler(CPU.X86_32);
                    return true;
                }
                case X86_64: {
                    new Assembler(CPU.X86_64);
                    return true;
                }
            }
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static final class DummyStubCompiler
    extends StubCompiler {
        DummyStubCompiler() {
        }

        final boolean canCompile(ResultType returnType, ParameterType[] parameterTypes, CallingConvention convention) {
            return false;
        }

        final void compile$25127b6a(Function function, String name, ResultType returnType, ParameterType[] parameterTypes, Class resultClass, Class[] parameterClasses, boolean saveErrno) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        final void attach(Class clazz) {
        }
    }
}

