/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Invoker;
import com.kenai.jffi.Platform;
import com.kenai.jffi.Type;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import jnr.ffi.NativeType;
import jnr.ffi.Pointer;
import jnr.ffi.Struct;
import jnr.ffi.provider.jffi.AbstractFastNumericMethodGenerator;
import jnr.ffi.provider.jffi.AsmUtil;
import jnr.ffi.provider.jffi.BufferMethodGenerator;
import jnr.ffi.provider.jffi.CodegenUtils;
import jnr.ffi.provider.jffi.FastIntMethodGenerator;
import jnr.ffi.provider.jffi.ParameterType;
import jnr.ffi.provider.jffi.ResultType;
import jnr.ffi.provider.jffi.SigType;

class FastNumericMethodGenerator
extends AbstractFastNumericMethodGenerator {
    private static final boolean ENABLED = FastNumericMethodGenerator.getBooleanProperty("jnr.ffi.fast-numeric.enabled", true);
    private static final int MAX_PARAMETERS = FastNumericMethodGenerator.getMaximumParameters();
    private static final String[] signatures;
    private static final String[] methodNames;

    FastNumericMethodGenerator(BufferMethodGenerator bufgen) {
        super(bufgen);
    }

    public boolean isSupported(ResultType resultType, ParameterType[] parameterTypes, CallingConvention callingConvention) {
        SigType sigType;
        Platform platform;
        int parameterCount = parameterTypes.length;
        if (!ENABLED) {
            return false;
        }
        if (callingConvention != CallingConvention.DEFAULT || parameterCount > MAX_PARAMETERS) {
            return false;
        }
        Platform platform2 = Platform.getPlatform();
        if (Platform.getCPU() != Platform.CPU.I386 && Platform.getCPU() != Platform.CPU.X86_64) {
            return false;
        }
        if (platform2.getOS().equals((Object)Platform.OS.WINDOWS)) {
            return false;
        }
        ParameterType[] arr$ = parameterTypes;
        int len$ = parameterTypes.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            platform = platform2;
            ParameterType parameterType = arr$[i$];
            sigType = parameterType;
            if (FastNumericMethodGenerator.isNumericType(platform, sigType) || AsmUtil.isDelegate(sigType.getDeclaredType()) || ((ParameterType)sigType).nativeType == NativeType.ADDRESS && FastNumericMethodGenerator.isSupportedPointerParameterType(sigType.effectiveJavaType())) continue;
            return false;
        }
        platform = platform2;
        sigType = resultType;
        return FastNumericMethodGenerator.isNumericType(platform, sigType) || NativeType.VOID == ((ResultType)sigType).nativeType || NativeType.ADDRESS == ((ResultType)sigType).nativeType;
    }

    final String getInvokerMethodName$5974725e(ParameterType[] parameterTypes) {
        int parameterCount = parameterTypes.length;
        if (parameterCount <= MAX_PARAMETERS && parameterCount <= methodNames.length) {
            return methodNames[parameterCount];
        }
        throw new IllegalArgumentException("invalid fast-numeric parameter count: " + parameterCount);
    }

    final String getInvokerSignature$15ec99b1(int parameterCount) {
        if (parameterCount <= MAX_PARAMETERS && parameterCount <= signatures.length) {
            return signatures[parameterCount];
        }
        throw new IllegalArgumentException("invalid fast-numeric parameter count: " + parameterCount);
    }

    final Class getInvokerType() {
        return Long.TYPE;
    }

    private static boolean isNumericType(Platform platform, SigType type) {
        return FastIntMethodGenerator.isFastIntType$4d9a0a37(type) || type.nativeType == NativeType.SLONG || type.nativeType == NativeType.ULONG || type.nativeType == NativeType.SLONGLONG || type.nativeType == NativeType.ULONGLONG || type.nativeType == NativeType.FLOAT || type.nativeType == NativeType.DOUBLE;
    }

    private static boolean isFastNumericResult(Platform platform, ResultType type) {
        return FastNumericMethodGenerator.isNumericType(platform, type) || NativeType.VOID == type.nativeType || NativeType.ADDRESS == type.nativeType;
    }

    private static boolean isFastNumericParameter(Platform platform, ParameterType parameterType) {
        return FastNumericMethodGenerator.isNumericType(platform, parameterType) || AsmUtil.isDelegate(parameterType.getDeclaredType()) || parameterType.nativeType == NativeType.ADDRESS && FastNumericMethodGenerator.isSupportedPointerParameterType(parameterType.effectiveJavaType());
    }

    private static boolean isSupportedPointerParameterType(Class javaParameterType) {
        return Pointer.class.isAssignableFrom(javaParameterType) || String.class == javaParameterType || CharSequence.class == javaParameterType || Struct.class.isAssignableFrom(javaParameterType) || ByteBuffer.class.isAssignableFrom(javaParameterType) || ShortBuffer.class.isAssignableFrom(javaParameterType) || IntBuffer.class.isAssignableFrom(javaParameterType) || LongBuffer.class.isAssignableFrom(javaParameterType) && Type.SLONG.size() == 8 || FloatBuffer.class.isAssignableFrom(javaParameterType) || DoubleBuffer.class.isAssignableFrom(javaParameterType) || byte[].class == javaParameterType || short[].class == javaParameterType || int[].class == javaParameterType || long[].class == javaParameterType && Type.SLONG.size() == 8 || float[].class == javaParameterType || double[].class == javaParameterType || boolean[].class == javaParameterType;
    }

    private static int getMaximumParameters() {
        try {
            Invoker.class.getDeclaredMethod("invokeN6", CallContext.class, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE);
            return 6;
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    static {
        methodNames = new String[]{"invokeN0", "invokeN1", "invokeN2", "invokeN3", "invokeN4", "invokeN5", "invokeN6"};
        signatures = new String[MAX_PARAMETERS + 1];
        for (int i = 0; i <= MAX_PARAMETERS; ++i) {
            StringBuilder sb = new StringBuilder();
            sb.append('(').append(CodegenUtils.ci(CallContext.class)).append(CodegenUtils.ci(Long.TYPE));
            for (int n = 0; n < i; ++n) {
                sb.append('J');
            }
            FastNumericMethodGenerator.signatures[i] = sb.append(")J").toString();
        }
    }
}

