/*
 * Decompiled with CFR 0.152.
 */
package jnr.constants;

import java.lang.reflect.Field;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jnr.constants.Constant;
import jnr.constants.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantSet
extends AbstractSet<Constant> {
    private final ConcurrentMap<String, Constant> nameToConstant;
    private final ConcurrentMap<Long, Constant> valueToConstant;
    private final Set<Enum> constants;
    private final Class<Enum> enumClass;
    private volatile Long minValue;
    private volatile Long maxValue;
    private static final ConcurrentMap<String, ConstantSet> constantSets = new ConcurrentHashMap<String, ConstantSet>();
    private static final Object lock = new Object();

    public static ConstantSet getConstantSet(String name) {
        ConstantSet constants = (ConstantSet)constantSets.get(name);
        if (constants == null) {
            Object object = lock;
            synchronized (object) {
                if (!constantSets.containsKey(name)) {
                    Class<Enum> enumClass = ConstantSet.getEnumClass(name);
                    if (enumClass == null) {
                        return null;
                    }
                    if (!Constant.class.isAssignableFrom(enumClass)) {
                        throw new ClassCastException("class for " + name + " does not implement Constant interface");
                    }
                    constants = new ConstantSet(enumClass);
                    constantSets.put(name, constants);
                }
            }
        }
        return constants;
    }

    private static final Class<Enum> getEnumClass(String name) {
        String[] prefixes;
        String[] arr$ = prefixes = Platform.getPlatform().getPackagePrefixes();
        int len$ = prefixes.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String prefix = arr$[i$];
            try {
                return Class.forName(prefix + "." + name).asSubclass(Enum.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
        }
        return null;
    }

    private ConstantSet(Class<Enum> enumClass) {
        this.enumClass = enumClass;
        this.nameToConstant = new ConcurrentHashMap<String, Constant>();
        this.valueToConstant = new ConcurrentHashMap<Long, Constant>();
        this.constants = EnumSet.allOf(enumClass);
    }

    public Constant getConstant(String name) {
        Constant c = (Constant)this.nameToConstant.get(name);
        if (c == null) {
            try {
                c = (Constant)Constant.class.cast(Enum.valueOf(this.enumClass, name));
                this.nameToConstant.put(name, c);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        return c;
    }

    public Constant getConstant(long value) {
        Constant c = (Constant)this.valueToConstant.get(value);
        if (c == null) {
            for (Enum e : this.constants) {
                if (!(e instanceof Constant) || ((Constant)((Object)e)).longValue() != value) continue;
                c = (Constant)((Object)e);
                break;
            }
            if (c != null) {
                this.valueToConstant.put(value, c);
            }
        }
        return c;
    }

    public long getValue(String name) {
        Constant c = this.getConstant(name);
        if (c != null) {
            return c.longValue();
        }
        return 0L;
    }

    public String getName(int value) {
        Constant c = this.getConstant(value);
        if (c != null) {
            return c.name();
        }
        return "unknown";
    }

    private Long getLongField(String name, long defaultValue) {
        try {
            Field f = this.enumClass.getField("MIN_VALUE");
            return (Long)f.get(this.enumClass);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return defaultValue;
        }
        catch (RuntimeException runtimeException) {
            RuntimeException ex = runtimeException;
            throw runtimeException;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public long minValue() {
        if (this.minValue == null) {
            this.minValue = this.getLongField("MIN_VALUE", Integer.MIN_VALUE);
        }
        return this.minValue.intValue();
    }

    public long maxValue() {
        if (this.maxValue == null) {
            this.maxValue = this.getLongField("MAX_VALUE", Integer.MAX_VALUE);
        }
        return this.maxValue.intValue();
    }

    @Override
    public Iterator<Constant> iterator() {
        return new ConstantIterator(this, this.constants);
    }

    @Override
    public int size() {
        return this.constants.size();
    }

    @Override
    public boolean contains(Object o) {
        return o != null && o.getClass().equals(this.enumClass);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ConstantIterator
    implements Iterator<Constant> {
        private final Iterator<Enum> it;
        private Constant next = null;
        private /* synthetic */ ConstantSet this$0;

        ConstantIterator(ConstantSet constantSet, Collection<Enum> constants) {
            this.it = constants.iterator();
            this.next = this.it.hasNext() ? (Constant)((Object)this.it.next()) : null;
        }

        @Override
        public final boolean hasNext() {
            return this.next != null && !this.next.name().equals("__UNKNOWN_CONSTANT__");
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Constant next() {
            Constant prev = this.next;
            this.next = this.it.hasNext() ? (Constant)((Object)this.it.next()) : null;
            return prev;
        }
    }
}

