/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import org.python.indexer.Scope;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NType;

public final class NIfExp
extends NNode {
    private NNode test;
    private NNode body;
    private NNode orelse;

    public NIfExp(NNode test, NNode body, NNode orelse) {
        this(null, null, null, 0, 1);
    }

    public NIfExp(NNode test, NNode body, NNode orelse, int start, int end) {
        super(start, end);
        this.test = test;
        this.body = body;
        this.orelse = orelse;
        this.addChildren(test, body, orelse);
    }

    @Override
    public final NType resolve(Scope s) throws Exception {
        NIfExp.resolveExpr(this.test, s);
        if (this.body != null) {
            this.setType(NIfExp.resolveExpr(this.body, s));
        }
        if (this.orelse != null) {
            this.addType(NIfExp.resolveExpr(this.orelse, s));
        }
        return this.getType();
    }

    public final String toString() {
        return "<IfExp:" + this.start() + ":" + this.test + ":" + this.body + ":" + this.orelse + ">";
    }

    @Override
    public final void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            NIfExp.visitNode(this.test, v);
            NIfExp.visitNode(this.body, v);
            NIfExp.visitNode(this.orelse, v);
        }
    }
}

