/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.python.antlr.AnalyzingParser;
import org.python.antlr.base.mod;
import org.python.antlr.runtime.ANTLRFileStream;
import org.python.antlr.runtime.ANTLRStringStream;
import org.python.antlr.runtime.CharStream;
import org.python.antlr.runtime.RecognitionException;
import org.python.indexer.AstConverter;
import org.python.indexer.Diagnostic;
import org.python.indexer.Indexer;
import org.python.indexer.Util;
import org.python.indexer.ast.NModule;

public class AstCache {
    public static final String CACHE_DIR = new File(Util.getSystemTempDir(), "jython/ast_cache").getAbsolutePath() + File.separator;
    private static final Logger LOG = Logger.getLogger(AstCache.class.getCanonicalName());
    private Map<String, NModule> cache = new HashMap<String, NModule>();
    private static AstCache INSTANCE;

    private AstCache() throws Exception {
        File f = new File(CACHE_DIR);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    public static AstCache get() throws Exception {
        if (INSTANCE == null) {
            INSTANCE = new AstCache();
        }
        return INSTANCE;
    }

    public void clear() {
        this.cache.clear();
    }

    public boolean clearDiskCache() {
        try {
            File dir = new File(CACHE_DIR);
            for (File f : dir.listFiles()) {
                if (!f.isFile()) continue;
                f.delete();
            }
            return true;
        }
        catch (Exception x) {
            this.severe("Failed to clear disk cache: " + x);
            return false;
        }
    }

    public NModule getAST(String path) throws Exception {
        if (path == null) {
            throw new IllegalArgumentException("null path");
        }
        return this.fetch(path);
    }

    public NModule getAST(String path, String contents) throws Exception {
        if (path == null) {
            throw new IllegalArgumentException("null path");
        }
        if (contents == null) {
            throw new IllegalArgumentException("null contents");
        }
        if (this.cache.containsKey(path)) {
            return this.cache.get(path);
        }
        NModule mod2 = null;
        try {
            mod2 = this.parse(path, contents);
            if (mod2 != null) {
                mod2.setFileAndMD5(path, Util.getMD5(contents.getBytes("UTF-8")));
            }
        }
        finally {
            this.cache.put(path, mod2);
        }
        return mod2;
    }

    private NModule fetch(String path) throws Exception {
        if (this.cache.containsKey(path)) {
            return this.cache.get(path);
        }
        NModule mod2 = this.getSerializedModule(path);
        if (mod2 != null) {
            this.fine("reusing " + path);
            this.cache.put(path, mod2);
            return mod2;
        }
        try {
            mod2 = this.parse(path);
        }
        finally {
            this.cache.put(path, mod2);
        }
        if (mod2 != null) {
            NModule nModule = mod2;
            AstCache astCache = this;
            String string = astCache.getCachePath(nModule.getMD5(), new File(nModule.getFile()).getName());
            ObjectOutputStream objectOutputStream = null;
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(string);
                objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(nModule);
            }
            catch (Throwable throwable) {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                } else if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                throw throwable;
            }
            objectOutputStream.close();
        }
        return mod2;
    }

    private NModule parse(String path) throws Exception {
        this.fine("parsing " + path);
        mod ast = this.invokeANTLR(path);
        return this.generateAST(ast, path);
    }

    private NModule parse(String path, String contents) throws Exception {
        this.fine("parsing " + path);
        mod ast = this.invokeANTLR(path, contents);
        return this.generateAST(ast, path);
    }

    private NModule generateAST(mod ast, String path) throws Exception {
        if (ast == null) {
            Indexer.idx.reportFailedAssertion("ANTLR returned NULL for " + path);
            return null;
        }
        Object obj = ast.accept(new AstConverter());
        if (!(obj instanceof NModule)) {
            this.warn("\n[warning] converted AST is not a module: " + obj);
            return null;
        }
        NModule module = (NModule)obj;
        if (new File(path).canRead()) {
            module.setFile(path);
        }
        return module;
    }

    private mod invokeANTLR(String filename) {
        ANTLRFileStream text;
        try {
            text = new ANTLRFileStream(filename);
        }
        catch (IOException iox) {
            this.fine(filename + ": " + iox);
            return null;
        }
        return this.invokeANTLR(text, filename);
    }

    private mod invokeANTLR(String filename, String contents) {
        ANTLRStringStream text = new ANTLRStringStream(contents);
        return this.invokeANTLR(text, filename);
    }

    private mod invokeANTLR(CharStream text, String filename) {
        AnalyzingParser p = new AnalyzingParser(text, filename, null);
        mod ast = null;
        try {
            ast = p.parseModule();
        }
        catch (Exception x) {
            this.fine("parse for " + filename + " failed: " + x);
        }
        this.recordParseErrors(filename, p.getRecognitionErrors());
        return ast;
    }

    private void recordParseErrors(String path, List<RecognitionException> errs) {
        if (errs.isEmpty()) {
            return;
        }
        String string = path;
        Indexer indexer = Indexer.idx;
        List<Diagnostic> diags = Indexer.getFileErrs(string, indexer.parseErrs);
        for (RecognitionException rx : errs) {
            String msg = rx.line + ":" + rx.charPositionInLine + ":" + rx;
            diags.add(new Diagnostic(path, Diagnostic.Type.ERROR, -1, -1, msg));
        }
    }

    public String getCachePath(File sourcePath) throws Exception {
        return this.getCachePath(Util.getMD5(sourcePath), sourcePath.getName());
    }

    public String getCachePath(String md5, String name) {
        return CACHE_DIR + name + md5 + ".ast";
    }

    private void serialize(NModule ast) throws Exception {
        String path = this.getCachePath(ast.getMD5(), new File(ast.getFile()).getName());
        ObjectOutputStream oos = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(path);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(ast);
        }
        catch (Throwable throwable) {
            if (oos != null) {
                oos.close();
            } else if (fos != null) {
                fos.close();
            }
            throw throwable;
        }
        oos.close();
    }

    final NModule getSerializedModule(String sourcePath) {
        try {
            File sourceFile = new File(sourcePath);
            if (!sourceFile.canRead()) {
                return null;
            }
            File cached = new File(this.getCachePath(sourceFile));
            if (!cached.canRead()) {
                return null;
            }
            return this.deserialize(sourceFile);
        }
        catch (Exception x) {
            this.severe("Failed to deserialize " + sourcePath + ": " + x);
            return null;
        }
    }

    private NModule deserialize(File sourcePath) throws Exception {
        NModule nModule;
        String cachePath = this.getCachePath(sourcePath);
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = new FileInputStream(cachePath);
            ois = new ObjectInputStream(fis);
            NModule mod2 = (NModule)ois.readObject();
            mod2.setFile(sourcePath);
            nModule = mod2;
        }
        catch (Throwable throwable) {
            if (ois != null) {
                ois.close();
            } else if (fis != null) {
                fis.close();
            }
            throw throwable;
        }
        ois.close();
        return nModule;
    }

    private void log(Level level, String msg) {
        if (LOG.isLoggable(level)) {
            LOG.log(level, msg);
        }
    }

    private void severe(String msg) {
        this.log(Level.SEVERE, msg);
    }

    private void warn(String msg) {
        this.log(Level.WARNING, msg);
    }

    private void info(String msg) {
        this.log(Level.INFO, msg);
    }

    private void fine(String msg) {
        this.log(Level.FINE, msg);
    }

    private void finer(String msg) {
        this.log(Level.FINER, msg);
    }
}

