/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.buffer;

import org.python.core.PyBuffer;
import org.python.core.PyException;
import org.python.core.buffer.BaseBuffer;
import org.python.core.buffer.ZeroByteBuffer;

public class Strided1DBuffer
extends BaseBuffer {
    protected int stride;

    protected Strided1DBuffer() {
        super(24);
        this.shape = new int[1];
    }

    public Strided1DBuffer(byte[] storage, int index0, int length, int stride) throws ArrayIndexOutOfBoundsException, NullPointerException {
        this();
        int hi;
        int lo;
        this.storage = storage;
        this.index0 = index0;
        this.shape[0] = length;
        this.stride = stride;
        if (length == 0) {
            this.addFeatureFlags(224);
            return;
        }
        if (stride == 1) {
            lo = index0;
            hi = index0 + length;
            this.addFeatureFlags(224);
        } else if (stride > 1) {
            lo = index0;
            hi = index0 + (length - 1) * stride + 1;
        } else {
            hi = index0 + 1;
            lo = index0 + (length - 1) * stride;
        }
        if ((length | lo | storage.length - lo | hi | storage.length - hi) < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public Strided1DBuffer(int flags, byte[] storage, int index0, int length, int stride) throws ArrayIndexOutOfBoundsException, NullPointerException, PyException {
        this(storage, index0, length, stride);
        this.checkRequestFlags(flags);
    }

    @Override
    public boolean isReadonly() {
        return true;
    }

    @Override
    public byte byteAt(int index) throws IndexOutOfBoundsException {
        return this.storage[this.index0 + index * this.stride];
    }

    @Override
    protected int calcIndex(int index) throws IndexOutOfBoundsException {
        return this.index0 + index * this.stride;
    }

    @Override
    protected int calcIndex(int ... indices) throws IndexOutOfBoundsException {
        this.checkDimension(indices.length);
        return this.calcIndex(indices[0]);
    }

    @Override
    public void copyTo(int srcIndex, byte[] dest, int destPos, int length) throws IndexOutOfBoundsException {
        int s;
        int d = destPos;
        if (this.stride == 1) {
            System.arraycopy(this.storage, s, dest, destPos, length);
            return;
        }
        int limit = s + length * this.stride;
        for (s = this.index0 + srcIndex * this.stride; s != limit; s += this.stride) {
            dest[d++] = this.storage[s];
        }
    }

    @Override
    public PyBuffer getBufferSlice(int flags, int start, int length, int stride) {
        if (length > 0) {
            int compStride = this.stride * stride;
            int compIndex0 = this.index0 + start * this.stride;
            return new SlicedView(this.getRoot(), flags, this.storage, compIndex0, length, compStride);
        }
        return new ZeroByteBuffer.View(this.getRoot(), flags);
    }

    @Override
    public PyBuffer.Pointer getPointer(int index) {
        return new PyBuffer.Pointer(this.storage, this.index0 + index * this.stride);
    }

    @Override
    public PyBuffer.Pointer getPointer(int ... indices) {
        this.checkDimension(indices.length);
        return this.getPointer(indices[0]);
    }

    @Override
    public int[] getStrides() {
        if (this.strides == null) {
            this.strides = new int[1];
            this.strides[0] = this.stride;
        }
        return this.strides;
    }

    static class SlicedView
    extends Strided1DBuffer {
        private PyBuffer root;

        public SlicedView(PyBuffer root, int flags, byte[] storage, int index0, int len, int stride) throws PyException {
            super(flags, storage, index0, len, stride);
            this.root = root.getBuffer(284);
        }

        @Override
        protected PyBuffer getRoot() {
            return this.root;
        }

        @Override
        public void releaseAction() {
            this.root.release();
        }
    }
}

