/*
 * Decompiled with CFR 0.152.
 */
package org.python.antlr.runtime;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SerializedGrammar {
    public static final String COOKIE = "$ANTLR";
    public static final int FORMAT_VERSION = 1;
    public String name;
    public char type;
    public List rules;

    public SerializedGrammar(String filename) throws IOException {
        System.out.println("loading " + filename);
        FileInputStream fis = new FileInputStream(filename);
        BufferedInputStream bos = new BufferedInputStream(fis);
        DataInputStream in = new DataInputStream(bos);
        this.readFile(in);
        in.close();
    }

    protected void readFile(DataInputStream in) throws IOException {
        String grammarName;
        char grammarType;
        String cookie = this.readString(in);
        if (!cookie.equals(COOKIE)) {
            throw new IOException("not a serialized grammar file");
        }
        in.readByte();
        this.type = grammarType = (char)in.readByte();
        this.name = grammarName = this.readString(in);
        System.out.println(grammarType + " grammar " + grammarName);
        short numRules = in.readShort();
        System.out.println("num rules = " + numRules);
        this.rules = this.readRules(in, numRules);
    }

    protected List readRules(DataInputStream in, int numRules) throws IOException {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (int i = 0; i < numRules; ++i) {
            Rule r = this.readRule(in);
            rules.add(r);
        }
        return rules;
    }

    protected Rule readRule(DataInputStream in) throws IOException {
        byte R = in.readByte();
        if (R != 82) {
            throw new IOException("missing R on start of rule");
        }
        String name = this.readString(in);
        System.out.println("rule: " + name);
        in.readByte();
        Block b = this.readBlock(in);
        byte period = in.readByte();
        if (period != 46) {
            throw new IOException("missing . on end of rule");
        }
        return new Rule(this, name, b);
    }

    protected Block readBlock(DataInputStream in) throws IOException {
        int nalts = in.readShort();
        List[] alts = new List[nalts];
        for (int i = 0; i < nalts; ++i) {
            List alt;
            alts[i] = alt = this.readAlt(in);
        }
        return new Block(this, alts);
    }

    protected List readAlt(DataInputStream in) throws IOException {
        ArrayList<Object> alt = new ArrayList<Object>();
        byte A = in.readByte();
        if (A != 65) {
            throw new IOException("missing A on start of alt");
        }
        byte cmd = in.readByte();
        while (cmd != 59) {
            switch (cmd) {
                case 116: {
                    short ttype = in.readShort();
                    alt.add(new TokenRef(this, ttype));
                    break;
                }
                case 114: {
                    short ruleIndex = in.readShort();
                    alt.add(new RuleRef(this, ruleIndex));
                    break;
                }
                case 46: {
                    break;
                }
                case 45: {
                    in.readChar();
                    in.readChar();
                    break;
                }
                case 126: {
                    in.readShort();
                    break;
                }
                case 66: {
                    Block b = this.readBlock(in);
                    alt.add(b);
                }
            }
            cmd = in.readByte();
        }
        return alt;
    }

    protected String readString(DataInputStream in) throws IOException {
        byte c = in.readByte();
        StringBuffer buf = new StringBuffer();
        while (c != 59) {
            buf.append((char)c);
            c = in.readByte();
        }
        return buf.toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.type + " grammar " + this.name);
        buf.append(this.rules);
        return buf.toString();
    }

    class RuleRef {
        private int ruleIndex;
        private /* synthetic */ SerializedGrammar this$0;

        public RuleRef(SerializedGrammar serializedGrammar, int ruleIndex) {
            this.ruleIndex = ruleIndex;
        }

        public String toString() {
            return String.valueOf(this.ruleIndex);
        }
    }

    class TokenRef {
        private int ttype;
        private /* synthetic */ SerializedGrammar this$0;

        public TokenRef(SerializedGrammar serializedGrammar, int ttype) {
            this.ttype = ttype;
        }

        public String toString() {
            return String.valueOf(this.ttype);
        }
    }

    class Block {
        private List[] alts;
        private /* synthetic */ SerializedGrammar this$0;

        public Block(SerializedGrammar serializedGrammar, List[] alts) {
            this.alts = alts;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("(");
            for (int i = 0; i < this.alts.length; ++i) {
                List alt = this.alts[i];
                if (i > 0) {
                    buf.append("|");
                }
                buf.append(alt.toString());
            }
            buf.append(")");
            return buf.toString();
        }
    }

    class Rule {
        private String name;
        private Block block;
        private /* synthetic */ SerializedGrammar this$0;

        public Rule(SerializedGrammar serializedGrammar, String name, Block block) {
            this.name = name;
            this.block = block;
        }

        public String toString() {
            return this.name + ":" + this.block;
        }
    }
}

