/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import jnr.constants.platform.Errno;
import jnr.posix.FileStat;
import jnr.posix.HANDLE;
import jnr.posix.JavaFileStat;
import jnr.posix.JavaPOSIX;
import jnr.posix.JavaPasswd;
import jnr.posix.JavaSecuredFile;
import jnr.posix.POSIXHandler;
import jnr.posix.Passwd;
import jnr.posix.util.Chmod;
import jnr.posix.util.ExecIt;
import jnr.posix.util.FieldAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaLibCHelper {
    public static final int STDIN = 0;
    public static final int STDOUT = 1;
    public static final int STDERR = 2;
    private static final ThreadLocal<Integer> errno = new ThreadLocal();
    private final POSIXHandler handler;
    private final Field fdField;
    private final Field handleField;
    private final Map<String, String> env;
    private ThreadLocal<Integer> pwIndex = new ThreadLocal<Integer>(this){
        private /* synthetic */ JavaLibCHelper this$0;

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };

    public JavaLibCHelper(POSIXHandler handler) {
        this.env = new HashMap<String, String>();
        this.handler = handler;
        this.handleField = FieldAccess.getProtectedField(FileDescriptor.class, "handle");
        this.fdField = FieldAccess.getProtectedField(FileDescriptor.class, "fd");
    }

    static int errno() {
        Integer errno2 = errno.get();
        if (errno2 != null) {
            return errno2;
        }
        return 0;
    }

    static void errno(int errno2) {
        errno.set(errno2);
    }

    static void errno(Errno errno2) {
        errno.set(errno2.intValue());
    }

    public int chmod(String filename, int mode) {
        return Chmod.chmod(new JavaSecuredFile(filename), Integer.toOctalString(mode));
    }

    public int chown(String filename, int user, int group) {
        PosixExec launcher = new PosixExec(this.handler);
        int chownResult = -1;
        int chgrpResult = -1;
        try {
            if (user != -1) {
                chownResult = launcher.runAndWait("chown", "" + user, filename);
            }
            if (group != -1) {
                chgrpResult = launcher.runAndWait("chgrp ", "" + user, filename);
            }
        }
        catch (Exception exception) {}
        if (chownResult != -1 && chgrpResult != -1) {
            return 0;
        }
        return 1;
    }

    public int getfd(FileDescriptor descriptor) {
        if (descriptor == null || this.fdField == null) {
            return -1;
        }
        try {
            return this.fdField.getInt(descriptor);
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        return -1;
    }

    public HANDLE gethandle(FileDescriptor descriptor) {
        if (descriptor == null || this.handleField == null) {
            return HANDLE.valueOf(-1L);
        }
        try {
            return HANDLE.valueOf(this.handleField.getLong(descriptor));
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        return HANDLE.valueOf(-1L);
    }

    public String getlogin() {
        return System.getProperty("user.name");
    }

    public int getpid() {
        return this.handler.getPID();
    }

    public Passwd getpwent() {
        JavaPasswd retVal = this.pwIndex.get() == 0 ? new JavaPasswd(this.handler) : null;
        this.pwIndex.set(this.pwIndex.get() + 1);
        return retVal;
    }

    public int setpwent() {
        return 0;
    }

    public int endpwent() {
        this.pwIndex.set(0);
        return 0;
    }

    public Passwd getpwuid(int which) {
        if (which == JavaPOSIX.LoginInfo.UID) {
            return new JavaPasswd(this.handler);
        }
        return null;
    }

    public int isatty(int fd) {
        if (fd == 1 || fd == 0 || fd == 2) {
            return 1;
        }
        return 0;
    }

    public int link(String oldpath, String newpath) {
        try {
            return new PosixExec(this.handler).runAndWait("ln", oldpath, newpath);
        }
        catch (Exception exception) {
            JavaLibCHelper.errno(Errno.EINVAL);
            return -1;
        }
    }

    public int lstat(String path, FileStat stat) {
        JavaSecuredFile file = new JavaSecuredFile(path);
        if (!((File)file).exists()) {
            this.handler.error(Errno.ENOENT, path);
        }
        JavaFileStat jstat = (JavaFileStat)stat;
        jstat.setup(path);
        return 0;
    }

    public int mkdir(String path, int mode) {
        JavaSecuredFile dir = new JavaSecuredFile(path);
        if (!((File)dir).mkdir()) {
            return -1;
        }
        this.chmod(path, mode);
        return 0;
    }

    public int rmdir(String path) {
        if (new JavaSecuredFile(path).delete()) {
            return 0;
        }
        return -1;
    }

    public int stat(String path, FileStat stat) {
        JavaFileStat jstat = (JavaFileStat)stat;
        try {
            JavaSecuredFile file = new JavaSecuredFile(path);
            if (!((File)file).exists()) {
                this.handler.error(Errno.ENOENT, path);
            }
            jstat.setup(((File)file).getCanonicalPath());
        }
        catch (IOException iOException) {}
        return 0;
    }

    public int symlink(String oldpath, String newpath) {
        try {
            return new PosixExec(this.handler).runAndWait("ln", "-s", oldpath, newpath);
        }
        catch (Exception exception) {
            JavaLibCHelper.errno(Errno.EEXIST);
            return -1;
        }
    }

    public int readlink(String oldpath, ByteBuffer buffer, int length) throws IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            new PosixExec(this.handler).runAndWait((OutputStream)baos, "readlink", oldpath);
            byte[] bytes = baos.toByteArray();
            if (bytes.length > length || bytes.length == 0) {
                return -1;
            }
            buffer.put(bytes, 0, bytes.length - 1);
            return buffer.position();
        }
        catch (InterruptedException interruptedException) {
            JavaLibCHelper.errno(Errno.ENOENT);
            return -1;
        }
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ErrnoParsingOutputStream
    extends OutputStream {
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        private final AtomicReference<Errno> errno;
        private static Map<Pattern, Errno> errorPatterns = new HashMap<Pattern, Errno>();

        private ErrnoParsingOutputStream(AtomicReference<Errno> errno2) {
            this.errno = errno2;
        }

        @Override
        public final void write(int b) throws IOException {
            if (b != 13 && b != 10 && b != -1) {
                this.baos.write(b);
                return;
            }
            if (this.baos.size() > 0) {
                String errorString = this.baos.toString();
                this.baos.reset();
                String string = errorString;
                ErrnoParsingOutputStream errnoParsingOutputStream = this;
                for (Map.Entry<Pattern, Errno> entry : errorPatterns.entrySet()) {
                    if (!entry.getKey().matcher(string).find()) continue;
                    errnoParsingOutputStream.errno.set(entry.getValue());
                }
            }
        }

        private void parseError(String errorString) {
            for (Map.Entry<Pattern, Errno> entry : errorPatterns.entrySet()) {
                if (!entry.getKey().matcher(errorString).find()) continue;
                this.errno.set(entry.getValue());
            }
        }

        /* synthetic */ ErrnoParsingOutputStream(AtomicReference x0, byte by) {
            this(x0);
        }

        static {
            errorPatterns.put(Pattern.compile("File exists"), Errno.EEXIST);
            errorPatterns.put(Pattern.compile("Operation not permitted"), Errno.EPERM);
            errorPatterns.put(Pattern.compile("No such file or directory"), Errno.ENOENT);
            errorPatterns.put(Pattern.compile("Input/output error"), Errno.EIO);
            errorPatterns.put(Pattern.compile("Not a directory"), Errno.ENOTDIR);
            errorPatterns.put(Pattern.compile("No space left on device"), Errno.ENOSPC);
            errorPatterns.put(Pattern.compile("Read-only file system"), Errno.EROFS);
            errorPatterns.put(Pattern.compile("Too many links"), Errno.EMLINK);
        }
    }

    static class PosixExec
    extends ExecIt {
        private final AtomicReference<Errno> errno = new AtomicReference<Errno>(Errno.EINVAL);
        private final ErrnoParsingOutputStream errorStream = new ErrnoParsingOutputStream(this.errno, 0);

        public PosixExec(POSIXHandler handler) {
            super(handler);
        }

        private int parseResult(int result) {
            if (result == 0) {
                return result;
            }
            JavaLibCHelper.errno(this.errno.get());
            return -1;
        }

        public int runAndWait(String ... args) throws IOException, InterruptedException {
            return this.runAndWait((OutputStream)this.handler.getOutputStream(), this.errorStream, args);
        }

        public int runAndWait(OutputStream output, String ... args) throws IOException, InterruptedException {
            return this.runAndWait(output, this.errorStream, args);
        }

        public int runAndWait(OutputStream output, OutputStream error, String ... args) throws IOException, InterruptedException {
            return this.parseResult(super.runAndWait(output, error, args));
        }
    }
}

