/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi;

import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import jnr.ffi.NativeType;
import jnr.ffi.Runtime;
import jnr.ffi.Struct;
import jnr.ffi.Type;
import jnr.ffi.TypeAlias;
import jnr.ffi.util.EnumMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructLayout
extends Type {
    static final Charset ASCII = Charset.forName("ASCII");
    static final Charset UTF8 = Charset.forName("UTF-8");
    private final Runtime runtime;
    private final boolean isUnion = false;
    private boolean resetIndex = false;
    private StructLayout enclosing;
    int offset = 0;
    private int size = 0;
    private int alignment = 1;
    private int paddedSize = 0;

    protected StructLayout(Runtime runtime) {
        this.runtime = runtime;
    }

    public final Runtime getRuntime() {
        return this.runtime;
    }

    @Override
    public final int size() {
        return this.paddedSize;
    }

    @Override
    public final int alignment() {
        return this.alignment;
    }

    public final int offset() {
        return this.offset;
    }

    @Override
    public NativeType getNativeType() {
        return NativeType.STRUCT;
    }

    public java.lang.String toString() {
        StringBuilder sb = new StringBuilder();
        java.lang.reflect.Field[] fields = this.getClass().getDeclaredFields();
        sb.append(this.getClass().getSimpleName()).append(" { \n");
        java.lang.reflect.Field[] arr$ = fields;
        int len$ = fields.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            try {
                sb.append("    \n");
                continue;
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
        sb.append("}\n");
        return sb.toString();
    }

    private static int align(int offset, int alignment) {
        return offset + alignment - 1 & ~(alignment - 1);
    }

    protected final int addField(int size, int align) {
        int off = this.resetIndex ? 0 : StructLayout.align(this.size, align);
        this.size = Math.max(this.size, off + size);
        this.alignment = Math.max(this.alignment, align);
        this.paddedSize = StructLayout.align(this.size, this.alignment);
        return off;
    }

    protected final int addField(int size, int align, Struct.Offset offset) {
        this.size = Math.max(this.size, offset.intValue() + size);
        this.alignment = Math.max(this.alignment, align);
        this.paddedSize = StructLayout.align(this.size, this.alignment);
        return offset.intValue();
    }

    protected final int addField(Type t) {
        return this.addField(t.size(), t.alignment());
    }

    protected final int addField(Type t, Struct.Offset offset) {
        return this.addField(t.size(), t.alignment(), offset);
    }

    protected final void arrayBegin() {
        this.resetIndex = false;
    }

    protected final void arrayEnd() {
        this.resetIndex = false;
    }

    protected <T extends Field> T[] array(T[] array) {
        this.arrayBegin();
        try {
            Class<?> arrayClass = array.getClass().getComponentType();
            Constructor<?> ctor = arrayClass.getDeclaredConstructor(arrayClass.getEnclosingClass());
            Object[] parameters = new Object[]{this};
            for (int i = 0; i < array.length; ++i) {
                array[i] = (Field)ctor.newInstance(parameters);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.arrayEnd();
        return array;
    }

    protected final <T extends StructLayout> T inner(T structLayout) {
        structLayout.offset = StructLayout.align(this.size, structLayout.alignment);
        this.size = structLayout.offset + structLayout.size;
        this.paddedSize = StructLayout.align(this.size, this.alignment());
        return structLayout;
    }

    public final class rlim_t
    extends IntegerAlias {
        private /* synthetic */ StructLayout this$0;

        public rlim_t(StructLayout structLayout) {
            super(structLayout, TypeAlias.rlim_t);
        }

        public rlim_t(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, TypeAlias.rlim_t, offset);
        }
    }

    public final class socklen_t
    extends IntegerAlias {
        private /* synthetic */ StructLayout this$0;

        public socklen_t(StructLayout structLayout) {
            super(structLayout, TypeAlias.socklen_t);
        }

        public socklen_t(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, TypeAlias.socklen_t, offset);
        }
    }

    public final class sa_family_t
    extends IntegerAlias {
        private /* synthetic */ StructLayout this$0;

        public sa_family_t(StructLayout structLayout) {
            super(structLayout, TypeAlias.sa_family_t);
        }

        public sa_family_t(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, TypeAlias.sa_family_t, offset);
        }
    }

    public final class fsfilcnt_t
    extends IntegerAlias {
        private /* synthetic */ StructLayout this$0;

        public fsfilcnt_t(StructLayout structLayout) {
            super(structLayout, TypeAlias.fsfilcnt_t);
        }

        public fsfilcnt_t(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, TypeAlias.fsfilcnt_t, offset);
        }
    }

    public final class fsblkcnt_t
    extends IntegerAlias {
        private /* synthetic */ StructLayout this$0;

        public fsblkcnt_t(StructLayout structLayout) {
            super(structLayout, TypeAlias.fsblkcnt_t);
        }

        public fsblkcnt_t(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, TypeAlias.fsblkcnt_t, offset);
        }
    }

    public final class time_t
    extends IntegerAlias {
        private /* synthetic */ StructLayout this$0;

        public time_t(StructLayout structLayout) {
            super(structLayout, TypeAlias.time_t);
        }

        public time_t(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, TypeAlias.time_t, offset);
        }
    }

    public final class ssize_t
    extends IntegerAlias {
        private /* synthetic */ StructLayout this$0;

        public ssize_t(StructLayout structLayout) {
            super(structLayout, TypeAlias.ssize_t);
        }

        public ssize_t(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, TypeAlias.ssize_t, offset);
        }
    }

    public final class size_t
    extends IntegerAlias {
        private /* synthetic */ StructLayout this$0;

        public size_t(StructLayout structLayout) {
            super(structLayout, TypeAlias.size_t);
        }

        public size_t(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, TypeAlias.size_t, offset);
        }
    }

    public final class clock_t
    extends IntegerAlias {
        private /* synthetic */ StructLayout this$0;

        public clock_t(StructLayout structLayout) {
            super(structLayout, TypeAlias.clock_t);
        }

        public clock_t(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, TypeAlias.clock_t, offset);
        }
    }

    public final class uid_t
    extends IntegerAlias {
        private /* synthetic */ StructLayout this$0;

        public uid_t(StructLayout structLayout) {
            super(structLayout, TypeAlias.uid_t);
        }

        public uid_t(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, TypeAlias.uid_t, offset);
        }
    }

    public final class swblk_t
    extends IntegerAlias {
        private /* synthetic */ StructLayout this$0;

        public swblk_t(StructLayout structLayout) {
            super(structLayout, TypeAlias.swblk_t);
        }

        public swblk_t(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, TypeAlias.swblk_t, offset);
        }
    }

    public final class off_t
    extends IntegerAlias {
        private /* synthetic */ StructLayout this$0;

        public off_t(StructLayout structLayout) {
            super(structLayout, TypeAlias.off_t);
        }

        public off_t(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, TypeAlias.off_t, offset);
        }
    }

    public final class pid_t
    extends IntegerAlias {
        private /* synthetic */ StructLayout this$0;

        public pid_t(StructLayout structLayout) {
            super(structLayout, TypeAlias.pid_t);
        }

        public pid_t(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, TypeAlias.pid_t, offset);
        }
    }

    public final class id_t
    extends IntegerAlias {
        private /* synthetic */ StructLayout this$0;

        public id_t(StructLayout structLayout) {
            super(structLayout, TypeAlias.id_t);
        }

        public id_t(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, TypeAlias.id_t, offset);
        }
    }

    public final class nlink_t
    extends IntegerAlias {
        private /* synthetic */ StructLayout this$0;

        public nlink_t(StructLayout structLayout) {
            super(structLayout, TypeAlias.nlink_t);
        }

        public nlink_t(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, TypeAlias.nlink_t, offset);
        }
    }

    public final class mode_t
    extends IntegerAlias {
        private /* synthetic */ StructLayout this$0;

        public mode_t(StructLayout structLayout) {
            super(structLayout, TypeAlias.mode_t);
        }

        public mode_t(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, TypeAlias.mode_t, offset);
        }
    }

    public final class key_t
    extends IntegerAlias {
        private /* synthetic */ StructLayout this$0;

        public key_t(StructLayout structLayout) {
            super(structLayout, TypeAlias.key_t);
        }

        public key_t(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, TypeAlias.key_t, offset);
        }
    }

    public final class ino64_t
    extends IntegerAlias {
        private /* synthetic */ StructLayout this$0;

        public ino64_t(StructLayout structLayout) {
            super(structLayout, TypeAlias.ino64_t);
        }

        public ino64_t(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, TypeAlias.ino64_t, offset);
        }
    }

    public final class ino_t
    extends IntegerAlias {
        private /* synthetic */ StructLayout this$0;

        public ino_t(StructLayout structLayout) {
            super(structLayout, TypeAlias.ino_t);
        }

        public ino_t(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, TypeAlias.ino_t, offset);
        }
    }

    public final class in_port_t
    extends IntegerAlias {
        private /* synthetic */ StructLayout this$0;

        public in_port_t(StructLayout structLayout) {
            super(structLayout, TypeAlias.in_port_t);
        }

        public in_port_t(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, TypeAlias.in_port_t, offset);
        }
    }

    public final class in_addr_t
    extends IntegerAlias {
        private /* synthetic */ StructLayout this$0;

        public in_addr_t(StructLayout structLayout) {
            super(structLayout, TypeAlias.in_addr_t);
        }

        public in_addr_t(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, TypeAlias.in_addr_t, offset);
        }
    }

    public final class gid_t
    extends IntegerAlias {
        private /* synthetic */ StructLayout this$0;

        public gid_t(StructLayout structLayout) {
            super(structLayout, TypeAlias.gid_t);
        }

        public gid_t(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, TypeAlias.gid_t, offset);
        }
    }

    public final class blksize_t
    extends IntegerAlias {
        private /* synthetic */ StructLayout this$0;

        public blksize_t(StructLayout structLayout) {
            super(structLayout, TypeAlias.blksize_t);
        }

        public blksize_t(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, TypeAlias.blksize_t, offset);
        }
    }

    public final class blkcnt_t
    extends IntegerAlias {
        private /* synthetic */ StructLayout this$0;

        public blkcnt_t(StructLayout structLayout) {
            super(structLayout, TypeAlias.blkcnt_t);
        }

        public blkcnt_t(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, TypeAlias.blkcnt_t, offset);
        }
    }

    public final class dev_t
    extends IntegerAlias {
        private /* synthetic */ StructLayout this$0;

        public dev_t(StructLayout structLayout) {
            super(structLayout, TypeAlias.dev_t);
        }

        public dev_t(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, TypeAlias.dev_t, offset);
        }
    }

    public final class caddr_t
    extends IntegerAlias {
        private /* synthetic */ StructLayout this$0;

        public caddr_t(StructLayout structLayout) {
            super(structLayout, TypeAlias.caddr_t);
        }

        public caddr_t(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, TypeAlias.caddr_t, offset);
        }
    }

    public final class uintptr_t
    extends IntegerAlias {
        private /* synthetic */ StructLayout this$0;

        public uintptr_t(StructLayout structLayout) {
            super(structLayout, TypeAlias.uintptr_t);
        }

        public uintptr_t(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, TypeAlias.uintptr_t, offset);
        }
    }

    public final class intptr_t
    extends IntegerAlias {
        private /* synthetic */ StructLayout this$0;

        public intptr_t(StructLayout structLayout) {
            super(structLayout, TypeAlias.intptr_t);
        }

        public intptr_t(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, TypeAlias.intptr_t, offset);
        }
    }

    public final class u_int64_t
    extends IntegerAlias {
        private /* synthetic */ StructLayout this$0;

        public u_int64_t(StructLayout structLayout) {
            super(structLayout, TypeAlias.u_int64_t);
        }

        public u_int64_t(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, TypeAlias.u_int64_t, offset);
        }
    }

    public final class int64_t
    extends IntegerAlias {
        private /* synthetic */ StructLayout this$0;

        public int64_t(StructLayout structLayout) {
            super(structLayout, TypeAlias.int64_t);
        }

        public int64_t(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, TypeAlias.int64_t, offset);
        }
    }

    public final class u_int32_t
    extends IntegerAlias {
        private /* synthetic */ StructLayout this$0;

        public u_int32_t(StructLayout structLayout) {
            super(structLayout, TypeAlias.u_int32_t);
        }

        public u_int32_t(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, TypeAlias.u_int32_t, offset);
        }
    }

    public final class int32_t
    extends IntegerAlias {
        private /* synthetic */ StructLayout this$0;

        public int32_t(StructLayout structLayout) {
            super(structLayout, TypeAlias.int32_t);
        }

        public int32_t(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, TypeAlias.int32_t, offset);
        }
    }

    public final class u_int16_t
    extends IntegerAlias {
        private /* synthetic */ StructLayout this$0;

        public u_int16_t(StructLayout structLayout) {
            super(structLayout, TypeAlias.u_int16_t);
        }

        public u_int16_t(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, TypeAlias.u_int16_t, offset);
        }
    }

    public final class int16_t
    extends IntegerAlias {
        private /* synthetic */ StructLayout this$0;

        public int16_t(StructLayout structLayout) {
            super(structLayout, TypeAlias.int16_t);
        }

        public int16_t(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, TypeAlias.int16_t, offset);
        }
    }

    public final class u_int8_t
    extends IntegerAlias {
        private /* synthetic */ StructLayout this$0;

        public u_int8_t(StructLayout structLayout) {
            super(structLayout, TypeAlias.u_int8_t);
        }

        public u_int8_t(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, TypeAlias.u_int8_t, offset);
        }
    }

    public final class int8_t
    extends IntegerAlias {
        private /* synthetic */ StructLayout this$0;

        public int8_t(StructLayout structLayout) {
            super(structLayout, TypeAlias.int8_t);
        }

        public int8_t(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, TypeAlias.int8_t, offset);
        }
    }

    public final class Padding
    extends AbstractField {
        private /* synthetic */ StructLayout this$0;

        public Padding(StructLayout structLayout, Type type, int length) {
            super(structLayout, type.size() * length, type.alignment());
        }

        public Padding(StructLayout structLayout, NativeType type, int length) {
            this(structLayout, structLayout.getRuntime().findType(type), length);
        }
    }

    public class AsciiStringRef
    extends UTFStringRef {
        private /* synthetic */ StructLayout this$0;

        public AsciiStringRef(StructLayout structLayout, int size) {
            super(structLayout, size, ASCII);
        }

        public AsciiStringRef(StructLayout structLayout) {
            super(structLayout, Integer.MAX_VALUE, ASCII);
        }
    }

    public class UTF8StringRef
    extends UTFStringRef {
        private /* synthetic */ StructLayout this$0;

        public UTF8StringRef(StructLayout structLayout, int size) {
            super(structLayout, size, UTF8);
        }

        public UTF8StringRef(StructLayout structLayout) {
            super(structLayout, Integer.MAX_VALUE, UTF8);
        }
    }

    public class UTFStringRef
    extends String {
        private jnr.ffi.Pointer valueHolder;
        private /* synthetic */ StructLayout this$0;

        public UTFStringRef(StructLayout structLayout, int length, Charset cs) {
            this.this$0 = structLayout;
            super(structLayout, structLayout.getRuntime().findType(NativeType.ADDRESS).size(), structLayout.getRuntime().findType(NativeType.ADDRESS).alignment(), length, cs);
        }

        public UTFStringRef(StructLayout structLayout, Charset cs) {
            this(structLayout, Integer.MAX_VALUE, cs);
        }

        protected jnr.ffi.Pointer getStringMemory(jnr.ffi.Pointer ptr) {
            return ptr.getPointer(this.offset(), this.length());
        }

        public final java.lang.String get(jnr.ffi.Pointer ptr) {
            jnr.ffi.Pointer memory = this.getStringMemory(ptr);
            if (memory != null) {
                return memory.getString(0L, this.length, this.charset);
            }
            return null;
        }

        public final void set(jnr.ffi.Pointer ptr, java.lang.String value) {
            if (value != null) {
                this.valueHolder = this.this$0.getRuntime().getMemoryManager().allocateDirect(this.length() << 2);
                this.valueHolder.putString(0L, value, this.length() << 2, this.charset);
                ptr.putPointer(this.offset(), this.valueHolder);
                return;
            }
            this.valueHolder = null;
            ptr.putAddress(this.offset(), 0L);
        }
    }

    public class AsciiString
    extends UTFString {
        private /* synthetic */ StructLayout this$0;

        public AsciiString(StructLayout structLayout, int size) {
            super(structLayout, size, ASCII);
        }
    }

    public class UTF8String
    extends UTFString {
        private /* synthetic */ StructLayout this$0;

        public UTF8String(StructLayout structLayout, int size) {
            super(structLayout, size, UTF8);
        }
    }

    public class UTFString
    extends String {
        private /* synthetic */ StructLayout this$0;

        public UTFString(StructLayout structLayout, int length, Charset cs) {
            super(structLayout, length, 1, length, cs);
        }

        protected jnr.ffi.Pointer getStringMemory(jnr.ffi.Pointer ptr) {
            return ptr.slice(this.offset(), this.length());
        }

        public final java.lang.String get(jnr.ffi.Pointer ptr) {
            return this.getStringMemory(ptr).getString(0L, this.length, this.charset);
        }

        public final void set(jnr.ffi.Pointer ptr, java.lang.String value) {
            this.getStringMemory(ptr).putString(0L, value, this.length, this.charset);
        }
    }

    public abstract class String
    extends AbstractField {
        protected final Charset charset;
        protected final int length;
        private /* synthetic */ StructLayout this$0;

        protected String(StructLayout structLayout, int size, int align, int length, Charset cs) {
            super(structLayout, size, align);
            this.length = length;
            this.charset = cs;
        }

        protected String(StructLayout structLayout, int size, int align, Struct.Offset offset, int length, Charset cs) {
            super(structLayout, size, align, offset);
            this.length = length;
            this.charset = cs;
        }

        public final int length() {
            return this.length;
        }

        protected abstract jnr.ffi.Pointer getStringMemory(jnr.ffi.Pointer var1);

        public abstract java.lang.String get(jnr.ffi.Pointer var1);

        public abstract void set(jnr.ffi.Pointer var1, java.lang.String var2);

        public final java.lang.String toString(jnr.ffi.Pointer ptr) {
            return this.get(ptr);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Enum<T extends java.lang.Enum<T>>
    extends Enum32<T> {
        private /* synthetic */ StructLayout this$0;

        public Enum(StructLayout structLayout, Class<T> enumClass) {
            super(structLayout, enumClass);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EnumLong<E extends java.lang.Enum<E>>
    extends EnumField<E> {
        private /* synthetic */ StructLayout this$0;

        public EnumLong(StructLayout structLayout, Class<E> enumClass) {
            super(structLayout, NativeType.SLONG, enumClass);
        }

        public final void set(jnr.ffi.Pointer ptr, E value) {
            ptr.putNativeLong(this.offset(), this.enumMapper.intValue((java.lang.Enum)value));
        }

        @Override
        public void set(jnr.ffi.Pointer ptr, Number value) {
            ptr.putNativeLong(this.offset(), value.longValue());
        }

        @Override
        public final int intValue(jnr.ffi.Pointer ptr) {
            return (int)this.longValue(ptr);
        }

        @Override
        public final long longValue(jnr.ffi.Pointer ptr) {
            return ptr.getNativeLong(this.offset());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Enum64<E extends java.lang.Enum<E>>
    extends EnumField<E> {
        private /* synthetic */ StructLayout this$0;

        public Enum64(StructLayout structLayout, Class<E> enumClass) {
            super(structLayout, NativeType.SLONGLONG, enumClass);
        }

        public final void set(jnr.ffi.Pointer ptr, E value) {
            ptr.putLongLong(this.offset(), this.enumMapper.intValue((java.lang.Enum)value));
        }

        @Override
        public void set(jnr.ffi.Pointer ptr, Number value) {
            ptr.putLongLong(this.offset(), value.longValue());
        }

        @Override
        public final int intValue(jnr.ffi.Pointer ptr) {
            return (int)this.longValue(ptr);
        }

        @Override
        public final long longValue(jnr.ffi.Pointer ptr) {
            return ptr.getLongLong(this.offset());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Enum32<E extends java.lang.Enum<E>>
    extends EnumField<E> {
        private /* synthetic */ StructLayout this$0;

        public Enum32(StructLayout structLayout, Class<E> enumClass) {
            super(structLayout, NativeType.SINT, enumClass);
        }

        public void set(jnr.ffi.Pointer ptr, E value) {
            ptr.putInt(this.offset(), this.enumMapper.intValue((java.lang.Enum)value));
        }

        @Override
        public void set(jnr.ffi.Pointer ptr, Number value) {
            ptr.putInt(this.offset(), value.intValue());
        }

        @Override
        public final int intValue(jnr.ffi.Pointer ptr) {
            return ptr.getInt(this.offset());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Enum16<E extends java.lang.Enum<E>>
    extends EnumField<E> {
        private /* synthetic */ StructLayout this$0;

        public Enum16(StructLayout structLayout, Class<E> enumClass) {
            super(structLayout, NativeType.SSHORT, enumClass);
        }

        public void set(jnr.ffi.Pointer ptr, E value) {
            ptr.putShort(this.offset(), (short)this.enumMapper.intValue((java.lang.Enum)value));
        }

        @Override
        public void set(jnr.ffi.Pointer ptr, Number value) {
            ptr.putShort(this.offset(), value.shortValue());
        }

        @Override
        public final int intValue(jnr.ffi.Pointer ptr) {
            return ptr.getShort(this.offset());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Enum8<E extends java.lang.Enum<E>>
    extends EnumField<E> {
        private /* synthetic */ StructLayout this$0;

        public Enum8(StructLayout structLayout, Class<E> enumClass) {
            super(structLayout, NativeType.SCHAR, enumClass);
        }

        public final void set(jnr.ffi.Pointer ptr, E value) {
            ptr.putByte(this.offset(), (byte)this.enumMapper.intValue((java.lang.Enum)value));
        }

        @Override
        public void set(jnr.ffi.Pointer ptr, Number value) {
            ptr.putByte(this.offset(), value.byteValue());
        }

        @Override
        public final int intValue(jnr.ffi.Pointer ptr) {
            return ptr.getByte(this.offset());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class EnumField<E extends java.lang.Enum<E>>
    extends NumberField {
        protected final Class<E> enumClass;
        protected final EnumMapper enumMapper;
        private /* synthetic */ StructLayout this$0;

        public EnumField(StructLayout structLayout, NativeType type, Class<E> enumClass) {
            super(structLayout, type);
            this.enumClass = enumClass;
            this.enumMapper = EnumMapper.getInstance(enumClass);
        }

        public E get(jnr.ffi.Pointer ptr) {
            return (E)((java.lang.Enum)this.enumClass.cast(this.enumMapper.valueOf(this.intValue(ptr))));
        }

        @Override
        public final java.lang.String toString(jnr.ffi.Pointer ptr) {
            return ((java.lang.Enum)this.get(ptr)).toString();
        }
    }

    public class Pointer
    extends NumberField {
        private /* synthetic */ StructLayout this$0;

        public Pointer(StructLayout structLayout) {
            this.this$0 = structLayout;
            super(structLayout, NativeType.ADDRESS);
        }

        public Pointer(StructLayout structLayout, Struct.Offset offset) {
            this.this$0 = structLayout;
            super(structLayout, NativeType.ADDRESS, offset);
        }

        public final jnr.ffi.Pointer get(jnr.ffi.Pointer ptr) {
            return ptr.getPointer(this.offset());
        }

        public final int size() {
            return this.this$0.getRuntime().findType(NativeType.ADDRESS).size();
        }

        public final void set(jnr.ffi.Pointer ptr, jnr.ffi.Pointer value) {
            ptr.putPointer(this.offset(), value);
        }

        public void set(jnr.ffi.Pointer ptr, Number value) {
            ptr.putAddress(this.offset(), value.longValue());
        }

        public final int intValue(jnr.ffi.Pointer ptr) {
            return (int)ptr.getAddress(this.offset());
        }

        public final long longValue(jnr.ffi.Pointer ptr) {
            return ptr.getAddress(this.offset());
        }

        public final java.lang.String toString(jnr.ffi.Pointer ptr) {
            return this.get(ptr).toString();
        }
    }

    public final class Double
    extends NumberField {
        private /* synthetic */ StructLayout this$0;

        public Double(StructLayout structLayout) {
            super(structLayout, NativeType.DOUBLE);
        }

        public Double(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, NativeType.DOUBLE, offset);
        }

        public final double get(jnr.ffi.Pointer ptr) {
            return ptr.getDouble(this.offset());
        }

        public final void set(jnr.ffi.Pointer ptr, double value) {
            ptr.putDouble(this.offset(), value);
        }

        public final void set(jnr.ffi.Pointer ptr, Number value) {
            ptr.putDouble(this.offset(), value.doubleValue());
        }

        public final int intValue(jnr.ffi.Pointer ptr) {
            return (int)this.get(ptr);
        }

        public final long longValue(jnr.ffi.Pointer ptr) {
            return (long)this.get(ptr);
        }

        public final float floatValue(jnr.ffi.Pointer ptr) {
            return (float)this.get(ptr);
        }

        public final double doubleValue(jnr.ffi.Pointer ptr) {
            return this.get(ptr);
        }

        public final java.lang.String toString(jnr.ffi.Pointer ptr) {
            return java.lang.String.valueOf(this.get(ptr));
        }
    }

    public class Float
    extends NumberField {
        private /* synthetic */ StructLayout this$0;

        public Float(StructLayout structLayout) {
            super(structLayout, NativeType.FLOAT);
        }

        public Float(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, NativeType.FLOAT, offset);
        }

        public final float get(jnr.ffi.Pointer ptr) {
            return ptr.getFloat(this.offset());
        }

        public final void set(jnr.ffi.Pointer ptr, float value) {
            ptr.putFloat(this.offset(), value);
        }

        public void set(jnr.ffi.Pointer ptr, Number value) {
            ptr.putFloat(this.offset(), value.floatValue());
        }

        public final int intValue(jnr.ffi.Pointer ptr) {
            return (int)this.get(ptr);
        }

        public final double doubleValue(jnr.ffi.Pointer ptr) {
            return this.get(ptr);
        }

        public final float floatValue(jnr.ffi.Pointer ptr) {
            return this.get(ptr);
        }

        public final long longValue(jnr.ffi.Pointer ptr) {
            return (long)this.get(ptr);
        }

        public final java.lang.String toString(jnr.ffi.Pointer ptr) {
            return java.lang.String.valueOf(this.get(ptr));
        }
    }

    public class UnsignedLong
    extends NumberField {
        private /* synthetic */ StructLayout this$0;

        public UnsignedLong(StructLayout structLayout) {
            this.this$0 = structLayout;
            super(structLayout, NativeType.ULONG);
        }

        public UnsignedLong(StructLayout structLayout, Struct.Offset offset) {
            this.this$0 = structLayout;
            super(structLayout, NativeType.ULONG, offset);
        }

        public final long get(jnr.ffi.Pointer ptr) {
            long mask;
            long value = ptr.getNativeLong(this.offset());
            long l = mask = this.this$0.getRuntime().findType(NativeType.SLONG).size() == 4 ? 0xFFFFFFFFL : -1L;
            if (value < 0L) {
                return (value & mask) + mask + 1L;
            }
            return value;
        }

        public final void set(jnr.ffi.Pointer ptr, long value) {
            ptr.putNativeLong(this.offset(), value);
        }

        public void set(jnr.ffi.Pointer ptr, Number value) {
            ptr.putNativeLong(this.offset(), value.longValue());
        }

        public final int intValue(jnr.ffi.Pointer ptr) {
            return (int)this.get(ptr);
        }

        public final long longValue(jnr.ffi.Pointer ptr) {
            return this.get(ptr);
        }

        public final java.lang.String toString(jnr.ffi.Pointer ptr) {
            return Long.toString(this.get(ptr));
        }
    }

    public class SignedLong
    extends NumberField {
        private /* synthetic */ StructLayout this$0;

        public SignedLong(StructLayout structLayout) {
            super(structLayout, NativeType.SLONG);
        }

        public SignedLong(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, NativeType.SLONG, offset);
        }

        public final long get(jnr.ffi.Pointer ptr) {
            return ptr.getNativeLong(this.offset());
        }

        public final void set(jnr.ffi.Pointer ptr, long value) {
            ptr.putNativeLong(this.offset(), value);
        }

        public void set(jnr.ffi.Pointer ptr, Number value) {
            ptr.putNativeLong(this.offset(), value.longValue());
        }

        public final int intValue(jnr.ffi.Pointer ptr) {
            return (int)this.get(ptr);
        }

        public final long longValue(jnr.ffi.Pointer ptr) {
            return this.get(ptr);
        }

        public final java.lang.String toString(jnr.ffi.Pointer ptr) {
            return Long.toString(this.get(ptr));
        }
    }

    public class Unsigned64
    extends NumberField {
        private /* synthetic */ StructLayout this$0;

        public Unsigned64(StructLayout structLayout) {
            super(structLayout, NativeType.ULONGLONG);
        }

        public Unsigned64(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, NativeType.ULONGLONG, offset);
        }

        public final long get(jnr.ffi.Pointer ptr) {
            return ptr.getLongLong(this.offset());
        }

        public final void set(jnr.ffi.Pointer ptr, long value) {
            ptr.putLongLong(this.offset(), value);
        }

        public void set(jnr.ffi.Pointer ptr, Number value) {
            ptr.putLongLong(this.offset(), value.longValue());
        }

        public final int intValue(jnr.ffi.Pointer ptr) {
            return (int)this.get(ptr);
        }

        public final long longValue(jnr.ffi.Pointer ptr) {
            return this.get(ptr);
        }

        public final java.lang.String toString(jnr.ffi.Pointer ptr) {
            return Long.toString(this.get(ptr));
        }
    }

    public class Signed64
    extends NumberField {
        private /* synthetic */ StructLayout this$0;

        public Signed64(StructLayout structLayout) {
            super(structLayout, NativeType.SLONGLONG);
        }

        public Signed64(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, NativeType.SLONGLONG, offset);
        }

        public final long get(jnr.ffi.Pointer ptr) {
            return ptr.getLongLong(this.offset());
        }

        public final void set(jnr.ffi.Pointer ptr, long value) {
            ptr.putLongLong(this.offset(), value);
        }

        public void set(jnr.ffi.Pointer ptr, Number value) {
            ptr.putLongLong(this.offset(), value.longValue());
        }

        public final int intValue(jnr.ffi.Pointer ptr) {
            return (int)this.get(ptr);
        }

        public final long longValue(jnr.ffi.Pointer ptr) {
            return this.get(ptr);
        }

        public final java.lang.String toString(jnr.ffi.Pointer ptr) {
            return Long.toString(this.get(ptr));
        }
    }

    public class Unsigned32
    extends NumberField {
        private /* synthetic */ StructLayout this$0;

        public Unsigned32(StructLayout structLayout) {
            super(structLayout, NativeType.UINT);
        }

        public Unsigned32(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, NativeType.SINT, offset);
        }

        public final long get(jnr.ffi.Pointer ptr) {
            long value = ptr.getInt(this.offset());
            if (value < 0L) {
                return (value & Integer.MAX_VALUE) + 0x80000000L;
            }
            return value;
        }

        public final void set(jnr.ffi.Pointer ptr, long value) {
            ptr.putInt(this.offset(), (int)value);
        }

        public void set(jnr.ffi.Pointer ptr, Number value) {
            ptr.putInt(this.offset(), value.intValue());
        }

        public final int intValue(jnr.ffi.Pointer ptr) {
            return (int)this.get(ptr);
        }

        public final long longValue(jnr.ffi.Pointer ptr) {
            return this.get(ptr);
        }
    }

    public class Signed32
    extends NumberField {
        private /* synthetic */ StructLayout this$0;

        public Signed32(StructLayout structLayout) {
            super(structLayout, NativeType.SINT);
        }

        public Signed32(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, NativeType.SINT, offset);
        }

        public final int get(jnr.ffi.Pointer ptr) {
            return ptr.getInt(this.offset());
        }

        public final void set(jnr.ffi.Pointer ptr, int value) {
            ptr.putInt(this.offset(), value);
        }

        public void set(jnr.ffi.Pointer ptr, Number value) {
            ptr.putInt(this.offset(), value.intValue());
        }

        public final int intValue(jnr.ffi.Pointer ptr) {
            return this.get(ptr);
        }
    }

    public class Unsigned16
    extends NumberField {
        private /* synthetic */ StructLayout this$0;

        public Unsigned16(StructLayout structLayout) {
            super(structLayout, NativeType.USHORT);
        }

        public Unsigned16(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, NativeType.USHORT, offset);
        }

        public final int get(jnr.ffi.Pointer ptr) {
            short value = ptr.getShort(this.offset());
            if (value < 0) {
                return (value & Short.MAX_VALUE) + 32768;
            }
            return value;
        }

        public final void set(jnr.ffi.Pointer ptr, int value) {
            ptr.putShort(this.offset(), (short)value);
        }

        public void set(jnr.ffi.Pointer ptr, Number value) {
            ptr.putShort(this.offset(), value.shortValue());
        }

        public final int intValue(jnr.ffi.Pointer ptr) {
            return this.get(ptr);
        }
    }

    public class Signed16
    extends NumberField {
        private /* synthetic */ StructLayout this$0;

        public Signed16(StructLayout structLayout) {
            super(structLayout, NativeType.SSHORT);
        }

        public Signed16(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, NativeType.SSHORT, offset);
        }

        public final short get(jnr.ffi.Pointer ptr) {
            return ptr.getShort(this.offset());
        }

        public final void set(jnr.ffi.Pointer ptr, short value) {
            ptr.putShort(this.offset(), value);
        }

        public void set(jnr.ffi.Pointer ptr, Number value) {
            ptr.putShort(this.offset(), value.shortValue());
        }

        public final short shortValue(jnr.ffi.Pointer ptr) {
            return this.get(ptr);
        }

        public final int intValue(jnr.ffi.Pointer ptr) {
            return this.get(ptr);
        }
    }

    public class Unsigned8
    extends NumberField {
        private /* synthetic */ StructLayout this$0;

        public Unsigned8(StructLayout structLayout) {
            super(structLayout, NativeType.UCHAR);
        }

        public Unsigned8(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, NativeType.UCHAR, offset);
        }

        public final short get(jnr.ffi.Pointer ptr) {
            short value = ptr.getByte(this.offset());
            if (value < 0) {
                return (short)((value & 0x7F) + 128);
            }
            return value;
        }

        public final void set(jnr.ffi.Pointer ptr, short value) {
            ptr.putByte(this.offset(), (byte)value);
        }

        public void set(jnr.ffi.Pointer ptr, Number value) {
            ptr.putByte(this.offset(), value.byteValue());
        }

        public final short shortValue(jnr.ffi.Pointer ptr) {
            return this.get(ptr);
        }

        public final int intValue(jnr.ffi.Pointer ptr) {
            return this.get(ptr);
        }
    }

    public class Signed8
    extends NumberField {
        private /* synthetic */ StructLayout this$0;

        public Signed8(StructLayout structLayout) {
            super(structLayout, NativeType.SCHAR);
        }

        public Signed8(StructLayout structLayout, Struct.Offset offset) {
            super(structLayout, NativeType.SCHAR, offset);
        }

        public final byte get(jnr.ffi.Pointer ptr) {
            return ptr.getByte(this.offset());
        }

        public final void set(jnr.ffi.Pointer ptr, byte value) {
            ptr.putByte(this.offset(), value);
        }

        public void set(jnr.ffi.Pointer ptr, Number value) {
            ptr.putByte(this.offset(), value.byteValue());
        }

        public final byte byteValue(jnr.ffi.Pointer ptr) {
            return this.get(ptr);
        }

        public final short shortValue(jnr.ffi.Pointer ptr) {
            return this.get(ptr);
        }

        public final int intValue(jnr.ffi.Pointer ptr) {
            return this.get(ptr);
        }
    }

    public abstract class IntegerAlias
    extends NumberField {
        private /* synthetic */ StructLayout this$0;

        IntegerAlias(StructLayout structLayout, TypeAlias type) {
            super(structLayout, structLayout.getRuntime().findType(type));
        }

        IntegerAlias(StructLayout structLayout, TypeAlias type, Struct.Offset offset) {
            super(structLayout, structLayout.getRuntime().findType(type), offset);
        }

        public void set(jnr.ffi.Pointer ptr, Number value) {
            ptr.putInt(this.type, this.offset(), value.longValue());
        }

        public void set(jnr.ffi.Pointer ptr, long value) {
            ptr.putInt(this.type, this.offset(), value);
        }

        public final long get(jnr.ffi.Pointer ptr) {
            return ptr.getInt(this.type, this.offset());
        }

        public int intValue(jnr.ffi.Pointer ptr) {
            return (int)this.get(ptr);
        }

        public long longValue(jnr.ffi.Pointer ptr) {
            return this.get(ptr);
        }
    }

    public abstract class NumberField
    extends Field {
        protected final Type type;
        private /* synthetic */ StructLayout this$0;

        protected NumberField(StructLayout structLayout, NativeType nativeType) {
            this(structLayout, structLayout.getRuntime().findType(nativeType));
        }

        protected NumberField(StructLayout structLayout, Type type) {
            super(structLayout, structLayout.addField(type));
            this.type = type;
        }

        protected NumberField(StructLayout structLayout, NativeType nativeType, Struct.Offset offset) {
            this(structLayout, structLayout.getRuntime().findType(nativeType), offset);
        }

        protected NumberField(StructLayout structLayout, Type type, Struct.Offset offset) {
            super(structLayout, structLayout.addField(type, offset));
            this.type = type;
        }

        public abstract void set(jnr.ffi.Pointer var1, Number var2);

        public double doubleValue(jnr.ffi.Pointer ptr) {
            return this.longValue(ptr);
        }

        public float floatValue(jnr.ffi.Pointer ptr) {
            return this.intValue(ptr);
        }

        public byte byteValue(jnr.ffi.Pointer ptr) {
            return (byte)this.intValue(ptr);
        }

        public short shortValue(jnr.ffi.Pointer ptr) {
            return (short)this.intValue(ptr);
        }

        public abstract int intValue(jnr.ffi.Pointer var1);

        public long longValue(jnr.ffi.Pointer ptr) {
            return this.intValue(ptr);
        }

        public java.lang.String toString(jnr.ffi.Pointer ptr) {
            return Integer.toString(this.intValue(ptr), 10);
        }
    }

    public final class WBOOL
    extends AbstractBoolean {
        private /* synthetic */ StructLayout this$0;

        protected WBOOL(StructLayout structLayout) {
            super(structLayout, NativeType.SINT);
        }

        public final boolean get(jnr.ffi.Pointer ptr) {
            return (ptr.getInt(this.offset()) & 1) != 0;
        }

        public final void set(jnr.ffi.Pointer ptr, boolean value) {
            ptr.putInt(this.offset(), value ? 1 : 0);
        }
    }

    public final class Boolean
    extends AbstractBoolean {
        private /* synthetic */ StructLayout this$0;

        protected Boolean(StructLayout structLayout) {
            super(structLayout, NativeType.SCHAR);
        }

        public final boolean get(jnr.ffi.Pointer ptr) {
            return (ptr.getByte(this.offset()) & 1) != 0;
        }

        public final void set(jnr.ffi.Pointer ptr, boolean value) {
            ptr.putByte(this.offset(), (byte)(value ? 1 : 0));
        }
    }

    public abstract class AbstractBoolean
    extends AbstractField {
        private /* synthetic */ StructLayout this$0;

        protected AbstractBoolean(StructLayout structLayout, NativeType type) {
            super(structLayout, type);
        }

        public abstract boolean get(jnr.ffi.Pointer var1);

        public abstract void set(jnr.ffi.Pointer var1, boolean var2);

        public java.lang.String toString(jnr.ffi.Pointer ptr) {
            return java.lang.Boolean.toString(this.get(ptr));
        }
    }

    public abstract class AbstractField
    extends Field {
        private /* synthetic */ StructLayout this$0;

        protected AbstractField(StructLayout structLayout, int size, int align, Struct.Offset offset) {
            super(structLayout, structLayout.addField(size, align, offset));
        }

        protected AbstractField(StructLayout structLayout, int size, int align) {
            super(structLayout, structLayout.addField(size, align));
        }

        protected AbstractField(StructLayout structLayout, NativeType type) {
            super(structLayout, structLayout.addField(structLayout.getRuntime().findType(type)));
        }

        protected AbstractField(StructLayout structLayout, Type type) {
            super(structLayout, structLayout.addField(type));
        }

        protected AbstractField(StructLayout structLayout, NativeType type, Struct.Offset offset) {
            super(structLayout, structLayout.addField(structLayout.getRuntime().findType(type), offset));
        }

        protected AbstractField(StructLayout structLayout, Type type, Struct.Offset offset) {
            super(structLayout, structLayout.addField(type, offset));
        }
    }

    public abstract class Field {
        private final int offset;
        private /* synthetic */ StructLayout this$0;

        protected Field(StructLayout structLayout, int offset) {
            this.this$0 = structLayout;
            this.offset = offset;
        }

        public final StructLayout enclosing() {
            return this.this$0;
        }

        public final long offset() {
            return this.offset + this.this$0.offset;
        }
    }
}

