/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import com.kenai.jffi.ArrayFlags;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.python.google.common.base.CharMatcher;
import org.python.google.common.base.Function;
import org.python.google.common.base.Objects$ToStringHelper;
import org.python.google.common.collect.ComputingConcurrentHashMap;
import org.python.google.common.collect.GenericMapMaker;
import org.python.google.common.collect.ImmutableEntry;
import org.python.google.common.collect.MapMakerInternalMap;

public final class MapMaker
extends GenericMapMaker<Object, Object> {
    private boolean useCustomMap;
    private int initialCapacity = -1;
    private int concurrencyLevel = -1;
    int maximumSize = -1;
    private MapMakerInternalMap.Strength keyStrength;
    MapMakerInternalMap.Strength valueStrength;
    long expireAfterWriteNanos = -1L;
    long expireAfterAccessNanos = -1L;

    final int getInitialCapacity() {
        if (this.initialCapacity == -1) {
            return 16;
        }
        return this.initialCapacity;
    }

    final int getConcurrencyLevel() {
        if (this.concurrencyLevel == -1) {
            return 4;
        }
        return this.concurrencyLevel;
    }

    public final MapMaker weakKeys() {
        MapMakerInternalMap.Strength strength = MapMakerInternalMap.Strength.WEAK;
        MapMaker mapMaker = this;
        CharMatcher.LookupTable.checkState(mapMaker.keyStrength == null, "Key strength was already set to %s", new Object[]{mapMaker.keyStrength});
        mapMaker.keyStrength = CharMatcher.LookupTable.checkNotNull(strength);
        if (strength != MapMakerInternalMap.Strength.STRONG) {
            mapMaker.useCustomMap = true;
        }
        return mapMaker;
    }

    final MapMakerInternalMap.Strength getKeyStrength() {
        return CharMatcher.LookupTable.firstNonNull(this.keyStrength, MapMakerInternalMap.Strength.STRONG);
    }

    public final MapMaker weakValues() {
        MapMakerInternalMap.Strength strength = MapMakerInternalMap.Strength.WEAK;
        MapMaker mapMaker = this;
        CharMatcher.LookupTable.checkState(mapMaker.valueStrength == null, "Value strength was already set to %s", new Object[]{mapMaker.valueStrength});
        mapMaker.valueStrength = CharMatcher.LookupTable.checkNotNull(strength);
        if (strength != MapMakerInternalMap.Strength.STRONG) {
            mapMaker.useCustomMap = true;
        }
        return mapMaker;
    }

    public final <K, V> ConcurrentMap<K, V> makeMap() {
        if (!this.useCustomMap) {
            return new ConcurrentHashMap(this.getInitialCapacity(), 0.75f, this.getConcurrencyLevel());
        }
        return new MapMakerInternalMap(this);
    }

    @Deprecated
    public final <K, V> ConcurrentMap<K, V> makeComputingMap(Function<? super K, ? extends V> computingFunction) {
        return new ComputingConcurrentHashMap.ComputingMapAdapter<K, V>(this, computingFunction);
    }

    public final String toString() {
        Objects$ToStringHelper s = CharMatcher.LookupTable.toStringHelper(this);
        if (this.initialCapacity != -1) {
            s.add("initialCapacity", this.initialCapacity);
        }
        if (this.concurrencyLevel != -1) {
            s.add("concurrencyLevel", this.concurrencyLevel);
        }
        if (this.maximumSize != -1) {
            s.add("maximumSize", this.maximumSize);
        }
        if (this.expireAfterWriteNanos != -1L) {
            s.add("expireAfterWrite", this.expireAfterWriteNanos + "ns");
        }
        if (this.expireAfterAccessNanos != -1L) {
            s.add("expireAfterAccess", this.expireAfterAccessNanos + "ns");
        }
        if (this.keyStrength != null) {
            s.add("keyStrength", ArrayFlags.toLowerCase(this.keyStrength.toString()));
        }
        if (this.valueStrength != null) {
            s.add("valueStrength", ArrayFlags.toLowerCase(this.valueStrength.toString()));
        }
        return s.toString();
    }

    static abstract class RemovalCause
    extends Enum<RemovalCause> {
        public static final /* enum */ RemovalCause EXPLICIT = new RemovalCause(){};
        public static final /* enum */ RemovalCause REPLACED = new RemovalCause(){};
        public static final /* enum */ RemovalCause COLLECTED = new RemovalCause(){};
        public static final /* enum */ RemovalCause EXPIRED = new RemovalCause(){};
        public static final /* enum */ RemovalCause SIZE = new RemovalCause(){};

        private RemovalCause() {
        }

        /* synthetic */ RemovalCause(String x0, int x1, byte by) {
            this();
        }

        static {
            RemovalCause[] removalCauseArray = new RemovalCause[]{EXPLICIT, REPLACED, COLLECTED, EXPIRED, SIZE};
        }
    }

    static final class RemovalNotification<K, V>
    extends ImmutableEntry<K, V> {
        RemovalNotification(@Nullable K key, @Nullable V value, RemovalCause cause) {
            super(key, value);
        }
    }

    static interface RemovalListener<K, V> {
    }
}

