/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.packagecache;

import java.io.File;
import java.util.Properties;
import java.util.StringTokenizer;
import org.python.core.Py;
import org.python.core.PyJavaPackage;
import org.python.core.PyList;
import org.python.core.PySystemState;
import org.python.core.packagecache.PathPackageManager;

public final class SysPackageManager
extends PathPackageManager {
    @Override
    protected final void message(String msg) {
        Py.writeMessage("*sys-package-mgr*", msg);
    }

    @Override
    protected final void warning(String warn) {
        Py.writeWarning("*sys-package-mgr*", warn);
    }

    @Override
    protected final void comment(String msg) {
        Py.writeComment("*sys-package-mgr*", msg);
    }

    @Override
    protected final void debug(String msg) {
        Py.writeDebug("*sys-package-mgr*", msg);
    }

    public SysPackageManager(File cachedir, Properties registry) {
        if (this.useCacheDir(cachedir)) {
            String string;
            String string2;
            this.initCache();
            Properties properties = registry;
            SysPackageManager sysPackageManager = this;
            String string3 = properties.getProperty("python.packages.paths", "java.class.path,sun.boot.class.path");
            String string4 = properties.getProperty("python.packages.directories", "java.ext.dirs");
            String string5 = properties.getProperty("python.packages.fakepath", null);
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken().trim();
                string = properties.getProperty(string2);
                if (string == null) continue;
                sysPackageManager.addClassPath(string);
            }
            stringTokenizer = new StringTokenizer(string4, ",");
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken().trim();
                string = properties.getProperty(string2);
                if (string == null) continue;
                sysPackageManager.addJarPath(string);
            }
            if (string5 != null) {
                sysPackageManager.addClassPath(string5);
            }
            this.saveCache();
        }
    }

    @Override
    public final void addJar(String jarfile, boolean cache) {
        this.addJarToPackages(new File(jarfile), true);
        this.saveCache();
    }

    @Override
    public final void addJarDir(String jdir, boolean cache) {
        this.addJarDir(jdir, cache, cache);
    }

    private void addJarDir(String jdir, boolean cache, boolean saveCache) {
        File file = new File(jdir);
        if (!file.isDirectory()) {
            return;
        }
        String[] files = file.list();
        for (int i = 0; i < files.length; ++i) {
            String entry = files[i];
            if (!entry.endsWith(".jar") && !entry.endsWith(".zip")) continue;
            this.addJarToPackages(new File(jdir, entry), cache);
        }
        if (saveCache) {
            this.saveCache();
        }
    }

    private void addJarPath(String path) {
        StringTokenizer tok = new StringTokenizer(path, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            String entry = tok.nextToken();
            this.addJarDir(entry, true, false);
        }
    }

    @Override
    public final void notifyPackageImport(String pkg, String name) {
        if (pkg != null && pkg.length() > 0) {
            name = pkg + '.' + name;
        }
        Py.writeComment("import", "'" + name + "' as java package");
    }

    @Override
    public final Class findClass(String pkg, String name) {
        Class c = super.findClass(pkg, name);
        if (c != null) {
            Py.writeComment("import", "'" + name + "' as java class");
        }
        return c;
    }

    @Override
    public final Class findClass(String pkg, String name, String reason) {
        if (pkg != null && pkg.length() > 0) {
            name = pkg + '.' + name;
        }
        return Py.findClassEx(name, reason);
    }

    @Override
    public final PyList doDir(PyJavaPackage jpkg, boolean instantiate, boolean exclpkgs) {
        PyList basic = SysPackageManager.basicDoDir(jpkg, instantiate, false);
        PyList ret = new PyList();
        this.doDir(this.searchPath, ret, jpkg, instantiate, false);
        PySystemState system = Py.getSystemState();
        if (system.getClassLoader() == null) {
            this.doDir(system.path, ret, jpkg, instantiate, false);
        }
        return SysPackageManager.merge(basic, ret);
    }

    @Override
    public final boolean packageExists(String pkg, String name) {
        if (SysPackageManager.packageExists(this.searchPath, pkg, name)) {
            return true;
        }
        PySystemState system = Py.getSystemState();
        return system.getClassLoader() == null && SysPackageManager.packageExists(Py.getSystemState().path, pkg, name);
    }
}

