/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.types;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.python.indexer.Indexer;
import org.python.indexer.types.NClassType;
import org.python.indexer.types.NDictType;
import org.python.indexer.types.NFuncType;
import org.python.indexer.types.NListType;
import org.python.indexer.types.NTupleType;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

public final class NUnionType
extends NType {
    private Set<NType> types = new HashSet<NType>();

    public NUnionType() {
    }

    public NUnionType(NType ... initialTypes) {
        this();
        NType[] arr$ = initialTypes;
        int len$ = initialTypes.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            NType nt = arr$[i$];
            this.addType(nt);
        }
    }

    public final Set<NType> getTypes() {
        return this.types;
    }

    private void addType(NType t) {
        if (t == null) {
            throw new IllegalArgumentException("null type");
        }
        NType nType = t;
        if (nType instanceof NUnionType) {
            nType = t;
            this.types.addAll(((NUnionType)nType).types);
            return;
        }
        this.types.add(t);
    }

    public final boolean contains(NType t) {
        return this.types.contains(t);
    }

    public static NType union(NType u, NType v) {
        NType wv;
        NType wu = NUnknownType.follow(u);
        if (wu == (wv = NUnknownType.follow(v))) {
            return u;
        }
        if (wu == Indexer.idx.builtins.None) {
            return v;
        }
        if (wv == Indexer.idx.builtins.None) {
            return u;
        }
        NType nType = wu;
        if (nType instanceof NUnknownType && !NUnionType.occurs(wu, wv, 0)) {
            NUnknownType.point(wu, wv);
            return u;
        }
        nType = wv;
        if (nType instanceof NUnknownType && !NUnionType.occurs(wv, wu, 0)) {
            NUnknownType.point(wv, wu);
            return v;
        }
        nType = wu;
        if (nType instanceof NTupleType && (nType = wv) instanceof NTupleType) {
            NTupleType tu = (NTupleType)wu;
            NTupleType tv = (NTupleType)wv;
            if (tu.getElementTypes().size() == tv.getElementTypes().size()) {
                NTupleType ret = new NTupleType();
                for (int i = 0; i < tu.getElementTypes().size(); ++i) {
                    ret.add(NUnionType.union(tu.getElementTypes().get(i), tv.getElementTypes().get(i)));
                }
                return ret;
            }
            return NUnionType.newUnion(wu, wv);
        }
        nType = wu;
        if (nType instanceof NListType && (nType = wv) instanceof NListType) {
            NType nType2 = wu;
            nType = nType2;
            nType = wv;
            return new NListType(NUnionType.union(((NListType)nType2).getElementType(), ((NListType)nType).getElementType()));
        }
        nType = wu;
        if (nType instanceof NDictType && (nType = wv) instanceof NDictType) {
            NDictType du = (NDictType)wu;
            NDictType dv = (NDictType)wv;
            return new NDictType(NUnionType.union(du.getKeyType(), dv.getKeyType()), NUnionType.union(du.getValueType(), dv.getValueType()));
        }
        nType = wu;
        if (nType instanceof NFuncType && (nType = wv) instanceof NFuncType) {
            NType nType3 = wu;
            nType = nType3;
            nType = wv;
            return new NFuncType(NUnionType.union(((NFuncType)nType3).getReturnType(), ((NFuncType)nType).getReturnType()));
        }
        nType = wu;
        if (nType instanceof NFuncType && (nType = wv) instanceof NClassType) {
            nType = wu;
            NUnknownType.point(((NFuncType)nType).getReturnType(), wv);
            NUnknownType.point(u, wv);
            return u;
        }
        nType = wu;
        if (nType instanceof NClassType && (nType = wv) instanceof NFuncType) {
            nType = wv;
            NUnknownType.point(((NFuncType)nType).getReturnType(), wu);
            NUnknownType.point(v, wu);
            return v;
        }
        return NUnionType.newUnion(wu, wv);
    }

    private static boolean occurs(NType u, NType v, int depth) {
        NType nType;
        while (true) {
            if (depth++ > 15) {
                return true;
            }
            if ((u = NUnknownType.follow(u)) == (v = NUnknownType.follow(v))) {
                return true;
            }
            nType = v;
            if (nType instanceof NTupleType) {
                nType = v;
                for (NType vv : ((NTupleType)nType).getElementTypes()) {
                    if (!NUnionType.occurs(u, vv, depth)) continue;
                    return true;
                }
                return false;
            }
            nType = v;
            if (nType instanceof NListType) {
                nType = v;
                v = ((NListType)nType).getElementType();
                continue;
            }
            nType = v;
            if (nType instanceof NDictType) {
                nType = v;
                return NUnionType.occurs(u, ((NDictType)nType).getKeyType(), depth) || NUnionType.occurs(u, ((NDictType)(nType = v)).getValueType(), depth);
            }
            nType = v;
            if (!(nType instanceof NFuncType)) break;
            nType = v;
            NType ret = ((NFuncType)nType).getReturnType();
            if (NUnionType.occurs(v, ret, depth)) {
                return true;
            }
            v = ret;
        }
        nType = v;
        if (nType instanceof NUnionType) {
            nType = v;
            for (NType vv : ((NUnionType)nType).types) {
                if (!NUnionType.occurs(u, vv, depth)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static NUnionType newUnion(NType ... types) {
        NUnionType ret = new NUnionType();
        NType[] arr$ = types;
        for (int i$ = 0; i$ < 2; ++i$) {
            NType type = arr$[i$];
            ret.addType(type);
        }
        return ret;
    }

    public final NType firstKnownNonNullAlternate() {
        Iterator<NType> i$ = this.types.iterator();
        while (i$.hasNext()) {
            NType tt;
            NType type;
            NType nType = type = i$.next();
            nType = tt = NUnknownType.follow(type);
            if (tt instanceof NUnknownType || tt == Indexer.idx.builtins.None) continue;
            return type;
        }
        return null;
    }

    @Override
    public final void printKids(NType.CyclicTypeRecorder ctr, StringBuilder sb) {
        sb.append("[");
        for (NType u : this.types) {
            u.print(ctr, sb);
            sb.append(",");
        }
        sb.setLength(sb.length() - 1);
        sb.append("]");
    }
}

