/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import java.util.List;
import javax.annotation.Nullable;
import org.python.google.common.base.CharMatcher;
import org.python.google.common.collect.EmptyImmutableList;
import org.python.google.common.collect.ImmutableList;
import org.python.google.common.collect.Iterators;
import org.python.google.common.collect.ObjectArrays;
import org.python.google.common.collect.UnmodifiableIterator;

final class SingletonImmutableList<E>
extends ImmutableList<E> {
    private transient E element;

    SingletonImmutableList(E element) {
        this.element = CharMatcher.LookupTable.checkNotNull(element);
    }

    @Override
    public final E get(int index) {
        CharMatcher.LookupTable.checkElementIndex(index, 1);
        return this.element;
    }

    @Override
    public final int indexOf(@Nullable Object object) {
        if (this.element.equals(object)) {
            return 0;
        }
        return -1;
    }

    @Override
    public final UnmodifiableIterator<E> iterator() {
        return Iterators.singletonIterator(this.element);
    }

    @Override
    public final int lastIndexOf(@Nullable Object object) {
        return this.indexOf(object);
    }

    @Override
    public final int size() {
        return 1;
    }

    @Override
    public final ImmutableList<E> subList(int fromIndex, int toIndex) {
        CharMatcher.LookupTable.checkPositionIndexes(fromIndex, toIndex, 1);
        if (fromIndex == toIndex) {
            return EmptyImmutableList.INSTANCE;
        }
        return this;
    }

    @Override
    public final boolean contains(@Nullable Object object) {
        return this.element.equals(object);
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof List) {
            List that = (List)object;
            return that.size() == 1 && this.element.equals(that.get(0));
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return 31 + this.element.hashCode();
    }

    @Override
    public final String toString() {
        String elementToString = this.element.toString();
        return new StringBuilder(elementToString.length() + 2).append('[').append(elementToString).append(']').toString();
    }

    @Override
    public final boolean isEmpty() {
        return false;
    }

    @Override
    final boolean isPartialView() {
        return false;
    }

    @Override
    public final Object[] toArray() {
        return new Object[]{this.element};
    }

    @Override
    public final <T> T[] toArray(T[] array) {
        if (array.length == 0) {
            array = ObjectArrays.newArray(array, 1);
        } else if (array.length > 1) {
            array[1] = null;
        }
        T[] objectArray = array;
        array[0] = this.element;
        return array;
    }
}

