/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import java.util.Set;
import javax.annotation.Nullable;
import org.python.google.common.base.CharMatcher;
import org.python.google.common.collect.ImmutableSet;
import org.python.google.common.collect.Iterators;
import org.python.google.common.collect.ObjectArrays;
import org.python.google.common.collect.UnmodifiableIterator;

final class SingletonImmutableSet<E>
extends ImmutableSet<E> {
    private transient E element;
    private transient int cachedHashCode;

    SingletonImmutableSet(E element) {
        this.element = CharMatcher.LookupTable.checkNotNull(element);
    }

    @Override
    public final int size() {
        return 1;
    }

    @Override
    public final boolean isEmpty() {
        return false;
    }

    @Override
    public final boolean contains(Object target) {
        return this.element.equals(target);
    }

    @Override
    public final UnmodifiableIterator<E> iterator() {
        return Iterators.singletonIterator(this.element);
    }

    @Override
    final boolean isPartialView() {
        return false;
    }

    @Override
    public final Object[] toArray() {
        return new Object[]{this.element};
    }

    @Override
    public final <T> T[] toArray(T[] array) {
        if (array.length == 0) {
            array = ObjectArrays.newArray(array, 1);
        } else if (array.length > 1) {
            array[1] = null;
        }
        T[] objectArray = array;
        array[0] = this.element;
        return array;
    }

    @Override
    public final boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Set) {
            Set that = (Set)object;
            return that.size() == 1 && this.element.equals(that.iterator().next());
        }
        return false;
    }

    @Override
    public final int hashCode() {
        int code = this.cachedHashCode;
        if (code == 0) {
            this.cachedHashCode = code = this.element.hashCode();
        }
        return code;
    }

    @Override
    final boolean isHashCodeFast() {
        return this.cachedHashCode != 0;
    }

    @Override
    public final String toString() {
        String elementToString = this.element.toString();
        return new StringBuilder(elementToString.length() + 2).append('[').append(elementToString).append(']').toString();
    }
}

