/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix;

import jnr.ffi.Pointer;
import jnr.posix.POSIX;
import jnr.posix.UnixLibC;

public abstract class SpawnFileAction {
    abstract boolean act(POSIX var1, Pointer var2);

    public static SpawnFileAction dup(int fd, int newfd) {
        return new Dup(fd, newfd);
    }

    public static SpawnFileAction open(String path, int fd, int flags, int mode) {
        return new Open(path, fd, flags, mode);
    }

    public static SpawnFileAction close(int fd) {
        return new Close(fd);
    }

    static final class Close
    extends SpawnFileAction {
        private int fd;

        public Close(int fd) {
            this.fd = fd;
        }

        final boolean act(POSIX posix, Pointer nativeFileActions) {
            return ((UnixLibC)posix.libc()).posix_spawn_file_actions_addclose(nativeFileActions, this.fd) == 0;
        }
    }

    static final class Open
    extends SpawnFileAction {
        private String path;
        private int fd;
        private int flags;
        private int mode;

        public Open(String path, int fd, int flags, int mode) {
            this.path = path;
            this.fd = fd;
            this.flags = flags;
            this.mode = mode;
        }

        final boolean act(POSIX posix, Pointer nativeFileActions) {
            return ((UnixLibC)posix.libc()).posix_spawn_file_actions_addopen(nativeFileActions, this.fd, this.path, this.flags, this.mode) == 0;
        }
    }

    static final class Dup
    extends SpawnFileAction {
        private int fd;
        private int newfd;

        public Dup(int fd, int newfd) {
            this.fd = fd;
            this.newfd = newfd;
        }

        final boolean act(POSIX posix, Pointer nativeFileActions) {
            return ((UnixLibC)posix.libc()).posix_spawn_file_actions_adddup2(nativeFileActions, this.fd, this.newfd) == 0;
        }
    }
}

