/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.Function;
import com.kenai.jffi.HeapInvocationBuffer;
import com.kenai.jffi.MemoryIO;
import com.kenai.jffi.ObjectParameterStrategy;
import com.kenai.jffi.ObjectParameterType;
import com.kenai.jffi.Platform;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.Charset;
import jnr.ffi.Address;
import jnr.ffi.Pointer;
import jnr.ffi.Struct;
import jnr.ffi.provider.AbstractArrayMemoryIO;
import jnr.ffi.provider.AbstractBufferMemoryIO;
import jnr.ffi.provider.DelegatingMemoryIO;
import jnr.ffi.provider.InvocationSession;
import jnr.ffi.provider.ParameterFlags;
import jnr.ffi.provider.jffi.ArrayMemoryParameterStrategy;
import jnr.ffi.provider.jffi.DirectBufferMemoryParameterStrategy;
import jnr.ffi.provider.jffi.DirectBufferParameterStrategy;
import jnr.ffi.provider.jffi.DirectMemoryIO;
import jnr.ffi.provider.jffi.DirectMemoryParameterStrategy;
import jnr.ffi.provider.jffi.DirectPointerParameterStrategy;
import jnr.ffi.provider.jffi.DirectStructParameterStrategy;
import jnr.ffi.provider.jffi.HeapBufferParameterStrategy;
import jnr.ffi.provider.jffi.HeapStructParameterStrategy;
import jnr.ffi.provider.jffi.MemoryUtil;
import jnr.ffi.provider.jffi.NativeRuntime;
import jnr.ffi.provider.jffi.NullPointerParameterStrategy;
import jnr.ffi.provider.jffi.PointerParameterStrategy;
import jnr.ffi.provider.jffi.PrimitiveArrayParameterStrategy;
import jnr.ffi.provider.jffi.StringParameterStrategy;
import jnr.ffi.provider.jffi.TransientNativeMemory;
import jnr.ffi.util.BufferUtil;
import jnr.ffi.util.EnumMapper;

public final class AsmRuntime {
    public static final MemoryIO IO = MemoryIO.getInstance();

    private AsmRuntime() {
    }

    public static final void marshal(HeapInvocationBuffer buffer, byte[] array, int flags) {
        if (array == null) {
            buffer.putAddress(0L);
            return;
        }
        buffer.putArray(array, 0, array.length, flags);
    }

    public static final void marshal(HeapInvocationBuffer buffer, short[] array, int flags) {
        if (array == null) {
            buffer.putAddress(0L);
            return;
        }
        buffer.putArray(array, 0, array.length, flags);
    }

    public static final void marshal(HeapInvocationBuffer buffer, int[] array, int flags) {
        if (array == null) {
            buffer.putAddress(0L);
            return;
        }
        buffer.putArray(array, 0, array.length, flags);
    }

    public static final void marshal(HeapInvocationBuffer buffer, long[] array, int nativeArrayFlags) {
        if (array == null) {
            buffer.putAddress(0L);
            return;
        }
        buffer.putArray(array, 0, array.length, nativeArrayFlags);
    }

    public static final void marshal32(HeapInvocationBuffer buffer, InvocationSession session, long[] array, int nativeArrayFlags) {
        if (array == null) {
            buffer.putAddress(0L);
            return;
        }
        int[] nativeArray = new int[array.length];
        int n = nativeArrayFlags;
        if ((n & 3) != 2) {
            for (int i = 0; i < array.length; ++i) {
                nativeArray[i] = (int)array[i];
            }
        }
        buffer.putArray(nativeArray, 0, nativeArray.length, nativeArrayFlags);
        n = nativeArrayFlags;
        if ((n & 3) != 1) {
            session.addPostInvoke(new InvocationSession.PostInvoke(nativeArray, array){
                private /* synthetic */ int[] val$nativeArray;
                private /* synthetic */ long[] val$array;
                {
                    this.val$nativeArray = nArray;
                    this.val$array = lArray;
                }

                public final void postInvoke() {
                    for (int i = 0; i < this.val$nativeArray.length; ++i) {
                        this.val$array[i] = this.val$nativeArray[i];
                    }
                }
            });
        }
    }

    public static final void marshal(HeapInvocationBuffer buffer, float[] array, int flags) {
        if (array == null) {
            buffer.putAddress(0L);
            return;
        }
        buffer.putArray(array, 0, array.length, flags);
    }

    public static final void marshal(HeapInvocationBuffer buffer, double[] array, int flags) {
        if (array == null) {
            buffer.putAddress(0L);
            return;
        }
        buffer.putArray(array, 0, array.length, flags);
    }

    public static final void marshal(HeapInvocationBuffer buffer, Pointer ptr, int nativeArrayFlags) {
        if (ptr == null) {
            buffer.putAddress(0L);
            return;
        }
        if (ptr.isDirect()) {
            buffer.putAddress(ptr.address());
            return;
        }
        if (ptr instanceof AbstractArrayMemoryIO) {
            AbstractArrayMemoryIO aio = (AbstractArrayMemoryIO)ptr;
            buffer.putArray(aio.array(), aio.offset(), aio.length(), nativeArrayFlags);
            return;
        }
        if (ptr instanceof AbstractBufferMemoryIO) {
            AbstractBufferMemoryIO bio = (AbstractBufferMemoryIO)ptr;
            AsmRuntime.marshal(buffer, bio.getByteBuffer(), nativeArrayFlags);
            return;
        }
        throw new IllegalArgumentException("unsupported argument type " + ptr.getClass());
    }

    public static final void marshal(HeapInvocationBuffer buffer, Address ptr) {
        if (ptr == null) {
            buffer.putAddress(0L);
            return;
        }
        buffer.putAddress(ptr.nativeAddress());
    }

    public static void marshal(HeapInvocationBuffer buffer, Buffer buf, int flags) {
        if (buf == null) {
            buffer.putAddress(0L);
            return;
        }
        if (buf instanceof ByteBuffer) {
            AsmRuntime.marshal(buffer, (ByteBuffer)buf, flags);
            return;
        }
        if (buf instanceof ShortBuffer) {
            AsmRuntime.marshal(buffer, (ShortBuffer)buf, flags);
            return;
        }
        if (buf instanceof IntBuffer) {
            AsmRuntime.marshal(buffer, (IntBuffer)buf, flags);
            return;
        }
        if (buf instanceof LongBuffer) {
            AsmRuntime.marshal(buffer, (LongBuffer)buf, flags);
            return;
        }
        if (buf instanceof FloatBuffer) {
            AsmRuntime.marshal(buffer, (FloatBuffer)buf, flags);
            return;
        }
        if (buf instanceof DoubleBuffer) {
            AsmRuntime.marshal(buffer, (DoubleBuffer)buf, flags);
            return;
        }
        throw new IllegalArgumentException("cannot marshal unknown Buffer type: " + buf.getClass());
    }

    public static final void marshal(HeapInvocationBuffer buffer, ByteBuffer buf, int flags) {
        if (buf == null) {
            buffer.putAddress(0L);
            return;
        }
        if (buf.hasArray()) {
            buffer.putArray(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining(), flags);
            return;
        }
        if (buf.isDirect()) {
            buffer.putDirectBuffer(buf, buf.position(), buf.remaining());
            return;
        }
        throw new IllegalArgumentException("cannot marshal non-direct, non-array ByteBuffer");
    }

    public static final void marshal(HeapInvocationBuffer buffer, ShortBuffer buf, int flags) {
        if (buf == null) {
            buffer.putAddress(0L);
            return;
        }
        if (buf.hasArray()) {
            buffer.putArray(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining(), flags);
            return;
        }
        if (buf.isDirect()) {
            buffer.putDirectBuffer(buf, buf.position() << 1, buf.remaining() << 1);
            return;
        }
        throw new IllegalArgumentException("cannot marshal non-direct, non-array ShortBuffer");
    }

    public static final void marshal(HeapInvocationBuffer buffer, IntBuffer buf, int flags) {
        if (buf == null) {
            buffer.putAddress(0L);
            return;
        }
        if (buf.hasArray()) {
            buffer.putArray(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining(), flags);
            return;
        }
        if (buf.isDirect()) {
            buffer.putDirectBuffer(buf, buf.position() << 2, buf.remaining() << 2);
            return;
        }
        throw new IllegalArgumentException("cannot marshal non-direct, non-array IntBuffer");
    }

    public static final void marshal(HeapInvocationBuffer buffer, LongBuffer buf, int flags) {
        if (buf == null) {
            buffer.putAddress(0L);
            return;
        }
        if (buf.hasArray()) {
            buffer.putArray(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining(), flags);
            return;
        }
        if (buf.isDirect()) {
            buffer.putDirectBuffer(buf, buf.position() << 3, buf.remaining() << 3);
            return;
        }
        throw new IllegalArgumentException("cannot marshal non-direct, non-array LongBuffer");
    }

    public static final void marshal(HeapInvocationBuffer buffer, FloatBuffer buf, int flags) {
        if (buf == null) {
            buffer.putAddress(0L);
            return;
        }
        if (buf.hasArray()) {
            buffer.putArray(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining(), flags);
            return;
        }
        if (buf.isDirect()) {
            buffer.putDirectBuffer(buf, buf.position() << 2, buf.remaining() << 2);
            return;
        }
        throw new IllegalArgumentException("cannot marshal non-direct, non-array FloatBuffer");
    }

    public static final void marshal(HeapInvocationBuffer buffer, DoubleBuffer buf, int flags) {
        if (buf == null) {
            buffer.putAddress(0L);
            return;
        }
        if (buf.hasArray()) {
            buffer.putArray(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining(), flags);
            return;
        }
        if (buf.isDirect()) {
            buffer.putDirectBuffer(buf, buf.position() << 3, buf.remaining() << 3);
            return;
        }
        throw new IllegalArgumentException("cannot marshal non-direct, non-array DoubleBuffer");
    }

    public static final void marshal(HeapInvocationBuffer buffer, CharSequence cs) {
        if (cs == null) {
            buffer.putAddress(0L);
            return;
        }
        ByteBuffer buf = Charset.defaultCharset().encode(CharBuffer.wrap(cs));
        buffer.putArray(buf.array(), buf.arrayOffset(), buf.remaining(), 5);
    }

    public static final void marshal(HeapInvocationBuffer buffer, Struct parameter, int parameterFlags, int nativeArrayFlags) {
        if (parameter == null) {
            buffer.putAddress(0L);
            return;
        }
        Struct s = parameter;
        Pointer memory = Struct.getMemory(s, parameterFlags);
        if (memory instanceof AbstractArrayMemoryIO) {
            AbstractArrayMemoryIO aio = (AbstractArrayMemoryIO)memory;
            buffer.putArray(aio.array(), aio.offset(), aio.length(), nativeArrayFlags);
            return;
        }
        if (memory.isDirect()) {
            buffer.putAddress(memory.address());
        }
    }

    public static final void marshal(HeapInvocationBuffer buffer, Struct[] parameter, int parameterFlags, int nativeArrayFlags) {
        if (parameter == null) {
            buffer.putAddress(0L);
            return;
        }
        Struct[] array = parameter;
        Pointer memory = Struct.getMemory(parameter[0], parameterFlags);
        if (!(memory instanceof DelegatingMemoryIO)) {
            throw new RuntimeException("Struct array must be backed by contiguous array");
        }
        if ((memory = ((DelegatingMemoryIO)((Object)memory)).getDelegatedMemoryIO()) instanceof AbstractArrayMemoryIO) {
            AbstractArrayMemoryIO aio = (AbstractArrayMemoryIO)memory;
            buffer.putArray(aio.array(), aio.offset(), aio.length(), nativeArrayFlags);
            return;
        }
        if (memory.isDirect()) {
            buffer.putAddress(memory.address());
        }
    }

    public static final void marshal(HeapInvocationBuffer buffer, InvocationSession session, StringBuilder parameter, int inout, int nflags) {
        ByteBuffer tmp;
        ByteBuffer buf;
        if (parameter == null) {
            buffer.putAddress(0L);
            return;
        }
        StringBuilder sb = parameter;
        ByteBuffer byteBuffer = buf = ParameterFlags.isIn(inout) ? Charset.defaultCharset().encode(CharBuffer.wrap(parameter)) : ByteBuffer.allocate(sb.capacity() + 1);
        if (ParameterFlags.isOut(inout) && buf.capacity() < sb.capacity() + 1) {
            tmp = ByteBuffer.allocate(sb.capacity() + 1);
            tmp.put(buf);
            tmp.flip();
            buf = tmp;
        }
        buffer.putArray(buf.array(), buf.arrayOffset(), buf.capacity(), nflags);
        if (ParameterFlags.isOut(inout)) {
            tmp = buf;
            session.addPostInvoke(new InvocationSession.PostInvoke(tmp, sb){
                private /* synthetic */ ByteBuffer val$tmp;
                private /* synthetic */ StringBuilder val$sb;
                {
                    this.val$tmp = byteBuffer;
                    this.val$sb = stringBuilder;
                }

                public final void postInvoke() {
                    this.val$tmp.limit(this.val$tmp.capacity());
                    this.val$tmp.position(0);
                    this.val$sb.delete(0, this.val$sb.length()).append(BufferUtil.getCharSequence(this.val$tmp, Charset.defaultCharset()));
                }
            });
        }
    }

    public static final void marshal(HeapInvocationBuffer buffer, InvocationSession session, StringBuffer parameter, int inout, int nflags) {
        ByteBuffer tmp;
        ByteBuffer buf;
        if (parameter == null) {
            buffer.putAddress(0L);
            return;
        }
        StringBuffer sb = parameter;
        ByteBuffer byteBuffer = buf = ParameterFlags.isIn(inout) ? Charset.defaultCharset().encode(CharBuffer.wrap(parameter)) : ByteBuffer.allocate(sb.capacity() + 1);
        if (ParameterFlags.isOut(inout) && buf.capacity() < sb.capacity() + 1) {
            tmp = ByteBuffer.allocate(sb.capacity() + 1);
            tmp.put(buf);
            tmp.flip();
            buf = tmp;
        }
        buffer.putArray(buf.array(), buf.arrayOffset(), buf.capacity(), nflags);
        if (ParameterFlags.isOut(inout)) {
            tmp = buf;
            session.addPostInvoke(new InvocationSession.PostInvoke(tmp, sb){
                private /* synthetic */ ByteBuffer val$tmp;
                private /* synthetic */ StringBuffer val$sb;
                {
                    this.val$tmp = byteBuffer;
                    this.val$sb = stringBuffer;
                }

                public final void postInvoke() {
                    this.val$tmp.limit(this.val$tmp.capacity());
                    this.val$tmp.position(0);
                    this.val$sb.delete(0, this.val$sb.length()).append(BufferUtil.getCharSequence(this.val$tmp, Charset.defaultCharset()));
                }
            });
        }
    }

    public static final void marshal(HeapInvocationBuffer buffer, InvocationSession session, CharSequence[] strings, int inout, int nativeArrayFlags) {
        if (strings == null) {
            buffer.putAddress(0L);
            return;
        }
        Pointer[] pointers = new Pointer[strings.length];
        Charset charset = Charset.defaultCharset();
        if (ParameterFlags.isIn(inout)) {
            for (int i = 0; i < strings.length; ++i) {
                if (strings[i] != null) {
                    ByteBuffer buf = charset.encode(CharBuffer.wrap(strings[i]));
                    DirectMemoryIO ptr = TransientNativeMemory.allocate(NativeRuntime.getInstance(), buf.remaining() + 1, 1, false);
                    ptr.putZeroTerminatedByteArray(0L, buf.array(), buf.arrayOffset() + buf.position(), buf.remaining());
                    pointers[i] = ptr;
                    continue;
                }
                pointers[i] = null;
            }
        }
        AsmRuntime.marshal(buffer, session, pointers, inout, nativeArrayFlags);
        session.keepAlive(pointers);
        if (ParameterFlags.isOut(inout)) {
            session.addPostInvoke(new InvocationSession.PostInvoke(pointers, strings){
                private /* synthetic */ Pointer[] val$pointers;
                private /* synthetic */ CharSequence[] val$strings;
                {
                    this.val$pointers = pointerArray;
                    this.val$strings = charSequenceArray;
                }

                public final void postInvoke() {
                    for (int i = 0; i < this.val$pointers.length; ++i) {
                        if (this.val$pointers[i] == null) continue;
                        this.val$strings[i] = this.val$pointers[i].getString(0L);
                    }
                }
            });
        }
    }

    public static final void marshal(HeapInvocationBuffer buffer, Enum parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("enum value cannot be null");
        }
        buffer.putInt(EnumMapper.getInstance(parameter.getClass()).intValue(parameter));
    }

    public static final void marshal(HeapInvocationBuffer buffer, Boolean parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("Boolean value cannot be null");
        }
        buffer.putInt(parameter != false ? 1 : 0);
    }

    public static final void marshal(HeapInvocationBuffer buffer, boolean parameter) {
        buffer.putInt(parameter ? 1 : 0);
    }

    public static final void marshal(HeapInvocationBuffer buffer, InvocationSession session, Pointer[] pointers, int inout, int nativeArrayFlags) {
        if (pointers == null) {
            buffer.putAddress(0L);
            return;
        }
        if (Platform.getPlatform().addressSize() == 32) {
            int[] raw = new int[pointers.length + 1];
            for (int i = 0; i < pointers.length; ++i) {
                if (pointers[i] != null && !pointers[i].isDirect()) {
                    throw new IllegalArgumentException("invalid pointer in array at index " + i);
                }
                raw[i] = pointers[i] != null ? (int)pointers[i].address() : 0;
            }
            buffer.putArray(raw, 0, raw.length, nativeArrayFlags);
            if (ParameterFlags.isOut(inout)) {
                session.addPostInvoke(new InvocationSession.PostInvoke(pointers, raw){
                    private /* synthetic */ Pointer[] val$pointers;
                    private /* synthetic */ int[] val$raw;
                    {
                        this.val$pointers = pointerArray;
                        this.val$raw = nArray;
                    }

                    public final void postInvoke() {
                        for (int i = 0; i < this.val$pointers.length; ++i) {
                            this.val$pointers[i] = MemoryUtil.newPointer(this.val$raw[i]);
                        }
                    }
                });
            }
            return;
        }
        long[] raw = new long[pointers.length + 1];
        for (int i = 0; i < pointers.length; ++i) {
            if (pointers[i] != null && !pointers[i].isDirect()) {
                throw new IllegalArgumentException("invalid pointer in array at index " + i);
            }
            raw[i] = pointers[i] != null ? pointers[i].address() : 0L;
        }
        buffer.putArray(raw, 0, raw.length, nativeArrayFlags);
        if (ParameterFlags.isOut(inout)) {
            session.addPostInvoke(new InvocationSession.PostInvoke(pointers, raw){
                private /* synthetic */ Pointer[] val$pointers;
                private /* synthetic */ long[] val$raw;
                {
                    this.val$pointers = pointerArray;
                    this.val$raw = lArray;
                }

                public final void postInvoke() {
                    for (int i = 0; i < this.val$pointers.length; ++i) {
                        this.val$pointers[i] = MemoryUtil.newPointer(this.val$raw[i]);
                    }
                }
            });
        }
    }

    public static final UnsatisfiedLinkError newUnsatisifiedLinkError(String msg) {
        return new UnsatisfiedLinkError(msg);
    }

    public static final HeapInvocationBuffer newHeapInvocationBuffer(Function function) {
        return new HeapInvocationBuffer(function);
    }

    public static HeapInvocationBuffer newHeapInvocationBuffer(CallContext callContext) {
        return new HeapInvocationBuffer(callContext);
    }

    public static HeapInvocationBuffer newHeapInvocationBuffer(CallContext callContext, int objCount) {
        return new HeapInvocationBuffer(callContext, objCount);
    }

    public static final String stringValue(long ptr) {
        if (ptr == 0L) {
            return null;
        }
        return Charset.defaultCharset().decode(ByteBuffer.wrap(MemoryIO.getZeroTerminatedByteArray(ptr))).toString();
    }

    public static final String stringValue(int ptr) {
        return AsmRuntime.stringValue((long)ptr);
    }

    public static final Pointer pointerValue(long ptr) {
        if (ptr != 0L) {
            return new DirectMemoryIO(ptr);
        }
        return null;
    }

    public static final Pointer pointerValue(int ptr) {
        if (ptr != 0) {
            return new DirectMemoryIO(ptr);
        }
        return null;
    }

    public static final void useMemory(long ptr, Struct s) {
        s.useMemory(ptr != 0L ? new DirectMemoryIO(ptr) : MemoryUtil.NULL);
    }

    public static final void useMemory(int ptr, Struct s) {
        s.useMemory(ptr != 0 ? new DirectMemoryIO(ptr) : MemoryUtil.NULL);
    }

    public static final boolean isDirect(Pointer ptr) {
        return ptr == null || ptr.isDirect();
    }

    public static final int intValue(Pointer ptr) {
        if (ptr != null) {
            return (int)ptr.address();
        }
        return 0;
    }

    public static final long longValue(Pointer ptr) {
        if (ptr != null) {
            return ptr.address();
        }
        return 0L;
    }

    public static final boolean isDirect5(Buffer buffer) {
        if (buffer == null) {
            return true;
        }
        if (buffer instanceof ByteBuffer) {
            return ((ByteBuffer)buffer).isDirect();
        }
        if (buffer instanceof ShortBuffer) {
            return ((ShortBuffer)buffer).isDirect();
        }
        if (buffer instanceof CharBuffer) {
            return ((CharBuffer)buffer).isDirect();
        }
        if (buffer instanceof IntBuffer) {
            return ((IntBuffer)buffer).isDirect();
        }
        if (buffer instanceof LongBuffer) {
            return ((LongBuffer)buffer).isDirect();
        }
        if (buffer instanceof FloatBuffer) {
            return ((FloatBuffer)buffer).isDirect();
        }
        if (buffer instanceof DoubleBuffer) {
            return ((DoubleBuffer)buffer).isDirect();
        }
        throw new UnsupportedOperationException("unsupported java.nio.Buffer subclass " + buffer.getClass());
    }

    public static final boolean isDirect(Buffer buffer) {
        return buffer == null || buffer.isDirect();
    }

    public static final boolean isDirect(ByteBuffer buffer) {
        return buffer == null || buffer.isDirect();
    }

    public static final boolean isDirect(CharBuffer buffer) {
        return buffer == null || buffer.isDirect();
    }

    public static final boolean isDirect(ShortBuffer buffer) {
        return buffer == null || buffer.isDirect();
    }

    public static final boolean isDirect(IntBuffer buffer) {
        return buffer == null || buffer.isDirect();
    }

    public static final boolean isDirect(LongBuffer buffer) {
        return buffer == null || buffer.isDirect();
    }

    public static final boolean isDirect(FloatBuffer buffer) {
        return buffer == null || buffer.isDirect();
    }

    public static final boolean isDirect(DoubleBuffer buffer) {
        return buffer == null || buffer.isDirect();
    }

    public static long longValue(Buffer buffer) {
        if (buffer == null) {
            return 0L;
        }
        long address = MemoryIO.getInstance().getDirectBufferAddress(buffer);
        long pos = buffer.position();
        if (!(buffer instanceof ByteBuffer)) {
            if (buffer instanceof ShortBuffer || buffer instanceof CharBuffer) {
                pos <<= 1;
            } else if (buffer instanceof IntBuffer || buffer instanceof FloatBuffer) {
                pos <<= 2;
            } else if (buffer instanceof LongBuffer || buffer instanceof DoubleBuffer) {
                pos <<= 3;
            } else {
                throw new UnsupportedOperationException("unsupported java.nio.Buffer subclass " + buffer.getClass());
            }
        }
        return address + pos;
    }

    public static final long longValue(ByteBuffer buffer) {
        if (buffer != null) {
            return MemoryIO.getInstance().getDirectBufferAddress(buffer) + (long)buffer.position();
        }
        return 0L;
    }

    public static final long longValue(ShortBuffer buffer) {
        if (buffer != null) {
            return MemoryIO.getInstance().getDirectBufferAddress(buffer) + (long)(buffer.position() << 1);
        }
        return 0L;
    }

    public static final long longValue(CharBuffer buffer) {
        if (buffer != null) {
            return MemoryIO.getInstance().getDirectBufferAddress(buffer) + (long)(buffer.position() << 1);
        }
        return 0L;
    }

    public static final long longValue(IntBuffer buffer) {
        if (buffer != null) {
            return MemoryIO.getInstance().getDirectBufferAddress(buffer) + (long)(buffer.position() << 2);
        }
        return 0L;
    }

    public static final long longValue(LongBuffer buffer) {
        if (buffer != null) {
            return MemoryIO.getInstance().getDirectBufferAddress(buffer) + (long)(buffer.position() << 3);
        }
        return 0L;
    }

    public static final long longValue(FloatBuffer buffer) {
        if (buffer != null) {
            return MemoryIO.getInstance().getDirectBufferAddress(buffer) + (long)(buffer.position() << 2);
        }
        return 0L;
    }

    public static final long longValue(DoubleBuffer buffer) {
        if (buffer != null) {
            return MemoryIO.getInstance().getDirectBufferAddress(buffer) + (long)(buffer.position() << 3);
        }
        return 0L;
    }

    public static final boolean isDirect(Struct s) {
        return s == null || Struct.isDirect(s);
    }

    public static final boolean isDirect(Struct s, int flags) {
        return s == null || Struct.getMemory(s, flags).isDirect();
    }

    public static final int intValue(Struct s) {
        if (s != null) {
            return (int)Struct.getMemory(s).address();
        }
        return 0;
    }

    public static final long longValue(Struct s) {
        if (s != null) {
            return Struct.getMemory(s).address();
        }
        return 0L;
    }

    public static PointerParameterStrategy pointerParameterStrategy(Pointer pointer) {
        if (pointer instanceof DirectMemoryIO) {
            return DirectMemoryParameterStrategy.INSTANCE;
        }
        return AsmRuntime.otherPointerParameterStrategy(pointer);
    }

    private static PointerParameterStrategy otherPointerParameterStrategy(Pointer pointer) {
        if (pointer == null) {
            return NullPointerParameterStrategy.INSTANCE;
        }
        if (pointer.isDirect()) {
            if (pointer instanceof AbstractBufferMemoryIO) {
                return DirectBufferMemoryParameterStrategy.INSTANCE;
            }
            return DirectPointerParameterStrategy.INSTANCE;
        }
        if (pointer.hasArray()) {
            return ArrayMemoryParameterStrategy.INSTANCE;
        }
        throw new RuntimeException("cannot convert " + pointer.getClass() + " to native");
    }

    public static PointerParameterStrategy pointerParameterStrategy(CharSequence s) {
        if (s == null) {
            return NullPointerParameterStrategy.INSTANCE;
        }
        return new StringParameterStrategy(s);
    }

    public static PointerParameterStrategy structParameterStrategy(Struct s) {
        if (s == null) {
            return NullPointerParameterStrategy.INSTANCE;
        }
        if (Struct.isDirect(s)) {
            return DirectStructParameterStrategy.INSTANCE;
        }
        return HeapStructParameterStrategy.INSTANCE;
    }

    public static PointerParameterStrategy directStructParameterStrategy(Struct s) {
        if (s == null) {
            return NullPointerParameterStrategy.INSTANCE;
        }
        return DirectStructParameterStrategy.INSTANCE;
    }

    public static PointerParameterStrategy bufferParameterStrategy(Buffer buffer, ObjectParameterType.ComponentType componentType) {
        if (buffer == null) {
            return NullPointerParameterStrategy.INSTANCE;
        }
        if (buffer.isDirect()) {
            return DirectBufferParameterStrategy.get(componentType);
        }
        if (buffer.hasArray()) {
            return HeapBufferParameterStrategy.get(componentType);
        }
        throw new IllegalArgumentException("cannot marshal non-direct, non-array Buffer");
    }

    public static PointerParameterStrategy pointerParameterStrategy(Buffer buffer) {
        if (buffer instanceof ByteBuffer) {
            return AsmRuntime.bufferParameterStrategy(buffer, ObjectParameterType.BYTE);
        }
        if (buffer instanceof ShortBuffer) {
            return AsmRuntime.bufferParameterStrategy(buffer, ObjectParameterType.SHORT);
        }
        if (buffer instanceof CharBuffer) {
            return AsmRuntime.bufferParameterStrategy(buffer, ObjectParameterType.CHAR);
        }
        if (buffer instanceof IntBuffer) {
            return AsmRuntime.bufferParameterStrategy(buffer, ObjectParameterType.INT);
        }
        if (buffer instanceof LongBuffer) {
            return AsmRuntime.bufferParameterStrategy(buffer, ObjectParameterType.LONG);
        }
        if (buffer instanceof FloatBuffer) {
            return AsmRuntime.bufferParameterStrategy(buffer, ObjectParameterType.FLOAT);
        }
        if (buffer instanceof DoubleBuffer) {
            return AsmRuntime.bufferParameterStrategy(buffer, ObjectParameterType.DOUBLE);
        }
        if (buffer == null) {
            return NullPointerParameterStrategy.INSTANCE;
        }
        throw new IllegalArgumentException("unsupported java.nio.Buffer subclass: " + buffer.getClass());
    }

    public static PointerParameterStrategy pointerParameterStrategy(ByteBuffer buffer) {
        return AsmRuntime.bufferParameterStrategy(buffer, ObjectParameterType.BYTE);
    }

    public static PointerParameterStrategy pointerParameterStrategy(ShortBuffer buffer) {
        return AsmRuntime.bufferParameterStrategy(buffer, ObjectParameterType.SHORT);
    }

    public static PointerParameterStrategy pointerParameterStrategy(CharBuffer buffer) {
        return AsmRuntime.bufferParameterStrategy(buffer, ObjectParameterType.CHAR);
    }

    public static PointerParameterStrategy pointerParameterStrategy(IntBuffer buffer) {
        return AsmRuntime.bufferParameterStrategy(buffer, ObjectParameterType.INT);
    }

    public static PointerParameterStrategy pointerParameterStrategy(LongBuffer buffer) {
        return AsmRuntime.bufferParameterStrategy(buffer, ObjectParameterType.LONG);
    }

    public static PointerParameterStrategy pointerParameterStrategy(FloatBuffer buffer) {
        return AsmRuntime.bufferParameterStrategy(buffer, ObjectParameterType.FLOAT);
    }

    public static PointerParameterStrategy pointerParameterStrategy(DoubleBuffer buffer) {
        return AsmRuntime.bufferParameterStrategy(buffer, ObjectParameterType.DOUBLE);
    }

    public static PointerParameterStrategy pointerParameterStrategy(byte[] array) {
        if (array != null) {
            return PrimitiveArrayParameterStrategy.BYTE;
        }
        return NullPointerParameterStrategy.INSTANCE;
    }

    public static PointerParameterStrategy pointerParameterStrategy(short[] array) {
        if (array != null) {
            return PrimitiveArrayParameterStrategy.SHORT;
        }
        return NullPointerParameterStrategy.INSTANCE;
    }

    public static PointerParameterStrategy pointerParameterStrategy(char[] array) {
        if (array != null) {
            return PrimitiveArrayParameterStrategy.CHAR;
        }
        return NullPointerParameterStrategy.INSTANCE;
    }

    public static PointerParameterStrategy pointerParameterStrategy(int[] array) {
        if (array != null) {
            return PrimitiveArrayParameterStrategy.INT;
        }
        return NullPointerParameterStrategy.INSTANCE;
    }

    public static PointerParameterStrategy pointerParameterStrategy(long[] array) {
        if (array != null) {
            return PrimitiveArrayParameterStrategy.LONG;
        }
        return NullPointerParameterStrategy.INSTANCE;
    }

    public static PointerParameterStrategy pointerParameterStrategy(float[] array) {
        if (array != null) {
            return PrimitiveArrayParameterStrategy.FLOAT;
        }
        return NullPointerParameterStrategy.INSTANCE;
    }

    public static PointerParameterStrategy pointerParameterStrategy(double[] array) {
        if (array != null) {
            return PrimitiveArrayParameterStrategy.DOUBLE;
        }
        return NullPointerParameterStrategy.INSTANCE;
    }

    public static PointerParameterStrategy pointerParameterStrategy(boolean[] array) {
        if (array != null) {
            return PrimitiveArrayParameterStrategy.BOOLEAN;
        }
        return NullPointerParameterStrategy.INSTANCE;
    }

    public static void checkAllStrategiesAreHeap(ObjectParameterStrategy s1) {
        if (s1.isDirect()) {
            throw new RuntimeException("pointer 1 is direct");
        }
    }

    public static void checkAllStrategiesAreHeap(ObjectParameterStrategy s1, ObjectParameterStrategy s2) {
        if (s1.isDirect()) {
            throw new RuntimeException("pointer 1 is direct");
        }
        if (s2.isDirect()) {
            throw new RuntimeException("pointer 2 is direct");
        }
    }

    public static void checkAllStrategiesAreHeap(ObjectParameterStrategy s1, ObjectParameterStrategy s2, ObjectParameterStrategy s3) {
        if (s1.isDirect()) {
            throw new RuntimeException("pointer 1 is direct");
        }
        if (s2.isDirect()) {
            throw new RuntimeException("pointer 2 is direct");
        }
        if (s3.isDirect()) {
            throw new RuntimeException("pointer 3 is direct");
        }
    }
}

