/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;
import com.kenai.jffi.NativeType;

public abstract class Type {
    public static final Type VOID = Type.builtin(NativeType.VOID);
    public static final Type FLOAT = Type.builtin(NativeType.FLOAT);
    public static final Type DOUBLE = Type.builtin(NativeType.DOUBLE);
    public static final Type LONGDOUBLE = Type.builtin(NativeType.LONGDOUBLE);
    public static final Type UINT8 = Type.builtin(NativeType.UINT8);
    public static final Type SINT8 = Type.builtin(NativeType.SINT8);
    public static final Type UINT16 = Type.builtin(NativeType.UINT16);
    public static final Type SINT16 = Type.builtin(NativeType.SINT16);
    public static final Type UINT32 = Type.builtin(NativeType.UINT32);
    public static final Type SINT32 = Type.builtin(NativeType.SINT32);
    public static final Type UINT64 = Type.builtin(NativeType.UINT64);
    public static final Type SINT64 = Type.builtin(NativeType.SINT64);
    public static final Type POINTER = Type.builtin(NativeType.POINTER);
    public static final Type UCHAR = UINT8;
    public static final Type SCHAR = SINT8;
    public static final Type USHORT = UINT16;
    public static final Type SSHORT = SINT16;
    public static final Type UINT = UINT32;
    public static final Type SINT = SINT32;
    public static final Type ULONG = Type.builtin(NativeType.ULONG);
    public static final Type SLONG = Type.builtin(NativeType.SLONG);
    public static final Type ULONG_LONG = UINT64;
    public static final Type SLONG_LONG = SINT64;

    abstract long handle();

    public abstract int size();

    public abstract int alignment();

    public boolean equals(Object obj) {
        return obj instanceof Type && ((Type)obj).handle() == this.handle();
    }

    public int hashCode() {
        int hash = 201 + (int)(this.handle() ^ this.handle() >>> 32);
        return hash;
    }

    static final long[] nativeHandles(Type[] types) {
        long[] nativeTypes = new long[types.length];
        for (int i = 0; i < types.length; ++i) {
            nativeTypes[i] = types[i].handle();
        }
        return nativeTypes;
    }

    private static final Type builtin(NativeType nativeType) {
        return new Builtin(nativeType, 0);
    }

    static final class BuiltinTypeInfo {
        private static final LookupTable lookupTable;
        final int size;
        final int alignment;
        final long handle;

        static BuiltinTypeInfo find(NativeType t) {
            return lookupTable.find(t);
        }

        private BuiltinTypeInfo(long handle, int type, int size, int alignment) {
            this.handle = handle;
            this.size = size;
            this.alignment = alignment;
        }

        /* synthetic */ BuiltinTypeInfo(long x0, int x1, int x2, int x3, byte by) {
            this(x0, x1, x2, x3);
        }

        static {
            LookupTable table;
            try {
                table = new NativeLookupTable(Foreign.getInstance());
            }
            catch (Throwable error) {
                table = new InvalidLookupTable(error, 0);
            }
            lookupTable = table;
        }
    }

    static final class InvalidLookupTable
    extends LookupTable {
        private Throwable error;

        private InvalidLookupTable(Throwable error) {
            super((byte)0);
            this.error = error;
        }

        public final BuiltinTypeInfo find(NativeType nativeType) {
            UnsatisfiedLinkError error = new UnsatisfiedLinkError("could not get native definition for type: " + (Object)((Object)nativeType));
            error.initCause(this.error);
            throw error;
        }

        /* synthetic */ InvalidLookupTable(Throwable x0, byte by) {
            this(x0);
        }
    }

    static final class NativeLookupTable
    extends LookupTable {
        private BuiltinTypeInfo[] typeMap;

        NativeLookupTable(Foreign foreign) {
            super((byte)0);
            NativeType[] nativeTypes = NativeType.values();
            this.typeMap = new BuiltinTypeInfo[nativeTypes.length];
            for (int i = 0; i < this.typeMap.length; ++i) {
                int alignment;
                int size;
                int type;
                long h = foreign.lookupBuiltinType(nativeTypes[i].ffiType);
                if (h != 0L) {
                    type = foreign.getTypeType(h);
                    size = foreign.getTypeSize(h);
                    alignment = foreign.getTypeAlign(h);
                } else {
                    type = nativeTypes[i].ffiType;
                    size = 0;
                    alignment = 0;
                }
                this.typeMap[i] = new BuiltinTypeInfo(h, type, size, alignment, 0);
            }
        }

        public final BuiltinTypeInfo find(NativeType nativeType) {
            return this.typeMap[nativeType.ordinal()];
        }
    }

    static abstract class LookupTable {
        private LookupTable() {
        }

        public abstract BuiltinTypeInfo find(NativeType var1);

        /* synthetic */ LookupTable(byte by) {
            this();
        }
    }

    static final class Builtin
    extends Type {
        private final NativeType nativeType;

        private Builtin(NativeType nativeType) {
            this.nativeType = nativeType;
        }

        public final long handle() {
            long handle = BuiltinTypeInfo.find((NativeType)this.nativeType).handle;
            if (handle != 0L) {
                return handle;
            }
            throw new RuntimeException("invalid handle for native type " + (Object)((Object)this.nativeType));
        }

        public final int size() {
            return BuiltinTypeInfo.find((NativeType)this.nativeType).size;
        }

        public final int alignment() {
            return BuiltinTypeInfo.find((NativeType)this.nativeType).alignment;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Builtin builtin = (Builtin)o;
            return this.nativeType == builtin.nativeType;
        }

        public final int hashCode() {
            int result = super.hashCode();
            result = result * 31 + this.nativeType.hashCode();
            return result;
        }

        /* synthetic */ Builtin(NativeType x0, byte by) {
            this(x0);
        }
    }
}

