/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Library {
    private static final Map<String, WeakReference<Library>> cache = new ConcurrentHashMap<String, WeakReference<Library>>();
    private static final ThreadLocal<String> lastError;
    private final long handle;
    private final Foreign foreign;

    private static long dlopen(Foreign foreign, String name, int flags) {
        try {
            return Foreign.dlopen(name, flags);
        }
        catch (UnsatisfiedLinkError ex) {
            lastError.set(ex.getMessage());
            return 0L;
        }
    }

    public static final Library getCachedInstance(String name, int flags) {
        if (name == null) {
            return DefaultLibrary.INSTANCE;
        }
        WeakReference<Library> ref = cache.get(name);
        Library lib = ref != null ? (Library)ref.get() : null;
        if (lib != null) {
            return lib;
        }
        lib = Library.openLibrary(name, flags);
        if (lib == null) {
            return null;
        }
        cache.put(name, new WeakReference<Library>(lib));
        return lib;
    }

    public static final Library openLibrary(String name, int flags) {
        Foreign foreign;
        long address;
        if (flags == 0) {
            flags = 5;
        }
        if ((address = Library.dlopen(foreign = Foreign.getInstance(), name, flags)) != 0L) {
            return new Library(foreign, name, address);
        }
        return null;
    }

    private Library(Foreign foreign, String name, long address) {
        this.foreign = foreign;
        this.handle = address;
    }

    public final long getSymbolAddress(String name) {
        try {
            return Foreign.dlsym(this.handle, name);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Library library = this;
            lastError.set(library.foreign.dlerror());
            return 0L;
        }
    }

    public static final String getLastError() {
        String error = lastError.get();
        if (error != null) {
            return error;
        }
        return "unknown";
    }

    protected final void finalize() throws Throwable {
        try {
            if (this.handle != 0L) {
                Foreign.dlclose(this.handle);
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    static {
        new Object();
        lastError = new ThreadLocal();
    }

    static final class DefaultLibrary {
        private static final Library INSTANCE = Library.openLibrary(null, 9);
    }
}

