/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.process;

import net.grinder.common.Test;
import net.grinder.engine.process.DispatchContext;
import net.grinder.engine.process.TestStatisticsHelper;
import net.grinder.script.InvalidContextException;
import net.grinder.script.NoSuchStatisticException;
import net.grinder.script.Statistics;
import net.grinder.statistics.ImmutableStatisticsSet;
import net.grinder.statistics.StatisticsIndexMap;
import net.grinder.statistics.StatisticsSet;

final class StatisticsForTestImplementation
implements Statistics.StatisticsForTest {
    private final TestStatisticsHelper m_testStatisticsHelper;
    private final Test m_test;
    private final ImmutableStatisticsSet m_immutableStatistics;
    private DispatchContext m_dispatchContext;
    private StatisticsSet m_statistics;

    public StatisticsForTestImplementation(DispatchContext dispatchContext, TestStatisticsHelper testStatisticsHelper, StatisticsSet statistics) {
        this.m_testStatisticsHelper = testStatisticsHelper;
        this.m_test = dispatchContext.getTest();
        this.m_dispatchContext = dispatchContext;
        this.m_statistics = statistics;
        this.m_immutableStatistics = this.m_statistics;
    }

    public void freeze() {
        this.m_dispatchContext = null;
        this.m_statistics = null;
    }

    private StatisticsSet getStatisticsChecked() throws InvalidContextException {
        if (this.m_statistics == null) {
            throw new InvalidContextException("Statistics for test invocation have been reported and cannot be updated. Perhaps you should have called setDelayReports(true)?");
        }
        return this.m_statistics;
    }

    public StatisticsSet getStatistics() {
        return this.m_statistics;
    }

    private ImmutableStatisticsSet getImmutableStatistics() {
        return this.m_immutableStatistics;
    }

    public Test getTest() {
        return this.m_test;
    }

    public void setLong(String statisticName, long value) throws InvalidContextException, NoSuchStatisticException {
        this.getStatisticsChecked().setValue(this.getLongIndex(statisticName), value);
    }

    public void setDouble(String statisticName, double value) throws InvalidContextException, NoSuchStatisticException {
        this.getStatisticsChecked().setValue(this.getDoubleIndex(statisticName), value);
    }

    public void addLong(String statisticName, long value) throws InvalidContextException, NoSuchStatisticException {
        this.getStatisticsChecked().addValue(this.getLongIndex(statisticName), value);
    }

    public void addDouble(String statisticName, double value) throws InvalidContextException, NoSuchStatisticException {
        this.getStatisticsChecked().addValue(this.getDoubleIndex(statisticName), value);
    }

    public long getLong(String statisticName) throws NoSuchStatisticException {
        return this.getImmutableStatistics().getValue(this.getLongIndex(statisticName));
    }

    public double getDouble(String statisticName) throws NoSuchStatisticException {
        return this.getImmutableStatistics().getValue(this.getDoubleIndex(statisticName));
    }

    public void setSuccess(boolean success) throws InvalidContextException {
        this.m_testStatisticsHelper.setSuccess(this.getStatisticsChecked(), success);
    }

    public boolean getSuccess() {
        return this.m_testStatisticsHelper.getSuccess(this.getImmutableStatistics());
    }

    public long getTime() {
        if (this.m_dispatchContext != null) {
            return this.m_dispatchContext.getElapsedTime();
        }
        return this.m_testStatisticsHelper.getTestTime(this.getImmutableStatistics());
    }

    private StatisticsIndexMap.DoubleIndex getDoubleIndex(String statisticName) throws NoSuchStatisticException {
        StatisticsIndexMap.DoubleIndex index = this.m_testStatisticsHelper.getStatisticsIndexMap().getDoubleIndex(statisticName);
        if (index == null) {
            throw new NoSuchStatisticException("'" + statisticName + "' is not a basic double statistic.");
        }
        return index;
    }

    private StatisticsIndexMap.LongIndex getLongIndex(String statisticName) throws NoSuchStatisticException {
        StatisticsIndexMap.LongIndex index = this.m_testStatisticsHelper.getStatisticsIndexMap().getLongIndex(statisticName);
        if (index == null) {
            throw new NoSuchStatisticException("'" + statisticName + "' is not a basic long statistic.");
        }
        return index;
    }
}

