/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.agent;

import java.io.OutputStream;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import net.grinder.common.GrinderProperties;
import net.grinder.communication.FanOutStreamSender;
import net.grinder.engine.agent.AbstractWorkerFactory;
import net.grinder.engine.agent.AgentIdentityImplementation;
import net.grinder.engine.agent.DebugThreadWorker;
import net.grinder.engine.agent.IsolatedGrinderProcessRunner;
import net.grinder.engine.agent.Worker;
import net.grinder.engine.common.EngineException;
import net.grinder.engine.common.ScriptLocation;
import net.grinder.util.IsolatingClassLoader;

final class DebugThreadWorkerFactory
extends AbstractWorkerFactory {
    private static Class s_isolatedRunnerClass = IsolatedGrinderProcessRunner.class;
    private String[] m_sharedClassArray;

    static void setIsolatedRunnerClass(Class isolatedRunnerClass) {
        s_isolatedRunnerClass = isolatedRunnerClass != null ? isolatedRunnerClass : IsolatedGrinderProcessRunner.class;
    }

    public DebugThreadWorkerFactory(AgentIdentityImplementation agentIdentity, FanOutStreamSender fanOutStreamSender, boolean reportToConsole, ScriptLocation script, GrinderProperties properties) throws EngineException {
        super(agentIdentity, fanOutStreamSender, reportToConsole, script, properties);
        ArrayList<String> sharedClasses = new ArrayList<String>();
        sharedClasses.add(DebugThreadWorker.IsolateGrinderProcessRunner.class.getName());
        sharedClasses.addAll(Arrays.asList(properties.getProperty("grinder.debug.singleprocess.sharedclasses", "").split(",")));
        this.m_sharedClassArray = sharedClasses.toArray(new String[sharedClasses.size()]);
    }

    protected Worker createWorker(AgentIdentityImplementation.WorkerIdentityImplementation workerIdentity, OutputStream outputStream, OutputStream errorStream) throws EngineException {
        DebugThreadWorker.IsolateGrinderProcessRunner runner;
        Class<?> isolatedRunnerClass;
        IsolatingClassLoader classLoader = new IsolatingClassLoader((URLClassLoader)this.getClass().getClassLoader(), this.m_sharedClassArray, true);
        try {
            isolatedRunnerClass = Class.forName(s_isolatedRunnerClass.getName(), true, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        try {
            runner = (DebugThreadWorker.IsolateGrinderProcessRunner)isolatedRunnerClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new EngineException("Failed to create IsolateGrinderProcessRunner", e);
        }
        catch (IllegalAccessException e) {
            throw new EngineException("Failed to create IsolateGrinderProcessRunner", e);
        }
        return new DebugThreadWorker(workerIdentity, runner);
    }
}

