/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.swingui;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import javax.swing.JFrame;
import net.grinder.console.common.ConsoleException;
import net.grinder.console.model.ConsoleProperties;

final class FrameBounds {
    private final ConsoleProperties m_properties;
    private final JFrame m_frame;

    public FrameBounds(ConsoleProperties properties, JFrame frame) {
        this.m_properties = properties;
        this.m_frame = frame;
    }

    public void restore() {
        boolean setDefaultLocation;
        GraphicsEnvironment graphicsEnvironment;
        block5: {
            this.m_frame.pack();
            Rectangle savedBounds = this.m_properties.getFrameBounds();
            graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            setDefaultLocation = true;
            if (savedBounds != null) {
                this.m_frame.setBounds(savedBounds.x, savedBounds.y, Math.max(savedBounds.width, 300), Math.max(savedBounds.height, 200));
                GraphicsDevice[] devices = graphicsEnvironment.getScreenDevices();
                for (int i = 0; i < devices.length; ++i) {
                    GraphicsConfiguration[] configurations = devices[i].getConfigurations();
                    for (int j = 0; j < configurations.length; ++j) {
                        if (!savedBounds.intersects(this.shrinkRectangle(configurations[j].getBounds(), 50))) continue;
                        setDefaultLocation = false;
                        break block5;
                    }
                }
            } else {
                this.m_frame.setSize(900, 600);
            }
        }
        Rectangle defaultScreen = graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        if (setDefaultLocation) {
            this.m_frame.setLocation(defaultScreen.x + defaultScreen.width / 2 - this.m_frame.getSize().width / 2, defaultScreen.y + defaultScreen.height / 2 - this.m_frame.getSize().height / 2);
        }
    }

    private Rectangle shrinkRectangle(Rectangle bounds, int amount) {
        return new Rectangle(bounds.x + amount, bounds.y + amount, bounds.width - 2 * amount, bounds.height - 2 * amount);
    }

    public void store() throws ConsoleException {
        this.m_properties.setAndSaveFrameBounds(this.m_frame.getBounds());
    }
}

