/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.swingui;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import net.grinder.console.distribution.FileChangeWatcher;
import net.grinder.console.editor.Buffer;
import net.grinder.console.editor.EditorModel;
import net.grinder.console.swingui.FileTree;
import net.grinder.util.WeakValueHashMap;

final class FileTreeModel
implements TreeModel {
    private final EventListenerList m_listeners = new EventListenerList();
    private final EditorModel m_editorModel;
    private final FileFilter m_distributionFileFilter;
    private final FilenameFilter m_directoryFilter = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            File file = new File(dir, name);
            return file.isDirectory() && FileTreeModel.this.m_distributionFileFilter.accept(file);
        }
    };
    private final FilenameFilter m_fileFilter = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            File file = new File(dir, name);
            return file.isFile() && FileTreeModel.this.m_distributionFileFilter.accept(file);
        }
    };
    private final WeakValueHashMap m_filesToNodes = new WeakValueHashMap();
    private final WeakValueHashMap m_buffersToFileNodes = new WeakValueHashMap();
    private RootNode m_rootNode;

    FileTreeModel(EditorModel editorModel, FileFilter distributionFileFilter) {
        this.m_editorModel = editorModel;
        this.m_distributionFileFilter = distributionFileFilter;
    }

    public void setRootDirectory(File rootDirectory) {
        this.m_rootNode = new RootNode(rootDirectory);
        this.fireTreeStructureChanged(this.m_rootNode);
    }

    public void refresh() {
        this.m_rootNode.refresh();
        this.fireTreeStructureChanged(this.m_rootNode);
    }

    public Object getRoot() {
        return this.m_rootNode;
    }

    public Object getChild(Object parent, int index) {
        DirectoryNode directoryNode;
        if (parent instanceof DirectoryNode && (directoryNode = (DirectoryNode)parent).belongsToModel(this)) {
            return directoryNode.getChild(index);
        }
        return null;
    }

    public int getChildCount(Object parent) {
        DirectoryNode directoryNode;
        if (parent instanceof DirectoryNode && (directoryNode = (DirectoryNode)parent).belongsToModel(this)) {
            return directoryNode.getChildCount();
        }
        return 0;
    }

    public int getIndexOfChild(Object parent, Object child) {
        DirectoryNode directoryNode;
        if (parent == null || child == null) {
            return -1;
        }
        if (parent instanceof DirectoryNode && (directoryNode = (DirectoryNode)parent).belongsToModel(this)) {
            return directoryNode.getIndexOfChild((Node)child);
        }
        return -1;
    }

    public boolean isLeaf(Object node) {
        FileNode fileNode;
        return node instanceof FileNode && (fileNode = (FileNode)node).belongsToModel(this);
    }

    public void addTreeModelListener(TreeModelListener listener) {
        this.m_listeners.add(TreeModelListener.class, listener);
    }

    public void removeTreeModelListener(TreeModelListener listener) {
        this.m_listeners.remove(TreeModelListener.class, listener);
    }

    private void fireTreeStructureChanged(Node node) {
        Object[] listeners = this.m_listeners.getListenerList();
        TreeModelEvent event = new TreeModelEvent((Object)this, node.getPath());
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(event);
        }
    }

    private void fireTreeNodesChanged(TreePath path) {
        Object[] listeners = this.m_listeners.getListenerList();
        TreeModelEvent event = new TreeModelEvent((Object)this, path);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            ((TreeModelListener)listeners[i + 1]).treeNodesChanged(event);
        }
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        this.fireTreeNodesChanged(path);
    }

    public Node findNode(File file) {
        Node existingNode = (Node)this.m_filesToNodes.get(file);
        if (existingNode != null) {
            return existingNode;
        }
        File[] paths = this.fileToArrayOfParentPaths(file);
        DirectoryNode treeStructureChangedNode = null;
        for (int i = 0; i < paths.length - 1; ++i) {
            DirectoryNode directoryNode;
            Node node = (Node)this.m_filesToNodes.get(paths[i]);
            if (!(node instanceof DirectoryNode) || (directoryNode = (DirectoryNode)node).getChildForFile(paths[i + 1]) != null) continue;
            directoryNode.refresh();
            treeStructureChangedNode = directoryNode;
            if (directoryNode.getChildForFile(paths[i + 1]) != null) continue;
            return null;
        }
        if (treeStructureChangedNode != null) {
            this.fireTreeStructureChanged(treeStructureChangedNode);
        }
        return (Node)this.m_filesToNodes.get(file);
    }

    private File[] fileToArrayOfParentPaths(File file) {
        ArrayList<File> list = new ArrayList<File>();
        for (File f = file; f != null; f = f.getParentFile()) {
            list.add(f);
        }
        Collections.reverse(list);
        return list.toArray(new File[list.size()]);
    }

    public FileNode findFileNode(Buffer buffer) {
        return (FileNode)this.m_buffersToFileNodes.get(buffer);
    }

    private final class RootNode
    extends DirectoryNode {
        private RootNode(File file) {
            super(null, file);
        }

        public String toString() {
            return this.getFile().getPath();
        }
    }

    private class DirectoryNode
    extends Node {
        private final File[] m_noFiles;
        private File[] m_childDirectories;
        private DirectoryNode[] m_childDirectoryNodes;
        private File[] m_childFiles;
        private FileNode[] m_childFileNodes;

        DirectoryNode(DirectoryNode parentNode, File file) {
            super(parentNode, file);
            this.m_noFiles = new File[0];
            this.m_childDirectories = this.m_noFiles;
            this.m_childFiles = this.m_noFiles;
            this.refresh();
        }

        public void refresh() {
            int i;
            for (i = 0; i < this.m_childDirectories.length; ++i) {
                DirectoryNode oldDirectoryNode = (DirectoryNode)FileTreeModel.this.m_filesToNodes.remove(this.m_childDirectories[i]);
                if (oldDirectoryNode == null) continue;
                oldDirectoryNode.refresh();
            }
            for (i = 0; i < this.m_childFiles.length; ++i) {
                FileNode oldFileNode = (FileNode)FileTreeModel.this.m_filesToNodes.remove(this.m_childFiles[i]);
                if (oldFileNode == null) continue;
                oldFileNode.setBuffer(null);
            }
            Object[] directories = this.getFile().listFiles(FileTreeModel.this.m_directoryFilter);
            if (directories != null) {
                Arrays.sort(directories);
                this.m_childDirectories = directories;
            } else {
                this.m_childDirectories = this.m_noFiles;
            }
            this.m_childDirectoryNodes = new DirectoryNode[this.m_childDirectories.length];
            Object[] files = this.getFile().listFiles(FileTreeModel.this.m_fileFilter);
            if (files != null) {
                Arrays.sort(files);
                this.m_childFiles = files;
            } else {
                this.m_childFiles = this.m_noFiles;
            }
            this.m_childFileNodes = new FileNode[this.m_childFiles.length];
        }

        final Node getChildForFile(File file) {
            if (file.isDirectory()) {
                for (int i = 0; i < this.m_childDirectories.length; ++i) {
                    if (!this.m_childDirectories[i].equals(file)) continue;
                    return this.getChild(i);
                }
            } else {
                for (int i = 0; i < this.m_childFiles.length; ++i) {
                    if (!this.m_childFiles[i].equals(file)) continue;
                    return this.getChild(i + this.m_childDirectories.length);
                }
            }
            return null;
        }

        public final Node getChild(int index) {
            if (index < this.m_childDirectories.length) {
                if (this.m_childDirectoryNodes[index] == null) {
                    this.m_childDirectoryNodes[index] = new DirectoryNode(this, this.m_childDirectories[index]);
                }
                return this.m_childDirectoryNodes[index];
            }
            if (index < this.m_childDirectories.length + this.m_childFiles.length) {
                int fileIndex = index - this.m_childDirectories.length;
                if (this.m_childFileNodes[fileIndex] == null) {
                    this.m_childFileNodes[fileIndex] = new FileNode(this, this.m_childFiles[fileIndex]);
                }
                return this.m_childFileNodes[fileIndex];
            }
            return null;
        }

        public final int getChildCount() {
            return this.m_childDirectories.length + this.m_childFiles.length;
        }

        public final int getIndexOfChild(Node child) {
            int i;
            for (i = 0; i < this.m_childDirectories.length; ++i) {
                if (!this.m_childDirectories[i].equals(child.getFile())) continue;
                return i;
            }
            for (i = 0; i < this.m_childFiles.length; ++i) {
                if (!this.m_childFiles[i].equals(child.getFile())) continue;
                return this.m_childDirectories.length + i;
            }
            return -1;
        }
    }

    public final class FileNode
    extends Node {
        private Buffer m_buffer;

        private FileNode(DirectoryNode parentNode, File file) {
            super(parentNode, file);
            this.setBuffer(FileTreeModel.this.m_editorModel.getBufferForFile(file));
        }

        public void setBuffer(Buffer buffer) {
            if (this.m_buffer != null) {
                FileTreeModel.this.m_buffersToFileNodes.remove(this.m_buffer);
            }
            this.m_buffer = buffer;
            if (buffer != null) {
                FileTreeModel.this.m_buffersToFileNodes.put(buffer, this);
            }
        }

        public Buffer getBuffer() {
            return this.m_buffer;
        }

        public boolean canOpen() {
            return true;
        }
    }

    public abstract class Node
    implements FileTree.Node {
        private final File m_file;
        private final TreePath m_path;

        protected Node(Node parentNode, File file) {
            this.m_file = file;
            this.m_path = parentNode != null ? parentNode.getPath().pathByAddingChild(this) : new TreePath(this);
            FileTreeModel.this.m_filesToNodes.put(file, this);
        }

        public String toString() {
            return this.m_file.getName();
        }

        public Buffer getBuffer() {
            return null;
        }

        public final File getFile() {
            return this.m_file;
        }

        public final TreePath getPath() {
            return this.m_path;
        }

        public boolean canOpen() {
            return false;
        }

        boolean belongsToModel(FileTreeModel model) {
            return FileTreeModel.this == model;
        }
    }

    public class RefreshChangedDirectoriesListener
    implements FileChangeWatcher.FileChangedListener {
        public void filesChanged(File[] files) {
            for (int i = 0; i < files.length; ++i) {
                Node node = FileTreeModel.this.findNode(files[i]);
                if (!(node instanceof DirectoryNode)) continue;
                ((DirectoryNode)node).refresh();
                FileTreeModel.this.fireTreeStructureChanged(node);
            }
        }
    }
}

