/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.common;

import java.util.LinkedList;
import net.grinder.console.common.ErrorHandler;

public final class ErrorQueue
implements ErrorHandler {
    private ErrorHandler m_delegate = null;
    private final LinkedList m_queue = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setErrorHandler(ErrorHandler errorHandler) {
        ErrorQueue errorQueue = this;
        synchronized (errorQueue) {
            this.m_delegate = errorHandler;
            if (this.m_delegate != null) {
                LinkedList linkedList = this.m_queue;
                synchronized (linkedList) {
                    while (this.m_queue.size() > 0) {
                        DelayedError delayedError = (DelayedError)this.m_queue.removeFirst();
                        delayedError.apply(this.m_delegate);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queue(DelayedError delayedError) {
        ErrorQueue errorQueue = this;
        synchronized (errorQueue) {
            if (this.m_delegate != null) {
                delayedError.apply(this.m_delegate);
            } else {
                LinkedList linkedList = this.m_queue;
                synchronized (linkedList) {
                    this.m_queue.add(delayedError);
                }
            }
        }
    }

    public void handleErrorMessage(final String errorMessage) {
        this.queue(new DelayedError(){

            public void apply(ErrorHandler errorHandler) {
                errorHandler.handleErrorMessage(errorMessage);
            }
        });
    }

    public void handleErrorMessage(final String errorMessage, final String title) {
        this.queue(new DelayedError(){

            public void apply(ErrorHandler errorHandler) {
                errorHandler.handleErrorMessage(errorMessage, title);
            }
        });
    }

    public void handleException(final Throwable throwable) {
        this.queue(new DelayedError(){

            public void apply(ErrorHandler errorHandler) {
                errorHandler.handleException(throwable);
            }
        });
    }

    public void handleException(final Throwable throwable, final String title) {
        this.queue(new DelayedError(){

            public void apply(ErrorHandler errorHandler) {
                errorHandler.handleException(throwable, title);
            }
        });
    }

    public void handleInformationMessage(final String informationMessage) {
        this.queue(new DelayedError(){

            public void apply(ErrorHandler errorHandler) {
                errorHandler.handleInformationMessage(informationMessage);
            }
        });
    }

    private static interface DelayedError {
        public void apply(ErrorHandler var1);
    }
}

