/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.plugin.http;

import HTTPClient.CookieModule;
import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.ParseException;
import HTTPClient.ProtocolNotSuppException;
import HTTPClient.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.grinder.common.SSLContextFactory;
import net.grinder.common.SkeletonThreadLifeCycleListener;
import net.grinder.plugin.http.HTTPConnectionWrapper;
import net.grinder.plugin.http.HTTPPluginConnectionDefaults;
import net.grinder.plugininterface.PluginException;
import net.grinder.plugininterface.PluginThreadContext;
import net.grinder.plugininterface.PluginThreadListener;
import net.grinder.util.Sleeper;
import net.grinder.util.TimeAuthority;

class HTTPPluginThreadState
extends SkeletonThreadLifeCycleListener
implements PluginThreadListener {
    private final PluginThreadContext m_threadContext;
    private final SSLContextFactory m_sslContextFactory;
    private final Map m_httpConnectionWrappers = new HashMap();
    private HTTPResponse m_lastResponse;
    private final Sleeper m_slowClientSleeper;
    private final TimeAuthorityAdapter m_timeAuthority;

    HTTPPluginThreadState(PluginThreadContext threadContext, SSLContextFactory sslContextFactory, Sleeper slowClientSleeper, TimeAuthority timeAuthority) throws PluginException {
        this.m_threadContext = threadContext;
        this.m_sslContextFactory = sslContextFactory;
        this.m_slowClientSleeper = slowClientSleeper;
        this.m_timeAuthority = new TimeAuthorityAdapter(timeAuthority);
    }

    public PluginThreadContext getThreadContext() {
        return this.m_threadContext;
    }

    public HTTPConnectionWrapper getConnectionWrapper(URI uri) throws ParseException, ProtocolNotSuppException, SSLContextFactory.SSLContextFactoryException {
        URI keyURI = new URI(uri.getScheme(), uri.getHost(), uri.getPort(), "");
        HTTPConnectionWrapper existingConnectionWrapper = (HTTPConnectionWrapper)this.m_httpConnectionWrappers.get(keyURI);
        if (existingConnectionWrapper != null) {
            return existingConnectionWrapper;
        }
        HTTPPluginConnectionDefaults connectionDefaults = HTTPPluginConnectionDefaults.getConnectionDefaults();
        HTTPConnection httpConnection = new HTTPConnection(uri);
        httpConnection.setContext(this);
        if ("https".equals(uri.getScheme())) {
            httpConnection.setSSLSocketFactory(this.m_sslContextFactory.getSSLContext().getSocketFactory());
        }
        httpConnection.setTimeAuthority(this.m_timeAuthority);
        HTTPConnectionWrapper newConnectionWrapper = new HTTPConnectionWrapper(httpConnection, connectionDefaults, this.m_slowClientSleeper);
        this.m_httpConnectionWrappers.put(keyURI, newConnectionWrapper);
        return newConnectionWrapper;
    }

    public void beginRun() {
        CookieModule.discardAllCookies(this);
        Iterator i = this.m_httpConnectionWrappers.values().iterator();
        while (i.hasNext()) {
            ((HTTPConnectionWrapper)i.next()).close();
        }
        this.m_httpConnectionWrappers.clear();
    }

    public void setLastResponse(HTTPResponse lastResponse) {
        this.m_lastResponse = lastResponse;
    }

    public HTTPResponse getLastResponse() {
        return this.m_lastResponse;
    }

    private static final class TimeAuthorityAdapter
    implements HTTPConnection.TimeAuthority {
        private final TimeAuthority m_timeAuthority;

        public TimeAuthorityAdapter(TimeAuthority timeAuthority) {
            this.m_timeAuthority = timeAuthority;
        }

        public long getTimeInMilliseconds() {
            return this.m_timeAuthority.getTimeInMilliseconds();
        }
    }
}

