/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.process;

import net.grinder.engine.process.StopWatch;
import net.grinder.util.TimeAuthority;

final class StopWatchImplementation
implements StopWatch {
    private final TimeAuthority m_timeAuthority;
    private long m_time;
    private long m_startTime = -1L;

    public StopWatchImplementation(TimeAuthority timeAuthority) {
        this.m_timeAuthority = timeAuthority;
    }

    public void start() {
        if (this.isRunning()) {
            throw new StopWatch.StopWatchRunningException("Already running");
        }
        this.m_startTime = this.m_timeAuthority.getTimeInMilliseconds();
    }

    public void stop() {
        if (!this.isRunning()) {
            throw new StopWatch.StopWatchNotRunningException("Not running");
        }
        this.m_time = this.m_time + this.m_timeAuthority.getTimeInMilliseconds() - this.m_startTime;
        this.m_startTime = -1L;
    }

    public void reset() throws StopWatch.StopWatchRunningException {
        if (this.isRunning()) {
            throw new StopWatch.StopWatchRunningException("Still running");
        }
        this.m_time = 0L;
    }

    public long getTime() {
        if (this.isRunning()) {
            throw new StopWatch.StopWatchRunningException("Still running");
        }
        return this.m_time;
    }

    public boolean isRunning() {
        return this.m_startTime != -1L;
    }

    public void add(StopWatch watch) {
        this.m_time += watch.getTime();
    }
}

