/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.packagecache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlException;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.python.core.Options;
import org.python.core.packagecache.PackageManager;
import org.python.util.Generic;

public abstract class CachedJarsPackageManager
extends PackageManager {
    private boolean indexModified;
    private Map<String, JarXEntry> jarfiles;
    private File cachedir;

    protected void message(String msg) {
    }

    protected void warning(String warn) {
    }

    protected void comment(String msg) {
    }

    protected void debug(String msg) {
    }

    protected static boolean filterByName$505cbf47(String name) {
        return name.indexOf(36) != -1;
    }

    protected static boolean filterByAccess$505cff18(int acc) {
        return (acc & 1) != 1;
    }

    private static String listToString(List<String> list) {
        int n = list.size();
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            ret.append(list.get(i));
            if (i >= n - 1) continue;
            ret.append(",");
        }
        return ret.toString();
    }

    private Map<String, String> getZipPackages(InputStream jarin) throws IOException {
        ZipEntry entry;
        Map<String, List[]> zipPackages = Generic.map();
        ZipInputStream zip = new ZipInputStream(jarin);
        while ((entry = zip.getNextEntry()) != null) {
            ZipInputStream zipInputStream = zip;
            ZipEntry zipEntry = entry;
            Map<String, List[]> map = zipPackages;
            CachedJarsPackageManager cachedJarsPackageManager = this;
            String string = zipEntry.getName();
            if (string.endsWith(".class")) {
                char c = '/';
                int n = string.lastIndexOf(47);
                if (n == -1) {
                    n = string.lastIndexOf(92);
                    c = '\\';
                }
                String string2 = n == -1 ? "" : string.substring(0, n).replace(c, '.');
                String string3 = string.substring(n + 1, string.length() - 6);
                if (!CachedJarsPackageManager.filterByName$505cbf47(string3)) {
                    int n2;
                    List[] listArray = (List[])map.get(string2);
                    if (listArray == null) {
                        listArray = new List[]{Generic.list(), Generic.list()};
                        map.put(string2, listArray);
                    }
                    if ((n2 = CachedJarsPackageManager.checkAccess(zipInputStream)) != -1 && !CachedJarsPackageManager.filterByAccess$505cff18(n2)) {
                        listArray[0].add(string3);
                    } else {
                        listArray[1].add(string3);
                    }
                }
            }
            zip.closeEntry();
        }
        Map<String, String> transformed = Generic.map();
        for (Map.Entry kv : zipPackages.entrySet()) {
            List[] vec = (List[])kv.getValue();
            String classes = CachedJarsPackageManager.listToString(vec[0]);
            if (vec[1].size() > 0) {
                classes = classes + '@' + CachedJarsPackageManager.listToString(vec[1]);
            }
            transformed.put((String)kv.getKey(), classes);
        }
        return transformed;
    }

    public final void addJarToPackages(File jarfile, boolean cache) {
        boolean bl = cache;
        File file = jarfile;
        Object var4_5 = null;
        CachedJarsPackageManager cachedJarsPackageManager = this;
        try {
            Object object;
            Map<String, String> map;
            boolean bl2 = cachedJarsPackageManager.jarfiles != null;
            URLConnection uRLConnection = null;
            boolean bl3 = true;
            if (file == null) {
                uRLConnection = ((URL)null).openConnection();
                if (uRLConnection.getURL().getProtocol().equals("file")) {
                    map = ((URL)null).getFile();
                    map = ((String)((Object)map)).replace('/', File.separatorChar);
                    file = new File((String)((Object)map));
                } else {
                    bl3 = false;
                }
            }
            if (bl3 && !file.exists()) {
                return;
            }
            map = null;
            long l = 0L;
            String string = null;
            JarXEntry jarXEntry = null;
            boolean bl4 = false;
            if (bl2) {
                if (bl3) {
                    l = file.lastModified();
                    string = file.getCanonicalPath();
                } else {
                    l = uRLConnection.getLastModified();
                    string = ((URL)null).toString();
                }
                jarXEntry = cachedJarsPackageManager.jarfiles.get(string);
                if ((jarXEntry == null || !new File(jarXEntry.cachefile).exists()) && bl) {
                    cachedJarsPackageManager.message("processing new jar, '" + string + "'");
                    if (bl3) {
                        object = file.getName();
                    } else {
                        object = ((URL)null).getFile();
                        int n = ((String)object).lastIndexOf(47);
                        if (n != -1) {
                            object = ((String)object).substring(n + 1);
                        }
                    }
                    object = ((String)object).substring(0, ((String)object).length() - 4);
                    jarXEntry = new JarXEntry((String)object);
                    cachedJarsPackageManager.jarfiles.put(string, jarXEntry);
                    bl4 = true;
                }
                if (l != 0L && jarXEntry != null && jarXEntry.mtime == l) {
                    map = cachedJarsPackageManager.readCacheFile(jarXEntry, string);
                }
            }
            if (map == null) {
                if (bl2 = bl2 && bl) {
                    cachedJarsPackageManager.indexModified = true;
                    if (jarXEntry.mtime != 0L) {
                        cachedJarsPackageManager.message("processing modified jar, '" + string + "'");
                    }
                    jarXEntry.mtime = l;
                }
                object = null;
                try {
                    object = uRLConnection == null ? new BufferedInputStream(new FileInputStream(file)) : uRLConnection.getInputStream();
                    map = cachedJarsPackageManager.getZipPackages((InputStream)object);
                }
                finally {
                    if (object != null) {
                        ((InputStream)object).close();
                    }
                }
                if (bl2) {
                    cachedJarsPackageManager.writeCacheFile(jarXEntry, string, map, bl4);
                }
            }
            cachedJarsPackageManager.addPackages(map, string);
            return;
        }
        catch (IOException iOException) {
            cachedJarsPackageManager.warning("skipping bad jar, '" + (file != null ? file.toString() : ((URL)null).toString()) + "'");
            return;
        }
    }

    private void addPackages(Map<String, String> zipPackages, String jarfile) {
        for (Map.Entry<String, String> entry : zipPackages.entrySet()) {
            String pkg = entry.getKey();
            String classes = entry.getValue();
            int idx = classes.indexOf(64);
            if (idx >= 0 && Options.respectJavaAccessibility) {
                classes = classes.substring(0, idx);
            }
            this.makeJavaPackage(pkg, classes, jarfile);
        }
    }

    private Map<String, String> readCacheFile(JarXEntry entry, String jarcanon) {
        FilterInputStream istream;
        block18: {
            String cachefile = entry.cachefile;
            long mtime = entry.mtime;
            this.debug("reading cache, '" + jarcanon + "'");
            istream = null;
            String string = cachefile;
            istream = new DataInputStream(new BufferedInputStream(new FileInputStream(string)));
            String old_jarcanon = ((DataInputStream)istream).readUTF();
            long old_mtime = ((DataInputStream)istream).readLong();
            if (old_jarcanon.equals(jarcanon) && old_mtime == mtime) break block18;
            this.comment("invalid cache file: " + cachefile + ", " + jarcanon + ":" + old_jarcanon + ", " + mtime + ":" + old_mtime);
            string = cachefile;
            new File(string).delete();
            try {
                istream.close();
            }
            catch (IOException iOException) {}
            return null;
        }
        try {
            Map<String, String> packs = Generic.map();
            try {
                while (true) {
                    String packageName = ((DataInputStream)istream).readUTF();
                    String classes = ((DataInputStream)istream).readUTF();
                    if (packs.containsKey(packageName)) {
                        classes = packs.get(packageName) + classes;
                    }
                    packs.put(packageName, classes);
                }
            }
            catch (EOFException eOFException) {
                Map<String, String> map = packs;
                try {
                    istream.close();
                }
                catch (IOException iOException) {}
                return map;
            }
        }
        catch (IOException iOException) {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException iOException2) {}
            }
            return null;
        }
        catch (Throwable throwable) {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeCacheFile(JarXEntry entry, String jarcanon, Map<String, String> zipPackages, boolean brandNew) {
        File file;
        FilterOutputStream ostream = null;
        boolean bl = brandNew;
        JarXEntry jarXEntry = entry;
        CachedJarsPackageManager cachedJarsPackageManager = this;
        if (bl) {
            int n = 1;
            String string = "";
            String string2 = jarXEntry.cachefile;
            while ((file = new File(cachedJarsPackageManager.cachedir, string2 + string + ".pkc")).exists()) {
                string = "$" + n;
                ++n;
            }
            jarXEntry.cachefile = file.getCanonicalPath();
        } else {
            file = new File(jarXEntry.cachefile);
        }
        ostream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        ((DataOutputStream)ostream).writeUTF(jarcanon);
        ((DataOutputStream)ostream).writeLong(entry.mtime);
        this.comment("rewriting cachefile for '" + jarcanon + "'");
        for (Map.Entry<String, String> kv : zipPackages.entrySet()) {
            String classes = kv.getValue();
            for (String part : CachedJarsPackageManager.splitString(classes, 65535)) {
                ((DataOutputStream)ostream).writeUTF(kv.getKey());
                ((DataOutputStream)ostream).writeUTF(part);
            }
        }
        try {
            ostream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
        catch (IOException iOException) {
            try {
                this.warning("can't write cache file for '" + jarcanon + "'");
                if (ostream == null) return;
            }
            catch (Throwable throwable) {
                if (ostream == null) throw throwable;
                try {
                    ostream.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                ostream.close();
                return;
            }
            catch (IOException iOException3) {
                return;
            }
        }
    }

    private static String[] splitString(String str, int maxLength) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len <= 65535) {
            return new String[]{str};
        }
        int chunkCount = (int)Math.ceil((float)len / 65535.0f);
        String[] chunks = new String[chunkCount];
        for (int i = 0; i < chunkCount; ++i) {
            chunks[i] = str.substring(i * 65535, Math.min(i * 65535 + 65535, len));
        }
        return chunks;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void initCache() {
        FilterInputStream istream;
        block17: {
            DataInputStream dataInputStream;
            this.indexModified = false;
            this.jarfiles = Generic.map();
            istream = null;
            CachedJarsPackageManager cachedJarsPackageManager = this;
            File file = new File(cachedJarsPackageManager.cachedir, "packages.idx");
            if (!file.exists()) {
                return;
            }
            FilterInputStream filterInputStream = istream = (dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file))));
            if (filterInputStream != null) break block17;
            if (istream == null) return;
            try {
                istream.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        try {
            try {
                while (true) {
                    String jarcanon = ((DataInputStream)istream).readUTF();
                    String cachefile = ((DataInputStream)istream).readUTF();
                    long mtime = ((DataInputStream)istream).readLong();
                    this.jarfiles.put(jarcanon, new JarXEntry(cachefile, mtime));
                }
            }
            catch (EOFException eOFException) {
                if (istream == null) return;
                try {
                    istream.close();
                    return;
                }
                catch (IOException iOException) {
                    return;
                }
            }
        }
        catch (IOException iOException) {
            try {
                this.warning("invalid index file");
                if (istream == null) return;
            }
            catch (Throwable throwable) {
                if (istream == null) throw throwable;
                try {
                    istream.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                istream.close();
                return;
            }
            catch (IOException iOException3) {
                return;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void saveCache() {
        if (this.jarfiles == null || !this.indexModified) {
            return;
        }
        this.indexModified = false;
        this.comment("writing modified index file");
        FilterOutputStream ostream = null;
        CachedJarsPackageManager cachedJarsPackageManager = this;
        File file = new File(cachedJarsPackageManager.cachedir, "packages.idx");
        ostream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        for (Map.Entry<String, JarXEntry> entry : this.jarfiles.entrySet()) {
            String jarcanon = entry.getKey();
            JarXEntry xentry = entry.getValue();
            ((DataOutputStream)ostream).writeUTF(jarcanon);
            ((DataOutputStream)ostream).writeUTF(xentry.cachefile);
            ((DataOutputStream)ostream).writeLong(xentry.mtime);
        }
        try {
            ostream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
        catch (IOException iOException) {
            try {
                this.warning("can't write index file");
                if (ostream == null) return;
            }
            catch (Throwable throwable) {
                if (ostream == null) throw throwable;
                try {
                    ostream.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                ostream.close();
                return;
            }
            catch (IOException iOException3) {
                return;
            }
        }
    }

    protected final boolean useCacheDir(File aCachedir1) {
        if (aCachedir1 == null) {
            return false;
        }
        try {
            if (!aCachedir1.isDirectory() && !aCachedir1.mkdirs()) {
                this.warning("can't create package cache dir, '" + aCachedir1 + "'");
                return false;
            }
        }
        catch (AccessControlException accessControlException) {
            this.warning("The java security manager isn't allowing access to the package cache dir, '" + aCachedir1 + "'");
            return false;
        }
        this.cachedir = aCachedir1;
        return true;
    }

    public static class JarXEntry {
        public String cachefile;
        public long mtime;

        public JarXEntry(String cachefile) {
            this.cachefile = cachefile;
        }

        public JarXEntry(String cachefile, long mtime) {
            this.cachefile = cachefile;
            this.mtime = mtime;
        }
    }
}

