/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix;

import java.io.FileDescriptor;
import jnr.constants.platform.Errno;
import jnr.constants.platform.Sysconf;
import jnr.ffi.Pointer;
import jnr.ffi.mapper.FromNativeContext;
import jnr.posix.BaseNativePOSIX;
import jnr.posix.FileStat;
import jnr.posix.LibCProvider;
import jnr.posix.NativeTimes;
import jnr.posix.POSIXHandler;
import jnr.posix.SolarisFileStat32;
import jnr.posix.SolarisFileStat64;
import jnr.posix.SolarisPasswd;
import jnr.posix.Times;
import jnr.posix.util.Platform;

final class SolarisPOSIX
extends BaseNativePOSIX {
    public static final BaseNativePOSIX.PointerConverter PASSWD = new BaseNativePOSIX.PointerConverter(){

        public final Object fromNative(Object arg, FromNativeContext ctx) {
            if (arg != null) {
                return new SolarisPasswd((Pointer)arg);
            }
            return null;
        }
    };

    SolarisPOSIX(String libraryName, LibCProvider libc, POSIXHandler handler) {
        super(libraryName, libc, handler);
    }

    public final FileStat allocateStat() {
        if (Platform.IS_32_BIT) {
            return new SolarisFileStat32(this);
        }
        return new SolarisFileStat64(this);
    }

    public final FileStat fstat(FileDescriptor fileDescriptor) {
        FileStat stat = this.allocateStat();
        int fd = this.helper.getfd(fileDescriptor);
        if ((Platform.IS_32_BIT ? this.libc().fstat64(fd, stat) : this.libc().fstat(fd, stat)) < 0) {
            this.handler.error(Errno.ENOENT, "" + fd);
        }
        return stat;
    }

    public final int lchmod(String filename, int mode) {
        this.handler.unimplementedError("lchmod");
        return -1;
    }

    public final int lstat(String path, FileStat stat) {
        if (Platform.IS_32_BIT) {
            return this.libc().lstat64(path, stat);
        }
        return this.libc().lstat(path, stat);
    }

    public final int stat(String path, FileStat stat) {
        if (Platform.IS_32_BIT) {
            return this.libc().stat64(path, stat);
        }
        return this.libc().stat(path, stat);
    }

    public final long sysconf(Sysconf name) {
        return this.libc().sysconf(name);
    }

    public final Times times() {
        return NativeTimes.times(this);
    }
}

