/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix;

import jnr.ffi.Memory;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.StructLayout;
import jnr.posix.BaseNativePOSIX;
import jnr.posix.NativePOSIX;
import jnr.posix.Times;

final class NativeTimes
implements Times {
    private static final Layout layout = new Layout(Runtime.getSystemRuntime());
    final Pointer memory;

    static NativeTimes times(BaseNativePOSIX posix) {
        NativeTimes tms = new NativeTimes(posix);
        if (posix.libc().times(tms) < 0L) {
            return null;
        }
        return tms;
    }

    private NativeTimes(NativePOSIX posix) {
        this.memory = Memory.allocate(posix.getRuntime(), layout.size());
    }

    public final long utime() {
        return NativeTimes.layout.tms_utime.get(this.memory);
    }

    public final long stime() {
        return NativeTimes.layout.tms_stime.get(this.memory);
    }

    public final long cutime() {
        return NativeTimes.layout.tms_cutime.get(this.memory);
    }

    public final long cstime() {
        return NativeTimes.layout.tms_cstime.get(this.memory);
    }

    static final class Layout
    extends StructLayout {
        public final StructLayout.clock_t tms_utime = new StructLayout.clock_t(this);
        public final StructLayout.clock_t tms_stime = new StructLayout.clock_t(this);
        public final StructLayout.clock_t tms_cutime = new StructLayout.clock_t(this);
        public final StructLayout.clock_t tms_cstime = new StructLayout.clock_t(this);

        Layout(Runtime runtime) {
            super(runtime);
        }
    }
}

