/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.statistics;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.grinder.statistics.ExpressionView;

public final class StatisticsView {
    private static final Comparator s_expressionViewComparator = new CreationOrderComparator();
    private final Set m_unique = new HashSet();
    private final SortedSet m_columns = new TreeSet(s_expressionViewComparator);

    public synchronized void add(StatisticsView other) {
        Iterator iterator = other.m_columns.iterator();
        while (iterator.hasNext()) {
            this.add((ExpressionView)iterator.next());
        }
    }

    public synchronized void add(ExpressionView statistic) {
        if (!this.m_unique.contains(statistic)) {
            this.m_unique.add(statistic);
            this.m_columns.add(statistic);
        }
    }

    public synchronized ExpressionView[] getExpressionViews() {
        return this.m_columns.toArray(new ExpressionView[this.m_columns.size()]);
    }

    static final class CreationOrderComparator
    implements Comparator {
        CreationOrderComparator() {
        }

        public int compare(Object a, Object b) {
            ExpressionView viewA = (ExpressionView)a;
            ExpressionView viewB = (ExpressionView)b;
            if (viewA.getCreationOrder() < viewB.getCreationOrder()) {
                return -1;
            }
            if (viewA.getCreationOrder() > viewB.getCreationOrder()) {
                return 1;
            }
            return 0;
        }
    }
}

