/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import net.grinder.common.GrinderException;
import net.grinder.common.Test;
import net.grinder.console.common.ErrorHandler;
import net.grinder.console.common.Resources;
import net.grinder.console.model.ConsoleProperties;
import net.grinder.console.model.ModelTestIndex;
import net.grinder.console.model.SampleAccumulator;
import net.grinder.console.model.SampleListener;
import net.grinder.console.model.SampleModel;
import net.grinder.statistics.PeakStatisticExpression;
import net.grinder.statistics.StatisticExpression;
import net.grinder.statistics.StatisticExpressionFactory;
import net.grinder.statistics.StatisticsIndexMap;
import net.grinder.statistics.StatisticsServices;
import net.grinder.statistics.StatisticsSet;
import net.grinder.statistics.TestStatisticsMap;
import net.grinder.util.ListenerSupport;

public final class SampleModelImplementation
implements SampleModel {
    private final ConsoleProperties m_properties;
    private final StatisticsServices m_statisticsServices;
    private final Timer m_timer;
    private final ErrorHandler m_errorHandler;
    private final String m_stateIgnoringString;
    private final String m_stateWaitingString;
    private final String m_stateStoppedString;
    private final String m_stateCapturingString;
    private final String m_unknownTestString;
    private final Set m_tests = new TreeSet();
    private final ListenerSupport m_listeners = new ListenerSupport();
    private final StatisticsIndexMap.LongIndex m_periodIndex;
    private final StatisticExpression m_tpsExpression;
    private final PeakStatisticExpression m_peakTPSExpression;
    private final SampleAccumulator m_totalSampleAccumulator;
    private final Map m_accumulators = Collections.synchronizedMap(new HashMap());
    private InternalState m_state;

    public SampleModelImplementation(ConsoleProperties properties, StatisticsServices statisticsServices, Timer timer, Resources resources, ErrorHandler errorHandler) throws GrinderException {
        this.m_properties = properties;
        this.m_statisticsServices = statisticsServices;
        this.m_timer = timer;
        this.m_errorHandler = errorHandler;
        this.m_stateIgnoringString = resources.getString("state.ignoring.label") + ' ';
        this.m_stateWaitingString = resources.getString("state.waiting.label");
        this.m_stateStoppedString = resources.getString("state.stopped.label");
        this.m_stateCapturingString = resources.getString("state.capturing.label") + ' ';
        this.m_unknownTestString = resources.getString("ignoringUnknownTest.text");
        StatisticsIndexMap indexMap = statisticsServices.getStatisticsIndexMap();
        this.m_periodIndex = indexMap.getLongIndex("period");
        StatisticExpressionFactory statisticExpressionFactory = this.m_statisticsServices.getStatisticExpressionFactory();
        this.m_tpsExpression = statisticsServices.getTPSExpression();
        this.m_peakTPSExpression = statisticExpressionFactory.createPeak(indexMap.getDoubleIndex("peakTPS"), this.m_tpsExpression);
        this.m_totalSampleAccumulator = new SampleAccumulator(this.m_peakTPSExpression, this.m_periodIndex, this.m_statisticsServices.getStatisticsSetFactory());
        this.setInternalState(new WaitingForTriggerState());
    }

    public StatisticExpression getTPSExpression() {
        return this.m_tpsExpression;
    }

    public StatisticExpression getPeakTPSExpression() {
        return this.m_peakTPSExpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTests(Collection tests) {
        Test[] testArray;
        final HashSet newTests = new HashSet(tests);
        Set set = this.m_tests;
        synchronized (set) {
            newTests.removeAll(this.m_tests);
            if (newTests.size() == 0) {
                return;
            }
            this.m_tests.addAll(newTests);
            testArray = this.m_tests.toArray(new Test[this.m_tests.size()]);
        }
        SampleAccumulator[] accumulatorArray = new SampleAccumulator[testArray.length];
        Iterator newTestIterator = newTests.iterator();
        Map map = this.m_accumulators;
        synchronized (map) {
            while (newTestIterator.hasNext()) {
                this.m_accumulators.put(newTestIterator.next(), new SampleAccumulator(this.m_peakTPSExpression, this.m_periodIndex, this.m_statisticsServices.getStatisticsSetFactory()));
            }
            for (int i = 0; i < accumulatorArray.length; ++i) {
                accumulatorArray[i] = (SampleAccumulator)this.m_accumulators.get(testArray[i]);
            }
        }
        final ModelTestIndex modelTestIndex = new ModelTestIndex(testArray, accumulatorArray);
        this.m_listeners.apply(new ListenerSupport.Informer(){

            public void inform(Object listener) {
                ((SampleModel.Listener)listener).newTests(newTests, modelTestIndex);
            }
        });
    }

    public StatisticsSet getTotalCumulativeStatistics() {
        return this.m_totalSampleAccumulator.getCumulativeStatistics();
    }

    public void addModelListener(SampleModel.Listener listener) {
        this.m_listeners.add(listener);
    }

    public void addSampleListener(Test test, SampleListener listener) {
        SampleAccumulator sampleAccumulator = (SampleAccumulator)this.m_accumulators.get(test);
        if (sampleAccumulator != null) {
            sampleAccumulator.addSampleListener(listener);
        }
    }

    public void addTotalSampleListener(SampleListener listener) {
        this.m_totalSampleAccumulator.addSampleListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Set set = this.m_tests;
        synchronized (set) {
            this.m_tests.clear();
        }
        this.m_accumulators.clear();
        this.m_totalSampleAccumulator.zero();
        this.m_listeners.apply(new ListenerSupport.Informer(){

            public void inform(Object listener) {
                ((SampleModel.Listener)listener).resetTests();
            }
        });
    }

    public void start() {
        this.getInternalState().start();
    }

    public void stop() {
        this.getInternalState().stop();
    }

    public void addTestReport(TestStatisticsMap testStatisticsMap) {
        this.getInternalState().newTestReport(testStatisticsMap);
    }

    public SampleModel.State getState() {
        return this.getInternalState().toExternalState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zero() {
        Map map = this.m_accumulators;
        synchronized (map) {
            Iterator iterator = this.m_accumulators.values().iterator();
            while (iterator.hasNext()) {
                SampleAccumulator sampleAccumulator = (SampleAccumulator)iterator.next();
                sampleAccumulator.zero();
            }
        }
        this.m_totalSampleAccumulator.zero();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InternalState getInternalState() {
        SampleModelImplementation sampleModelImplementation = this;
        synchronized (sampleModelImplementation) {
            return this.m_state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInternalState(InternalState newState) {
        SampleModelImplementation sampleModelImplementation = this;
        synchronized (sampleModelImplementation) {
            this.m_state = newState;
        }
        this.m_listeners.apply(new ListenerSupport.Informer(){

            public void inform(Object listener) {
                ((SampleModel.Listener)listener).stateChanged();
            }
        });
    }

    static /* synthetic */ String access$1000(SampleModelImplementation x0) {
        return x0.m_unknownTestString;
    }

    static /* synthetic */ ErrorHandler access$1100(SampleModelImplementation x0) {
        return x0.m_errorHandler;
    }

    private final class CapturingState
    extends SamplingState {
        public CapturingState() {
            SampleModelImplementation.this.zero();
            this.schedule();
        }

        protected boolean shouldAccumulateSamples() {
            return true;
        }

        protected InternalState nextState() {
            int collectSampleCount = SampleModelImplementation.this.m_properties.getCollectSampleCount();
            if (collectSampleCount != 0 && this.getSampleCount() > (long)collectSampleCount) {
                return new StoppedState();
            }
            return this;
        }

        public String getDescription() {
            return SampleModelImplementation.this.m_stateCapturingString + this.getSampleCount();
        }

        public boolean isCapturing() {
            return true;
        }
    }

    private final class TriggeredState
    extends SamplingState {
        public TriggeredState() {
            this.schedule();
        }

        protected boolean shouldAccumulateSamples() {
            return false;
        }

        protected InternalState nextState() {
            if (this.getSampleCount() > (long)SampleModelImplementation.this.m_properties.getIgnoreSampleCount()) {
                return new CapturingState();
            }
            return this;
        }

        public String getDescription() {
            return SampleModelImplementation.this.m_stateIgnoringString + this.getSampleCount();
        }
    }

    private abstract class SamplingState
    extends AbstractInternalState {
        private long m_lastTime;
        private volatile long m_sampleCount;

        private SamplingState() {
            this.m_lastTime = 0L;
            this.m_sampleCount = 1L;
        }

        public void newTestReport(TestStatisticsMap testStatisticsMap) {
            new TestStatisticsMap.ForEach(this, testStatisticsMap){
                private final /* synthetic */ SamplingState this$1;
                {
                    this.this$1 = this$1;
                    super(x0);
                }

                public void next(Test test, StatisticsSet statistics) {
                    SampleAccumulator sampleAccumulator = (SampleAccumulator)SampleModelImplementation.access$900(SamplingState.access$800(this.this$1)).get(test);
                    if (sampleAccumulator == null) {
                        SampleModelImplementation.access$1100(SamplingState.access$800(this.this$1)).handleInformationMessage(SampleModelImplementation.access$1000(SamplingState.access$800(this.this$1)) + " " + test);
                    } else {
                        sampleAccumulator.addIntervalStatistics(statistics);
                        if (this.this$1.shouldAccumulateSamples()) {
                            sampleAccumulator.addCumulativeStaticstics(statistics);
                        }
                        if (!statistics.isComposite()) {
                            SampleModelImplementation.access$1200(SamplingState.access$800(this.this$1)).addIntervalStatistics(statistics);
                            if (this.this$1.shouldAccumulateSamples()) {
                                SampleModelImplementation.access$1200(SamplingState.access$800(this.this$1)).addCumulativeStaticstics(statistics);
                            }
                        }
                    }
                }
            }.iterate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void schedule() {
            SamplingState samplingState = this;
            synchronized (samplingState) {
                if (this.m_lastTime == 0L) {
                    this.m_lastTime = System.currentTimeMillis();
                }
            }
            SampleModelImplementation.this.m_timer.schedule(new TimerTask(this){
                private final /* synthetic */ SamplingState this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    this.this$1.sample();
                }
            }, SampleModelImplementation.this.m_properties.getSampleInterval());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void sample() {
            SamplingState samplingState;
            if (!this.isActiveState()) {
                return;
            }
            try {
                long period;
                SamplingState samplingState2 = this;
                synchronized (samplingState2) {
                    period = System.currentTimeMillis() - this.m_lastTime;
                }
                long sampleInterval = SampleModelImplementation.this.m_properties.getSampleInterval();
                Map map = SampleModelImplementation.this.m_accumulators;
                synchronized (map) {
                    Iterator iterator = SampleModelImplementation.this.m_accumulators.values().iterator();
                    while (iterator.hasNext()) {
                        SampleAccumulator sampleAccumulator = (SampleAccumulator)iterator.next();
                        sampleAccumulator.fireSample(sampleInterval, period);
                    }
                }
                SampleModelImplementation.this.m_totalSampleAccumulator.fireSample(sampleInterval, period);
                ++this.m_sampleCount;
                SampleModelImplementation.this.setInternalState(this.nextState());
                SampleModelImplementation.this.m_listeners.apply(new ListenerSupport.Informer(this){
                    private final /* synthetic */ SamplingState this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void inform(Object listener) {
                        ((SampleModel.Listener)listener).newSample();
                    }
                });
                Object var10_9 = null;
                samplingState = this;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                SamplingState samplingState3 = this;
                synchronized (samplingState3) {
                    if (this.isActiveState()) {
                        this.schedule();
                    }
                }
                throw throwable;
            }
            synchronized (samplingState) {
                if (this.isActiveState()) {
                    this.schedule();
                }
            }
        }

        public final long getSampleCount() {
            return this.m_sampleCount;
        }

        protected abstract boolean shouldAccumulateSamples();

        protected abstract InternalState nextState();

        static /* synthetic */ SampleModelImplementation access$800(SamplingState x0) {
            return x0.SampleModelImplementation.this;
        }
    }

    private final class StoppedState
    extends AbstractInternalState {
        private StoppedState() {
        }

        public void newTestReport(TestStatisticsMap testStatisticsMap) {
        }

        public String getDescription() {
            return SampleModelImplementation.this.m_stateStoppedString;
        }

        public boolean isStopped() {
            return true;
        }
    }

    private final class WaitingForTriggerState
    extends AbstractInternalState {
        public WaitingForTriggerState() {
            SampleModelImplementation.this.zero();
        }

        public void newTestReport(TestStatisticsMap testStatisticsMap) {
            if (SampleModelImplementation.this.m_properties.getIgnoreSampleCount() == 0) {
                SampleModelImplementation.this.setInternalState(new CapturingState());
            } else {
                SampleModelImplementation.this.setInternalState(new TriggeredState());
            }
            SampleModelImplementation.this.getInternalState().newTestReport(testStatisticsMap);
        }

        public String getDescription() {
            return SampleModelImplementation.this.m_stateWaitingString;
        }
    }

    private abstract class AbstractInternalState
    implements InternalState,
    SampleModel.State {
        private AbstractInternalState() {
        }

        protected final boolean isActiveState() {
            return SampleModelImplementation.this.getInternalState() == this;
        }

        public SampleModel.State toExternalState() {
            return this;
        }

        public void start() {
            SampleModelImplementation.this.setInternalState(new WaitingForTriggerState());
        }

        public void stop() {
            SampleModelImplementation.this.setInternalState(new StoppedState());
        }

        public boolean isCapturing() {
            return false;
        }

        public boolean isStopped() {
            return false;
        }
    }

    private static interface InternalState {
        public SampleModel.State toExternalState();

        public void start();

        public void stop();

        public void newTestReport(TestStatisticsMap var1);
    }
}

