/*
 * Decompiled with CFR 0.152.
 */
package net.grinder;

import java.io.File;
import java.io.PrintWriter;
import net.grinder.common.GrinderException;
import net.grinder.common.Logger;
import net.grinder.engine.agent.Agent;
import net.grinder.engine.agent.AgentDaemon;
import net.grinder.engine.agent.AgentImplementation;
import net.grinder.util.AbstractMainClass;
import net.grinder.util.JVM;
import net.grinder.util.SimpleLogger;

public final class Grinder
extends AbstractMainClass {
    private static final String USAGE = "\n  java " + Grinder.class + " <options> [alternatePropertiesFilename]" + "\n\n" + "Options:" + "\n  [-daemon [n]]                Run agent in deamon mode; try to" + "\n                               reconnect every n seconds (default 60)." + "\n\n";
    private final Agent m_agent;

    public static void main(String[] args) {
        SimpleLogger logger = new SimpleLogger("agent", new PrintWriter(System.out), new PrintWriter(System.err));
        try {
            if (!JVM.getInstance().haveRequisites(logger)) {
                System.exit(3);
            }
            Grinder grinder = new Grinder(args, logger);
            grinder.run();
        }
        catch (AbstractMainClass.LoggedInitialisationException e) {
            System.exit(1);
        }
        catch (Throwable e) {
            PrintWriter errorWriter = logger.getErrorLogWriter();
            e.printStackTrace(errorWriter);
            errorWriter.flush();
            System.exit(2);
        }
        System.exit(0);
    }

    private Grinder(String[] args, Logger logger) throws GrinderException {
        super(logger, USAGE);
        File propertiesFile = null;
        long daemonPeriod = -1L;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-daemon")) {
                daemonPeriod = 60000L;
                try {
                    daemonPeriod = Integer.parseInt(args[i + 1]) * 1000;
                    ++i;
                }
                catch (IndexOutOfBoundsException e) {
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (i == args.length - 1 && !args[i].startsWith("-")) {
                propertiesFile = new File(args[i]);
                continue;
            }
            throw this.barfUsage();
        }
        this.m_agent = daemonPeriod > -1L ? new AgentDaemon(logger, daemonPeriod, new AgentImplementation(logger, propertiesFile, false)) : new AgentImplementation(logger, propertiesFile, true);
    }

    private void run() throws GrinderException {
        this.m_agent.run();
        this.m_agent.shutdown();
    }
}

