/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.agent;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import net.grinder.common.GrinderProperties;
import net.grinder.engine.process.WorkerProcessEntryPoint;

final class WorkerProcessCommandLine {
    private final List m_command = new ArrayList();
    private final int m_commandClassIndex;
    private static final Set s_unquoted = new HashSet(){
        {
            this.add("-classpath");
            this.add("-client");
            this.add("-cp");
            this.add("-jar");
            this.add("-server");
        }
    };

    public WorkerProcessCommandLine(GrinderProperties properties, Properties systemProperties, String jvmArguments) {
        this.m_command.add(properties.getProperty("grinder.jvm", "java"));
        if (jvmArguments != null) {
            StringTokenizer tokenizer = new StringTokenizer(jvmArguments);
            while (tokenizer.hasMoreTokens()) {
                this.m_command.add(tokenizer.nextToken());
            }
        }
        String additionalClasspath = properties.getProperty("grinder.jvm.classpath", null);
        String systemClasspath = systemProperties.getProperty("java.class.path");
        StringBuffer classpath = new StringBuffer();
        if (additionalClasspath != null) {
            classpath.append(additionalClasspath);
        }
        if (additionalClasspath != null && systemClasspath != null) {
            classpath.append(File.pathSeparatorChar);
        }
        if (systemClasspath != null) {
            classpath.append(systemClasspath);
        }
        if (classpath.length() > 0) {
            this.m_command.add("-classpath");
            this.m_command.add(classpath.toString());
        }
        this.m_commandClassIndex = this.m_command.size();
        this.m_command.add(WorkerProcessEntryPoint.class.getName());
    }

    public String[] getCommandArray() {
        return this.m_command.toArray(new String[this.m_command.size()]);
    }

    List getCommandList() {
        return this.m_command;
    }

    public String toString() {
        String[] commandArray = this.getCommandArray();
        StringBuffer buffer = new StringBuffer(commandArray.length * 10);
        for (int j = 0; j < commandArray.length; ++j) {
            boolean shouldQuote;
            if (j != 0) {
                buffer.append(" ");
            }
            boolean bl = shouldQuote = j != 0 && j != this.m_commandClassIndex && !s_unquoted.contains(commandArray[j]);
            if (shouldQuote) {
                buffer.append("'");
            }
            buffer.append(commandArray[j]);
            if (!shouldQuote) continue;
            buffer.append("'");
        }
        return buffer.toString();
    }
}

